/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.folderstorage.internal.performers;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.composition.FilenameValidationUtils;
import com.openexchange.folderstorage.ContentType;
import com.openexchange.folderstorage.Folder;
import com.openexchange.folderstorage.FolderExceptionErrorMessage;
import com.openexchange.folderstorage.FolderServiceDecorator;
import com.openexchange.folderstorage.FolderStorage;
import com.openexchange.folderstorage.FolderStorageDiscoverer;
import com.openexchange.folderstorage.Permission;
import com.openexchange.folderstorage.SortableId;
import com.openexchange.folderstorage.UserizedFolder;
import com.openexchange.folderstorage.database.contentType.InfostoreContentType;
import com.openexchange.folderstorage.internal.CalculatePermission;
import com.openexchange.folderstorage.internal.performers.AbstractUserizedFolderPerformer;
import com.openexchange.folderstorage.internal.performers.ComparedFolderPermissions;
import com.openexchange.folderstorage.mail.contentType.MailContentType;
import com.openexchange.folderstorage.outlook.DuplicateCleaner;
import com.openexchange.folderstorage.outlook.OutlookFolderStorage;
import com.openexchange.folderstorage.tx.TransactionManager;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.java.Strings;
import com.openexchange.mail.utils.MailFolderUtility;
import com.openexchange.session.Session;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public final class CreatePerformer
extends AbstractUserizedFolderPerformer {
    private static final String CONTENT_TYPE_MAIL = MailContentType.getInstance().toString();

    public CreatePerformer(ServerSession session, FolderServiceDecorator decorator) throws OXException {
        super(session, decorator);
    }

    public CreatePerformer(User user, Context context, FolderServiceDecorator decorator) {
        super(user, context, decorator);
    }

    public CreatePerformer(ServerSession session, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) throws OXException {
        super(session, decorator, folderStorageDiscoverer);
    }

    public CreatePerformer(User user, Context context, FolderServiceDecorator decorator, FolderStorageDiscoverer folderStorageDiscoverer) {
        super(user, context, decorator, folderStorageDiscoverer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doCreate(Folder toCreate) throws OXException {
        String parentId;
        if (InfostoreContentType.getInstance().equals(toCreate.getContentType()) && Strings.isNotEmpty((String)toCreate.getName())) {
            FilenameValidationUtils.checkCharacters((String)toCreate.getName());
            FilenameValidationUtils.checkName((String)toCreate.getName());
        }
        if (null == (parentId = toCreate.getParentID())) {
            throw FolderExceptionErrorMessage.MISSING_PARENT_ID.create(new Object[0]);
        }
        String treeId = toCreate.getTreeID();
        if (null == treeId) {
            throw FolderExceptionErrorMessage.MISSING_TREE_ID.create(new Object[0]);
        }
        if (!KNOWN_TREES.contains(treeId)) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create("Create not supported by tree " + treeId);
        }
        FolderStorage parentStorage = this.folderStorageDiscoverer.getFolderStorage(treeId, parentId);
        if (null == parentStorage) {
            throw FolderExceptionErrorMessage.NO_STORAGE_FOR_ID.create(treeId, parentId);
        }
        TransactionManager transactionManager = TransactionManager.initTransaction(this.storageParameters);
        boolean rollbackTransaction = true;
        List<FolderStorage> openedStorages = Collections.emptyList();
        this.checkOpenedStorage(parentStorage, openedStorages);
        try {
            String duplicateId;
            String newId;
            boolean isRecursion;
            Folder parent = parentStorage.getFolder(treeId, parentId, this.storageParameters);
            Permission parentPermission = CalculatePermission.calculate(parent, this, (List<ContentType>)ALL_ALLOWED);
            if (!parentPermission.isVisible()) {
                throw FolderExceptionErrorMessage.FOLDER_NOT_VISIBLE.create(this.getFolderInfo4Error(parent), this.getUserInfo4Error(), this.getContextInfo4Error());
            }
            ContentType contentType = toCreate.getContentType();
            if (null == contentType) {
                throw AjaxExceptionCodes.MISSING_FIELD.create("module");
            }
            String cts = contentType.toString();
            if (CreatePerformer.isPublicPimFolder(parent) && CONTENT_TYPE_MAIL.equals(cts)) {
                throw FolderExceptionErrorMessage.NO_PUBLIC_MAIL_FOLDER.create();
            }
            UserizedFolder existingFolder = this.checkForEqualName(treeId, parentId, toCreate, toCreate.getContentType(), true);
            if (null != existingFolder) {
                if (null != this.session && "USM-JSON".equals(this.session.getClient())) {
                    String string = existingFolder.getID();
                    return string;
                }
                throw FolderExceptionErrorMessage.EQUAL_NAME.create(toCreate.getName(), parent.getLocalizedName(this.getLocale()), treeId);
            }
            String reservedName = this.checkForReservedName(treeId, parentId, toCreate, toCreate.getContentType(), false);
            if (null != reservedName) {
                throw FolderExceptionErrorMessage.RESERVED_NAME.create(toCreate.getName());
            }
            boolean addedDecorator = false;
            FolderServiceDecorator decorator = this.storageParameters.getDecorator();
            if (decorator == null) {
                decorator = new FolderServiceDecorator();
                this.storageParameters.setDecorator(decorator);
                addedDecorator = true;
            }
            if (!(isRecursion = decorator.containsProperty(RECURSION_MARKER))) {
                decorator.put(RECURSION_MARKER, true);
            }
            Permission[] permissions = toCreate.getPermissions();
            ComparedFolderPermissions comparedPermissions = new ComparedFolderPermissions((Session)this.session, permissions, new Permission[0]);
            try {
                newId = FolderStorage.REAL_TREE_ID.equals(toCreate.getTreeID()) ? this.doCreateReal(toCreate, parentId, treeId, parentStorage, transactionManager, comparedPermissions) : this.doCreateVirtual(toCreate, parentId, treeId, parentStorage, openedStorages, transactionManager, comparedPermissions);
            }
            finally {
                if (!isRecursion) {
                    decorator.remove(RECURSION_MARKER);
                }
                if (addedDecorator) {
                    this.storageParameters.setDecorator(null);
                }
            }
            transactionManager.commit();
            rollbackTransaction = false;
            if (!FolderStorage.REAL_TREE_ID.equals(toCreate.getTreeID()) && null != (duplicateId = DuplicateCleaner.cleanDuplicates(treeId, this.storageParameters, newId))) {
                throw FolderExceptionErrorMessage.EQUAL_NAME.create(toCreate.getName(), parent.getLocalizedName(this.getLocale()), treeId);
            }
            Set<OXException> warnings = this.storageParameters.getWarnings();
            if (null != warnings) {
                for (OXException warning : warnings) {
                    this.addWarning(warning);
                }
            }
            String string = newId;
            return string;
        }
        catch (OXException e) {
            throw e;
        }
        catch (Exception e) {
            throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollbackTransaction) {
                transactionManager.rollback();
            }
        }
    }

    private String doCreateReal(Folder toCreate, String parentId, String treeId, FolderStorage parentStorage, TransactionManager transactionManager, ComparedFolderPermissions comparedPermissions) throws OXException {
        ContentType[] contentTypes = parentStorage.getSupportedContentTypes();
        boolean supported = false;
        ContentType folderContentType = toCreate.getContentType();
        if (0 < contentTypes.length) {
            String cts = folderContentType.toString();
            for (ContentType contentType : contentTypes) {
                if (!contentType.toString().equals(cts)) continue;
                supported = true;
                break;
            }
        } else {
            supported = true;
        }
        if (!supported) {
            throw FolderExceptionErrorMessage.INVALID_CONTENT_TYPE.create(parentId, folderContentType.toString(), treeId, this.user.getId(), this.context.getContextId());
        }
        this.checkGuestPermissions(toCreate, comparedPermissions);
        if (comparedPermissions.hasNewGuests()) {
            List plainPermissions = comparedPermissions.getAddedPermissions();
            Folder plainFolder = (Folder)toCreate.clone();
            plainFolder.setPermissions(plainPermissions.toArray(new Permission[plainPermissions.size()]));
            parentStorage.createFolder(plainFolder, this.storageParameters);
            String folderID = plainFolder.getID();
            this.processAddedGuestPermissions(folderID, plainFolder.getContentType(), comparedPermissions, transactionManager.getConnection());
            toCreate.setID(folderID);
            toCreate.setLastModified(plainFolder.getLastModified());
            parentStorage.updateFolder(toCreate, this.storageParameters);
        } else {
            parentStorage.createFolder(toCreate, this.storageParameters);
        }
        return toCreate.getID();
    }

    private String doCreateVirtual(Folder toCreate, String parentId, String treeId, FolderStorage virtualStorage, List<FolderStorage> openedStorages, TransactionManager transactionManager, ComparedFolderPermissions comparedPermissions) throws OXException {
        ContentType folderContentType = toCreate.getContentType();
        FolderStorage realStorage = this.folderStorageDiscoverer.getFolderStorage(FolderStorage.REAL_TREE_ID, parentId);
        if (realStorage.equals(virtualStorage)) {
            this.doCreateReal(toCreate, parentId, FolderStorage.REAL_TREE_ID, realStorage, transactionManager, comparedPermissions);
        } else if (CreatePerformer.supportsContentType(folderContentType, realStorage)) {
            this.checkOpenedStorage(realStorage, openedStorages);
            this.doCreateReal(toCreate, parentId, FolderStorage.REAL_TREE_ID, realStorage, transactionManager, comparedPermissions);
            virtualStorage.createFolder(toCreate, this.storageParameters);
        } else {
            boolean found;
            List<ContentType> contentTypes;
            String rootId;
            Folder rootFolder;
            Permission rootPermission;
            FolderStorage capStorage = this.folderStorageDiscoverer.getFolderStorageByContentType(FolderStorage.REAL_TREE_ID, folderContentType);
            if (null == capStorage) {
                throw FolderExceptionErrorMessage.NO_STORAGE_FOR_CT.create(FolderStorage.REAL_TREE_ID, folderContentType.toString());
            }
            this.checkOpenedStorage(capStorage, openedStorages);
            if (FolderStorage.PRIVATE_ID.equals(parentId) && CONTENT_TYPE_MAIL.equals(folderContentType.toString()) && (rootPermission = CalculatePermission.calculate(rootFolder = capStorage.getFolder(treeId, rootId = MailFolderUtility.prepareFullname(0, "default"), this.storageParameters), this, contentTypes = Collections.emptyList())).getFolderPermission() >= 8) {
                Folder clone4Real = (Folder)toCreate.clone();
                clone4Real.setParentID(rootId);
                capStorage.createFolder(clone4Real, this.storageParameters);
                toCreate.setID(clone4Real.getID());
                boolean started = realStorage.startTransaction(this.storageParameters, true);
                try {
                    realStorage.updateLastModified(System.currentTimeMillis(), FolderStorage.REAL_TREE_ID, parentId, this.storageParameters);
                    if (started) {
                        realStorage.commitTransaction(this.storageParameters);
                    }
                }
                catch (OXException e) {
                    if (started) {
                        realStorage.rollback(this.storageParameters);
                    }
                    throw e;
                }
                catch (Exception e) {
                    if (started) {
                        realStorage.rollback(this.storageParameters);
                    }
                    throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
                }
                OutlookFolderStorage.clearTCM();
                return toCreate.getID();
            }
            String realParentId = virtualStorage.getDefaultFolderID(this.user, treeId, null == folderContentType ? capStorage.getDefaultContentType() : folderContentType, virtualStorage.getTypeByParent(this.user, treeId, parentId, this.storageParameters), this.storageParameters);
            if (null == realParentId) {
                throw FolderExceptionErrorMessage.NO_DEFAULT_FOLDER.create(capStorage.getDefaultContentType(), FolderStorage.REAL_TREE_ID);
            }
            Folder clone4Real = (Folder)toCreate.clone();
            clone4Real.setParentID(realParentId);
            SortableId[] subfolders = capStorage.getSubfolders(FolderStorage.REAL_TREE_ID, realParentId, this.storageParameters);
            String prefix = clone4Real.getName();
            int appendixCount = 2;
            do {
                found = false;
                String n = clone4Real.getName();
                for (int i = 0; !found && i < subfolders.length; ++i) {
                    if (!n.equals(capStorage.getFolder(FolderStorage.REAL_TREE_ID, subfolders[i].getId(), this.storageParameters).getName())) continue;
                    found = true;
                    clone4Real.setName(prefix + '_' + appendixCount++);
                }
            } while (found);
            this.doCreateReal(clone4Real, realParentId, FolderStorage.REAL_TREE_ID, capStorage, transactionManager, comparedPermissions);
            toCreate.setID(clone4Real.getID());
            virtualStorage.createFolder(toCreate, this.storageParameters);
            boolean started = realStorage.startTransaction(this.storageParameters, true);
            try {
                realStorage.updateLastModified(System.currentTimeMillis(), FolderStorage.REAL_TREE_ID, parentId, this.storageParameters);
                if (started) {
                    realStorage.commitTransaction(this.storageParameters);
                }
            }
            catch (OXException e) {
                if (started) {
                    realStorage.rollback(this.storageParameters);
                }
                throw e;
            }
            catch (Exception e) {
                if (started) {
                    realStorage.rollback(this.storageParameters);
                }
                throw FolderExceptionErrorMessage.UNEXPECTED_ERROR.create(e, e.getMessage());
            }
        }
        return toCreate.getID();
    }

    private void checkOpenedStorage(FolderStorage storage, List<FolderStorage> openedStorages) throws OXException {
        for (FolderStorage openedStorage : openedStorages) {
            if (!openedStorage.equals(storage)) continue;
            return;
        }
        if (storage.startTransaction(this.storageParameters, true)) {
            openedStorages.add(storage);
        }
    }

    private static boolean supportsContentType(ContentType folderContentType, FolderStorage folderStorage) {
        ContentType[] supportedContentTypes = folderStorage.getSupportedContentTypes();
        if (null == supportedContentTypes) {
            return false;
        }
        if (0 == supportedContentTypes.length) {
            return true;
        }
        String cts = folderContentType.toString();
        for (ContentType supportedContentType : supportedContentTypes) {
            if (!supportedContentType.toString().equals(cts)) continue;
            return true;
        }
        return false;
    }
}

