/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.database.provider;

import com.openexchange.database.DatabaseService;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.tools.sql.DBUtils;
import java.sql.Connection;

public class DatabaseServiceDBProvider
implements DBProvider {
    private final DatabaseService databaseService;

    public DatabaseServiceDBProvider(DatabaseService databaseService) {
        this.databaseService = databaseService;
    }

    @Override
    public Connection getReadConnection(Context ctx) throws OXException {
        return this.databaseService.getReadOnly(ctx);
    }

    @Override
    public void releaseReadConnection(Context ctx, Connection con) {
        if (con != null) {
            this.databaseService.backReadOnly(ctx, con);
        }
    }

    @Override
    public Connection getWriteConnection(Context ctx) throws OXException {
        return this.databaseService.getWritable(ctx);
    }

    @Override
    public void releaseWriteConnection(Context ctx, Connection con) {
        if (con == null) {
            return;
        }
        DBUtils.autocommit(con);
        this.databaseService.backWritable(ctx, con);
    }

    @Override
    public void releaseWriteConnectionAfterReading(Context ctx, Connection con) {
        if (con == null) {
            return;
        }
        DBUtils.autocommit(con);
        this.databaseService.backWritableAfterReading(ctx, con);
    }
}

