/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.responseRenderers.actions;

import com.openexchange.ajax.AJAXServlet;
import com.openexchange.ajax.AJAXUtility;
import com.openexchange.ajax.requesthandler.responseRenderers.FileResponseRenderer;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.IDataWrapper;
import com.openexchange.ajax.requesthandler.responseRenderers.actions.IFileResponseRendererAction;
import com.openexchange.java.Strings;
import java.io.IOException;

public class CheckParametersAction
implements IFileResponseRendererAction {
    private static final String DELIVERY = AJAXServlet.PARAMETER_DELIVERY;

    @Override
    public void call(IDataWrapper data) throws IOException, FileResponseRenderer.FileResponseRendererActionException {
        data.setDelivery(AJAXUtility.sanitizeParam(data.getRequest().getParameter(DELIVERY)));
        if (data.getDelivery() == null) {
            data.setDelivery(data.getFile().getDelivery());
        }
        data.setContentType(AJAXUtility.encodeUrl(data.getRequest().getParameter("content_type"), true));
        data.setContentTypeByParameter(false);
        if (Strings.isEmpty((String)data.getContentType())) {
            if ("download".equalsIgnoreCase(data.getDelivery())) {
                data.setContentType("application/octet-stream");
            } else {
                data.setContentType(data.getFileContentType());
            }
        } else {
            data.setContentTypeByParameter(true);
        }
        data.setContentType(this.unquote(data.getContentType()));
        if ("view".equalsIgnoreCase(data.getDelivery()) && null != data.getContentType() && data.getContentType().startsWith("application/octet-stream")) {
            data.setContentType(FileResponseRenderer.getContentTypeByFileName(data.getFileName()));
            if (null == data.getContentType()) {
                data.setContentType("application/octet-stream");
            }
        }
        data.setContentDisposition(AJAXUtility.encodeUrl(data.getRequest().getParameter("content_disposition")));
        if (Strings.isEmpty((String)data.getContentDisposition())) {
            if ("view".equalsIgnoreCase(data.getDelivery())) {
                data.setContentDisposition("inline");
            } else if ("download".equalsIgnoreCase(data.getDelivery())) {
                data.setContentDisposition("attachment");
            } else {
                data.setContentDisposition(data.getFile().getDisposition());
            }
        }
        data.setContentDisposition(this.unquote(data.getContentDisposition()));
        if (null == data.getFile()) {
            throw new FileResponseRenderer.FileResponseRendererActionException(404, "File not found.");
        }
    }

    private String unquote(String s) {
        if (!Strings.isEmpty((String)s) && (s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'"))) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

