/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.oauth;

import com.openexchange.ajax.SessionUtility;
import com.openexchange.ajax.requesthandler.AJAXActionService;
import com.openexchange.ajax.requesthandler.AJAXActionServiceFactory;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.Dispatcher;
import com.openexchange.ajax.requesthandler.DispatcherServlet;
import com.openexchange.exception.OXException;
import com.openexchange.oauth.provider.exceptions.OAuthInsufficientScopeException;
import com.openexchange.oauth.provider.exceptions.OAuthInvalidRequestException;
import com.openexchange.oauth.provider.exceptions.OAuthInvalidTokenException;
import com.openexchange.oauth.provider.resourceserver.OAuthAccess;
import com.openexchange.oauth.provider.resourceserver.OAuthResourceService;
import com.openexchange.oauth.provider.resourceserver.annotations.OAuthAction;
import com.openexchange.oauth.provider.resourceserver.annotations.OAuthModule;
import com.openexchange.osgi.Tools;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Reply;
import com.openexchange.session.Session;
import com.openexchange.session.SessionResult;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.http.Authorization;
import com.openexchange.tools.session.ServerSession;
import com.openexchange.tools.session.ServerSessionAdapter;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuthDispatcherServlet
extends DispatcherServlet {
    private static final long serialVersionUID = 2930109046898745937L;
    private static final Logger LOG = LoggerFactory.getLogger(OAuthDispatcherServlet.class);
    private final ServiceLookup services;

    public OAuthDispatcherServlet(ServiceLookup services, String prefix) {
        super(prefix);
        this.services = services;
    }

    @Override
    protected SessionResult<ServerSession> initializeSession(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws OXException {
        ServerSession session = SessionUtility.getSessionObject((ServletRequest)httpRequest, false);
        if (session != null) {
            return new SessionResult(Reply.CONTINUE, (Session)ServerSessionAdapter.valueOf(session));
        }
        String authHeader = httpRequest.getHeader("Authorization");
        if (authHeader == null) {
            throw new OAuthInvalidTokenException(OAuthInvalidTokenException.Reason.TOKEN_MISSING);
        }
        String authScheme = Authorization.extractAuthScheme(authHeader);
        if (authScheme == null || !authScheme.equalsIgnoreCase("Bearer") || authHeader.length() <= "Bearer".length() + 1) {
            throw new OAuthInvalidTokenException(OAuthInvalidTokenException.Reason.INVALID_AUTH_SCHEME);
        }
        OAuthResourceService oAuthResourceService = (OAuthResourceService)Tools.requireService(OAuthResourceService.class, (ServiceLookup)this.services);
        OAuthAccess oAuthAccess = oAuthResourceService.checkAccessToken(authHeader.substring("Bearer".length() + 1), httpRequest);
        session = oAuthAccess.getSession();
        SessionUtility.rememberSession(httpRequest, ServerSessionAdapter.valueOf(session));
        httpRequest.setAttribute("com.openexchange.oauth.access", (Object)oAuthAccess);
        return new SessionResult(Reply.CONTINUE, (Session)ServerSessionAdapter.valueOf(session));
    }

    @Override
    protected AJAXRequestData initializeRequestData(HttpServletRequest httpRequest, HttpServletResponse httpResponse, boolean preferStream) throws OXException, IOException {
        Dispatcher dispatcher = (Dispatcher)DISPATCHER.get();
        AJAXRequestDataTools requestDataTools = this.getAjaxRequestDataTools();
        String module = requestDataTools.getModule(this.prefix + "oauth/modules/", httpRequest);
        String action = requestDataTools.getAction(httpRequest);
        ServerSession session = SessionUtility.getSessionObject((ServletRequest)httpRequest, false);
        if (session == null) {
            LOG.warn("Session was not contained in servlet request attributes!", (Throwable)new Exception());
            throw new OAuthInvalidTokenException(OAuthInvalidTokenException.Reason.TOKEN_MISSING);
        }
        OAuthAccess oAuthAccess = (OAuthAccess)httpRequest.getAttribute("com.openexchange.oauth.access");
        if (oAuthAccess == null) {
            LOG.warn("OAuthToken was not contained in servlet request attributes!", (Throwable)new Exception());
            throw new OAuthInvalidTokenException(OAuthInvalidTokenException.Reason.TOKEN_MISSING);
        }
        AJAXRequestData requestData = requestDataTools.parseRequest(httpRequest, preferStream, com.openexchange.tools.servlet.http.Tools.isMultipartContent(httpRequest), session, this.prefix, httpResponse);
        requestData.setModule(module);
        requestData.setSession(session);
        requestData.setProperty("com.openexchange.oauth.access", oAuthAccess);
        AJAXActionServiceFactory factory = dispatcher.lookupFactory(module);
        if (factory == null || !factory.getClass().isAnnotationPresent(OAuthModule.class)) {
            throw AjaxExceptionCodes.UNKNOWN_MODULE.create(module);
        }
        AJAXActionService actionService = factory.createActionService(action);
        if (actionService == null || !actionService.getClass().isAnnotationPresent(OAuthAction.class)) {
            throw AjaxExceptionCodes.UNKNOWN_ACTION_IN_MODULE.create(action, module);
        }
        return requestData;
    }

    @Override
    protected void handleOXException(OXException e, HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws IOException {
        if (e instanceof OAuthInvalidTokenException) {
            OAuthInvalidTokenException ex = (OAuthInvalidTokenException)e;
            if (ex.getReason() == OAuthInvalidTokenException.Reason.TOKEN_MISSING) {
                com.openexchange.tools.servlet.http.Tools.sendEmptyErrorResponse(httpResponse, 401, Collections.singletonMap("WWW-Authenticate", "Bearer"));
            } else {
                String errorDescription = ex.getErrorDescription();
                StringBuilder sb = new StringBuilder("Bearer");
                sb.append(",error=\"invalid_token\"");
                if (errorDescription != null) {
                    sb.append(",error_description=\"").append(errorDescription).append("\"");
                }
                JSONObject result = new JSONObject();
                try {
                    result.put("error", (Object)"invalid_token");
                    result.put("error_description", (Object)errorDescription);
                }
                catch (JSONException je) {
                    result = null;
                    this.logException((Exception)((Object)je));
                }
                if (result == null) {
                    com.openexchange.tools.servlet.http.Tools.sendEmptyErrorResponse(httpResponse, 401, Collections.singletonMap("WWW-Authenticate", sb.toString()));
                } else {
                    com.openexchange.tools.servlet.http.Tools.sendErrorResponse(httpResponse, 401, Collections.singletonMap("WWW-Authenticate", sb.toString()), result.toString());
                }
            }
        } else if (e instanceof OAuthInsufficientScopeException) {
            OAuthInsufficientScopeException ex = (OAuthInsufficientScopeException)e;
            JSONObject result = new JSONObject();
            try {
                result.put("error", (Object)"insufficient_scope");
                result.put("error_description", (Object)ex.getErrorDescription());
                result.put("scope", (Object)ex.getScope());
            }
            catch (JSONException je) {
                result = null;
                this.logException((Exception)((Object)je));
            }
            if (result == null) {
                com.openexchange.tools.servlet.http.Tools.sendEmptyErrorResponse(httpResponse, 403);
            } else {
                com.openexchange.tools.servlet.http.Tools.sendErrorResponse(httpResponse, 403, result.toString());
            }
        } else if (e instanceof OAuthInvalidRequestException) {
            OAuthInvalidRequestException ex = (OAuthInvalidRequestException)e;
            JSONObject result = new JSONObject();
            try {
                result.put("error", (Object)"invalid_request");
                result.put("error_description", (Object)ex.getErrorDescription());
            }
            catch (JSONException je) {
                result = null;
                this.logException((Exception)((Object)je));
            }
            if (result == null) {
                com.openexchange.tools.servlet.http.Tools.sendEmptyErrorResponse(httpResponse, 400);
            } else {
                com.openexchange.tools.servlet.http.Tools.sendErrorResponse(httpResponse, 400, result.toString());
            }
        } else {
            super.handleOXException(e, httpRequest, httpResponse);
        }
    }
}

