/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.converters.preview.cache.groupware;

import com.openexchange.ajax.requesthandler.converters.preview.cache.groupware.PreviewCacheCreateDataTableTask;
import com.openexchange.databaseold.Database;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.update.PerformParameters;
import com.openexchange.groupware.update.UpdateExceptionCodes;
import com.openexchange.groupware.update.UpdateTaskAdapter;
import com.openexchange.tools.sql.DBUtils;
import com.openexchange.tools.update.Tools;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

public class DropDataFromPreviewCacheTable
extends UpdateTaskAdapter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform(PerformParameters params) throws OXException {
        int ctxId = params.getContextId();
        Connection con = Database.getNoTimeout(ctxId, true);
        boolean rollback = false;
        try {
            DBUtils.startTransaction(con);
            rollback = true;
            if (Tools.columnExists(con, "preview", "data")) {
                Statement stmt = null;
                try {
                    stmt = con.createStatement();
                    stmt.execute("ALTER TABLE preview DROP COLUMN data");
                }
                finally {
                    DBUtils.closeSQLStuff(stmt);
                }
            }
            con.commit();
            rollback = false;
        }
        catch (SQLException e) {
            throw UpdateExceptionCodes.SQL_PROBLEM.create(e, e.getMessage());
        }
        catch (RuntimeException e) {
            throw UpdateExceptionCodes.UNEXPECTED_ERROR.create(e, e.getMessage());
        }
        finally {
            if (rollback) {
                DBUtils.rollback(con);
            }
            DBUtils.autocommit(con);
            Database.backNoTimeout(ctxId, true, con);
        }
    }

    @Override
    public String[] getDependencies() {
        return new String[]{PreviewCacheCreateDataTableTask.class.getName()};
    }
}

