/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler.cache;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.cache.ResourceCache;
import com.openexchange.java.Strings;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCaches {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceCaches.class);
    private static final AtomicReference<ResourceCache> CACHE_REF = new AtomicReference();
    private static final List<String> DEFAULT_THUMBNAIL_PARAMS = Arrays.asList("content_type", "context", "folder", "format", "height", "id", "scaleType", "version", "width");
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private ResourceCaches() {
    }

    public static void setResourceCache(ResourceCache ref) {
        CACHE_REF.set(ref);
    }

    public static ResourceCache getResourceCache() {
        return CACHE_REF.get();
    }

    public static String generateDefaultThumbnailCacheKey(String eTag, AJAXRequestData requestData) {
        return ResourceCaches.generateThumbnailCacheKey0(eTag, requestData, DEFAULT_THUMBNAIL_PARAMS);
    }

    public static String generateThumbnailCacheKey(String eTag, AJAXRequestData requestData, String ... paramNames) {
        ArrayList<String> parameters = new ArrayList<String>(Arrays.asList(paramNames));
        Collections.sort(parameters);
        return ResourceCaches.generateThumbnailCacheKey0(eTag, requestData, parameters);
    }

    private static String generateThumbnailCacheKey0(String eTag, AJAXRequestData requestData, List<String> parameters) {
        StringBuilder sb = new StringBuilder(512);
        sb.append(requestData.getModule());
        sb.append('-').append(requestData.getAction());
        sb.append('-').append(requestData.getSession().getContextId());
        for (String name : parameters) {
            if (!ResourceCaches.isAcceptableParameter(name)) continue;
            sb.append('-').append(name);
            String parameter = requestData.getParameter(name);
            if (Strings.isEmpty((String)parameter)) continue;
            sb.append('=').append(parameter);
        }
        return ResourceCaches.toMD5(eTag, sb);
    }

    public static String generatePreviewCacheKey(String eTag, AJAXRequestData requestData, String ... additionalParams) {
        StringBuilder sb = new StringBuilder(512);
        sb.append(requestData.getModule());
        sb.append('-').append(requestData.getAction());
        sb.append('-').append(requestData.getSession().getContextId());
        ArrayList<String> parameters = new ArrayList<String>(requestData.getParameters().keySet());
        Collections.sort(parameters);
        for (String name : parameters) {
            if (!ResourceCaches.isAcceptableParameter(name)) continue;
            sb.append('-').append(name);
            String parameter = requestData.getParameter(name);
            if (Strings.isEmpty((String)parameter)) continue;
            sb.append('=').append(parameter);
        }
        if (null != additionalParams) {
            for (String additionalParam : additionalParams) {
                if (Strings.isEmpty((String)additionalParam)) continue;
                sb.append('-').append(additionalParam);
            }
        }
        return ResourceCaches.toMD5(eTag, sb);
    }

    private static String toMD5(String eTag, StringBuilder sb) {
        try {
            byte[] md5Bytes = sb.toString().getBytes("UTF-8");
            String hashedParams = ResourceCaches.asHex(MessageDigest.getInstance("MD5").digest(md5Bytes));
            String prefix = eTag;
            if (prefix.length() + 33 > 128) {
                prefix = ResourceCaches.asHex(MessageDigest.getInstance("MD5").digest(prefix.getBytes()));
            }
            sb.setLength(0);
            return sb.append(prefix).append('-').append(hashedParams).toString();
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("", (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("", (Throwable)e);
        }
        return sb.toString();
    }

    private static boolean isAcceptableParameter(String name) {
        if (Strings.isEmpty((String)name)) {
            return false;
        }
        String n = Strings.toLowerCase((CharSequence)name);
        return !"session".equals(n) && !"action".equals(n);
    }

    public static String asHex(byte[] hash) {
        int length = hash.length;
        char[] buf = new char[length * 2];
        int x = 0;
        for (int i = 0; i < length; ++i) {
            buf[x++] = HEX_CHARS[hash[i] >>> 4 & 0xF];
            buf[x++] = HEX_CHARS[hash[i] & 0xF];
        }
        return new String(buf);
    }
}

