/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.parser;

import com.openexchange.ajax.parser.CommonParser;
import com.openexchange.ajax.parser.DataParser;
import com.openexchange.ajax.parser.ParticipantParser;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.CalendarObject;
import com.openexchange.groupware.container.ExternalGroupParticipant;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.Participants;
import com.openexchange.groupware.container.ResourceGroupParticipant;
import com.openexchange.groupware.container.ResourceParticipant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.groupware.container.participants.ConfirmableParticipant;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CalendarParser
extends CommonParser {
    private static final FieldParser<CalendarObject> CONFIRMATIONS_PARSER = new FieldParser<CalendarObject>(){

        @Override
        public void parse(boolean parseAll, CalendarObject obj, TimeZone timeZone, JSONObject json) throws JSONException {
            if (!parseAll) {
                return;
            }
            JSONArray confirmations = json.optJSONArray("confirmations");
            if (null == confirmations) {
                return;
            }
            ParticipantParser parser = new ParticipantParser();
            ArrayList<ConfirmableParticipant> participants = new ArrayList<ConfirmableParticipant>(confirmations.length());
            for (int i = 0; i < confirmations.length(); ++i) {
                JSONObject jConfirmation = confirmations.optJSONObject(i);
                if (null == jConfirmation) continue;
                participants.add(parser.parseConfirmation(parseAll, jConfirmation));
            }
            obj.setConfirmations(participants.toArray(new ConfirmableParticipant[participants.size()]));
        }
    };
    private static final FieldParser<CalendarObject>[] PARSERS = new FieldParser[]{CONFIRMATIONS_PARSER};

    protected CalendarParser() {
    }

    protected CalendarParser(TimeZone timeZone) {
        super(timeZone);
    }

    protected CalendarParser(boolean parseAll, TimeZone timeZone) {
        super(parseAll, timeZone);
    }

    protected void parseElementCalendar(CalendarObject calendarobject, JSONObject jsonobject) throws JSONException, OXException {
        if (jsonobject.has("title")) {
            calendarobject.setTitle(CalendarParser.parseString(jsonobject, "title"));
        }
        if (jsonobject.has("note")) {
            calendarobject.setNote(CalendarParser.parseString(jsonobject, "note"));
        }
        if (jsonobject.has("recurrence_id")) {
            calendarobject.setRecurrenceID(CalendarParser.parseInt(jsonobject, "recurrence_id"));
        }
        if (jsonobject.has("recurrence_position")) {
            calendarobject.setRecurrencePosition(CalendarParser.parseInt(jsonobject, "recurrence_position"));
        }
        if (jsonobject.has("recurrence_date_position")) {
            calendarobject.setRecurrenceDatePosition(CalendarParser.parseDate(jsonobject, "recurrence_date_position"));
        }
        if (jsonobject.has("recurrence_type")) {
            calendarobject.setRecurrenceType(CalendarParser.parseInt(jsonobject, "recurrence_type"));
        }
        if (jsonobject.has("days")) {
            int days = CalendarParser.parseInt(jsonobject, "days");
            calendarobject.setDays(days);
        }
        if (jsonobject.has("day_in_month")) {
            int dayInMonth = CalendarParser.parseInt(jsonobject, "day_in_month");
            if (dayInMonth == -1) {
                dayInMonth = 5;
            }
            calendarobject.setDayInMonth(dayInMonth);
        }
        if (jsonobject.has("month")) {
            calendarobject.setMonth(CalendarParser.parseInt(jsonobject, "month"));
        }
        if (jsonobject.has("interval")) {
            calendarobject.setInterval(CalendarParser.parseInt(jsonobject, "interval"));
        }
        if (jsonobject.has("until") && jsonobject.has("occurrences") && jsonobject.isNull("until") != (jsonobject.isNull("occurrences") || Integer.parseInt(jsonobject.getString("occurrences")) == 0)) {
            throw OXJSONExceptionCodes.JSON_READ_ERROR.create("Illegal combination of until and occurrences value.");
        }
        if (jsonobject.has("until")) {
            if (jsonobject.isNull("until")) {
                calendarobject.setUntil(null);
            } else {
                calendarobject.setUntil(CalendarParser.parseDate(jsonobject, "until"));
            }
        }
        if (jsonobject.has("occurrences")) {
            if (jsonobject.isNull("occurrences")) {
                calendarobject.setOccurrence(0);
            } else {
                calendarobject.setOccurrence(CalendarParser.parseInt(jsonobject, "occurrences"));
            }
        }
        if (jsonobject.has("notification")) {
            calendarobject.setNotification(CalendarParser.parseBoolean(jsonobject, "notification"));
        }
        if (jsonobject.has("confirmation")) {
            calendarobject.setConfirm(CalendarParser.parseInt(jsonobject, "confirmation"));
        }
        if (jsonobject.has("confirmmessage")) {
            calendarobject.setConfirmMessage(CalendarParser.parseString(jsonobject, "confirmmessage"));
        }
        Participants participants = new Participants();
        if (jsonobject.has("participants")) {
            calendarobject.setParticipants(CalendarParser.parseParticipants(jsonobject, participants));
        }
        if (jsonobject.has("users")) {
            calendarobject.setUsers(CalendarParser.parseUsers(jsonobject, participants));
        }
        if (jsonobject.has("organizer")) {
            calendarobject.setOrganizer(CalendarParser.parseString(jsonobject, "organizer"));
        }
        if (jsonobject.has("uid")) {
            calendarobject.setUid(CalendarParser.parseString(jsonobject, "uid"));
        }
        if (jsonobject.has("sequence")) {
            calendarobject.setSequence(CalendarParser.parseInt(jsonobject, "sequence"));
        }
        if (jsonobject.has("organizerId")) {
            calendarobject.setOrganizerId(CalendarParser.parseInt(jsonobject, "organizerId"));
        }
        if (jsonobject.has("principal")) {
            calendarobject.setPrincipal(CalendarParser.parseString(jsonobject, "principal"));
        }
        if (jsonobject.has("principalId")) {
            calendarobject.setPrincipalId(CalendarParser.parseInt(jsonobject, "principalId"));
        }
        if (jsonobject.has("full_time")) {
            calendarobject.setFullTime(CalendarParser.parseBoolean(jsonobject, "full_time"));
        }
        this.parseField(this.parseAll, calendarobject, this.timeZone, jsonobject);
        this.parseElementCommon(calendarobject, jsonobject);
    }

    public static Participant[] parseParticipants(JSONObject jsonObj, Participants participants) throws JSONException, OXException {
        JSONArray jparticipants = jsonObj.getJSONArray("participants");
        Participant[] participant = new Participant[jparticipants.length()];
        for (int i = 0; i < jparticipants.length(); ++i) {
            int id;
            JSONObject jparticipant = jparticipants.getJSONObject(i);
            int type = jparticipant.getInt("type");
            try {
                id = jparticipant.getInt("id");
            }
            catch (JSONException e) {
                id = -1;
            }
            Comparable<Participant> p = null;
            switch (type) {
                case 1: {
                    if (-1 == id) {
                        throw OXJSONExceptionCodes.JSON_READ_ERROR.create(jparticipant.get("id"));
                    }
                    p = new UserParticipant(id);
                    break;
                }
                case 2: {
                    if (-1 == id) {
                        throw OXJSONExceptionCodes.JSON_READ_ERROR.create(jparticipant.get("id"));
                    }
                    p = new GroupParticipant(id);
                    String groupDisplayName = DataParser.parseString(jparticipant, "display_name");
                    p.setDisplayName(groupDisplayName);
                    break;
                }
                case 3: {
                    if (-1 == id) {
                        throw OXJSONExceptionCodes.JSON_READ_ERROR.create(jparticipant.get("id"));
                    }
                    p = new ResourceParticipant(id);
                    break;
                }
                case 4: {
                    if (-1 == id) {
                        throw OXJSONExceptionCodes.JSON_READ_ERROR.create(jparticipant.get("id"));
                    }
                    p = new ResourceGroupParticipant(id);
                    break;
                }
                case 5: {
                    String displayName = DataParser.parseString(jparticipant, "display_name");
                    String mailAddress = DataParser.parseString(jparticipant, "mail");
                    p = new ExternalUserParticipant(mailAddress);
                    p.setDisplayName(displayName);
                    break;
                }
                case 6: {
                    p = new ExternalGroupParticipant();
                    p.setIdentifier(id);
                    break;
                }
                default: {
                    throw AjaxExceptionCodes.UNEXPECTED_ERROR.create("invalid type");
                }
            }
            participant[i] = p;
        }
        return participant;
    }

    public static UserParticipant[] parseUsers(JSONObject jsonObj, Participants participants) throws JSONException {
        JSONArray jusers = jsonObj.getJSONArray("users");
        for (int i = 0; i < jusers.length(); ++i) {
            JSONObject jUser = jusers.getJSONObject(i);
            UserParticipant user = new UserParticipant(jUser.getInt("id"));
            if (jUser.has("confirmation")) {
                user.setConfirm(jUser.getInt("confirmation"));
            }
            if (jUser.has("confirmmessage")) {
                user.setConfirmMessage(jUser.getString("confirmmessage"));
            }
            if (jUser.has("alarm")) {
                user.setAlarmDate(new Date(jUser.getLong("alarm")));
            }
            participants.add(user);
        }
        return participants.getUsers();
    }

    public static int parseRecurrenceType(String value) throws OXException {
        if ("none".equals(value)) {
            return 0;
        }
        if ("daily".equals(value)) {
            return 1;
        }
        if ("weekly".equals(value)) {
            return 2;
        }
        if ("monthly".equals(value)) {
            return 3;
        }
        if ("yearly".equals(value)) {
            return 4;
        }
        throw AjaxExceptionCodes.UNEXPECTED_ERROR.create("unknown value in recurrence_type: " + value);
    }

    protected void parseField(boolean parseAlles, CalendarObject obj, TimeZone tz, JSONObject json) throws OXException {
        for (FieldParser<CalendarObject> parser : PARSERS) {
            try {
                parser.parse(parseAlles, obj, tz, json);
            }
            catch (JSONException e) {
                throw OXJSONExceptionCodes.JSON_READ_ERROR.create(e, e.getMessage());
            }
        }
    }

    static interface FieldParser<T> {
        public void parse(boolean var1, T var2, TimeZone var3, JSONObject var4) throws JSONException;
    }
}

