/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.helper;

import com.openexchange.ajax.SessionServlet;
import com.openexchange.ajax.container.ThresholdFileHolder;
import com.openexchange.ajax.fileholder.ByteArrayRandomAccess;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.ajax.fileholder.InputStreamReadable;
import com.openexchange.ajax.fileholder.Readable;
import com.openexchange.ajax.helper.BrowserDetector;
import com.openexchange.exception.OXException;
import com.openexchange.html.HtmlService;
import com.openexchange.html.HtmlServices;
import com.openexchange.java.CharsetDetector;
import com.openexchange.java.Charsets;
import com.openexchange.java.HTMLDetector;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.tools.ImageTypeDetector;
import com.openexchange.tools.encoding.Helper;
import com.openexchange.tools.encoding.URLCoder;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import com.openexchange.tools.session.ServerSession;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Locale;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DownloadUtility {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadUtility.class);
    private static final String MIME_APPL_OCTET = "application/octet-stream";
    private static final Pattern PAT_BSLASH = Pattern.compile("\\\\");
    private static final Pattern PAT_QUOTE = Pattern.compile("\"");
    private static final String DEFAULT_FILENAME = "file.dat";
    private static final String MIME_TEXT_PLAIN = "text/plain";
    private static final String MIME_TEXT_HTML = "text/htm";

    private DownloadUtility() {
    }

    public static CheckedDownload checkInlineDownload(Readable inputStream, String fileName, String contentTypeStr, String userAgent, ServerSession session) throws OXException {
        return DownloadUtility.checkInlineDownload(inputStream, fileName, contentTypeStr, null, userAgent, session);
    }

    public static CheckedDownload checkInlineDownload(Readable inputStream, String fileName, String sContentType, String overridingDisposition, String userAgent, ServerSession session) throws OXException {
        return DownloadUtility.checkInlineDownload(inputStream, -1L, fileName, sContentType, overridingDisposition, userAgent, session);
    }

    public static CheckedDownload checkInlineDownload(Readable inputStream, long size, String fileName, String sContentType, String overridingDisposition, String userAgent, ServerSession session) throws OXException {
        return DownloadUtility.checkInlineDownload(inputStream, size, fileName, sContentType, overridingDisposition, userAgent, null == session ? Locale.US : session.getUser().getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CheckedDownload checkInlineDownload(Readable inputStream, long size, String fileName, String sContentType, String overridingDisposition, String userAgent, Locale locale) throws OXException {
        sink = null;
        try {
            block51: {
                block52: {
                    block49: {
                        block50: {
                            block48: {
                                contentType = new ContentType(sContentType);
                                if (null != fileName && contentType.startsWith("application/octet-stream")) {
                                    ct = MimeType2ExtMap.getContentType(fileName);
                                    pos = ct.indexOf(47);
                                    contentType.setPrimaryType(ct.substring(0, pos));
                                    contentType.setSubType(ct.substring(pos + 1));
                                }
                                sContentDisposition = overridingDisposition;
                                sz = size;
                                in = inputStream;
                                fn = fileName;
                                if (!Strings.startsWithAny((String)Strings.toLowerCase((CharSequence)contentType.getSubType()), (String[])new String[]{"htm", "xhtm"})) break block48;
                                if (null == sContentDisposition) {
                                    sContentDisposition = "attachment";
                                } else if (Strings.toLowerCase((CharSequence)sContentDisposition).startsWith("inline")) {
                                    sink = new ThresholdFileHolder();
                                    sink.write(in);
                                    in = null;
                                    cs = contentType.getCharsetParameter();
                                    if (!CharsetDetector.isValid((String)cs) && "US-ASCII".equalsIgnoreCase(cs = CharsetDetector.detectCharset((InputStream)sink.getStream()))) {
                                        cs = "ISO-8859-1";
                                    }
                                    if (sink.getLength() > (long)HtmlServices.htmlThreshold()) {
                                        oxe = AjaxExceptionCodes.HTML_TOO_BIG.create();
                                        htmlContent = SessionServlet.getErrorPage(200, oxe.getDisplayMessage(locale), "");
                                    } else {
                                        htmlContent = new String(sink.toByteArray(), Charsets.forName((String)cs));
                                        htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                                        htmlContent = htmlService.sanitize(htmlContent, null, true, null, null);
                                    }
                                    sink.close();
                                    sink = null;
                                    contentType.setCharsetParameter("UTF-8");
                                    tmp = htmlContent.getBytes(Charsets.UTF_8);
                                    sz = tmp.length;
                                    in = new ByteArrayRandomAccess(tmp);
                                }
                                ** GOTO lbl235
                            }
                            if (!contentType.startsWith("text/xml")) break block49;
                            if (null != sContentDisposition) break block50;
                            sContentDisposition = "attachment";
                            ** GOTO lbl235
                        }
                        if (Strings.toLowerCase((CharSequence)sContentDisposition).startsWith("inline")) {
                            sink = new ThresholdFileHolder();
                            sink.write(in);
                            in = null;
                            cs = contentType.getCharsetParameter();
                            if (!CharsetDetector.isValid((String)cs) && "US-ASCII".equalsIgnoreCase(cs = CharsetDetector.detectCharset((InputStream)sink.getStream()))) {
                                cs = "ISO-8859-1";
                            }
                            copy = new ThresholdFileHolder();
                            w = null;
                            r = null;
                            try {
                                r = new InputStreamReader(sink.getClosingStream(), Charsets.forName((String)cs));
                                w = new OutputStreamWriter(copy.asOutputStream(), Charsets.UTF_8);
                                htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                                buflen = 8192;
                                cbuf = new char[8192];
                                while ((read = r.read(cbuf, 0, 8192)) > 0) {
                                    xmlContent = new String(cbuf, 0, read);
                                    xmlContent = htmlService.htmlFormat(xmlContent);
                                    w.write(xmlContent);
                                }
                                w.flush();
                            }
                            catch (Throwable var24_50) {
                                Streams.close((Closeable[])new Closeable[]{r, w});
                                throw var24_50;
                            }
                            Streams.close((Closeable[])new Closeable[]{r, w});
                            sink = copy;
                            contentType.setSubType("html");
                            contentType.setCharsetParameter("UTF-8");
                            sz = sink.getLength();
                            in = sink.getClosingRandomAccess();
                            sink = null;
                        }
                        ** GOTO lbl235
                    }
                    if (!contentType.startsWith("text/plain")) break block51;
                    if (null == contentType.getCharsetParameter()) {
                        sink = new ThresholdFileHolder();
                        sink.write(in);
                        in = null;
                        cs = CharsetDetector.detectCharset((InputStream)sink.getStream());
                        if ("US-ASCII".equalsIgnoreCase(cs)) {
                            cs = "ISO-8859-1";
                        }
                        contentType.setCharsetParameter(cs);
                        sz = sink.getLength();
                    }
                    if (null != sContentDisposition) break block52;
                    if (null != sink) {
                        sz = sink.getLength();
                        in = sink.getClosingRandomAccess();
                        sink = null;
                    }
                    sContentDisposition = "attachment";
                    ** GOTO lbl235
                }
                if (Strings.toLowerCase((CharSequence)sContentDisposition).startsWith("inline")) {
                    if (null == sink) {
                        sink = new ThresholdFileHolder();
                        sink.write(in);
                        in = null;
                    }
                    if (!CharsetDetector.isValid((String)(cs = contentType.getCharsetParameter())) && "US-ASCII".equalsIgnoreCase(cs = CharsetDetector.detectCharset((InputStream)sink.getStream()))) {
                        cs = "ISO-8859-1";
                    }
                    utf8Copy = new ThresholdFileHolder();
                    w = null;
                    r = null;
                    try {
                        r = new InputStreamReader(sink.getClosingStream(), Charsets.forName((String)cs));
                        w = new OutputStreamWriter(utf8Copy.asOutputStream(), Charsets.UTF_8);
                        buflen = 8192;
                        cbuf = new char[8192];
                        while ((read = r.read(cbuf, 0, 8192)) > 0) {
                            w.write(cbuf, 0, read);
                        }
                        w.flush();
                    }
                    catch (Throwable var25_51) {
                        Streams.close((Closeable[])new Closeable[]{r, w});
                        throw var25_51;
                    }
                    Streams.close((Closeable[])new Closeable[]{r, w});
                    sink = utf8Copy;
                    contentType.setCharsetParameter("UTF-8");
                    sz = sink.getLength();
                    in = sink.getClosingRandomAccess();
                    sink = null;
                } else if (null != sink) {
                    sz = sink.getLength();
                    in = sink.getClosingRandomAccess();
                    sink = null;
                }
                ** GOTO lbl235
            }
            if (!contentType.startsWith("image/") && !DownloadUtility.fileNameImpliesImage(fileName)) ** GOTO lbl206
            browserDetector = BrowserDetector.detectorFor(userAgent);
            msieOnWindows = null != browserDetector && browserDetector.isMSIE() != false && browserDetector.isWindows() != false;
            sink = new ThresholdFileHolder();
            sink.write(in);
            in = null;
            preparedFileName = DownloadUtility.getSaveAsFileName(fileName, msieOnWindows, sContentType);
            fileExtension = DownloadUtility.getFileExtension(fn);
            if (!Strings.isEmpty((String)fileExtension)) ** GOTO lbl-1000
            if (HTMLDetector.containsHTMLTags((InputStream)sink.getStream(), (boolean)false)) {
                ret = DownloadUtility.asAttachment(sink.getClosingRandomAccess(), preparedFileName, sink.getLength());
                sink = null;
                cbuf = ret;
            }
            ** GOTO lbl203
        }
        catch (UnsupportedEncodingException e) {
            try {
                throw AjaxExceptionCodes.UNEXPECTED_ERROR.create(e, new Object[]{e.getMessage()});
                catch (IOException e) {
                    throw AjaxExceptionCodes.IO_ERROR.create(e, new Object[]{e.getMessage()});
                }
            }
            catch (Throwable var26_52) {
                Streams.close(sink);
                throw var26_52;
            }
        }
        Streams.close((Closeable)sink);
        return cbuf;
lbl-1000:
        // 1 sources

        {
            if ('.' == fileExtension.charAt(0)) {
                fileExtension = fileExtension.substring(1);
            }
            if (!(extensions = new HashSet<String>(MimeType2ExtMap.getFileExtensions(contentType.getBaseType()))).isEmpty() && (extensions.size() != 1 || !extensions.contains("dat"))) ** GOTO lbl188
            ct = MimeType2ExtMap.getContentType(fn);
            if (!"application/octet-stream".equals(ct)) ** GOTO lbl-1000
            if (!HTMLDetector.containsHTMLTags((InputStream)sink.getStream(), (boolean)false)) ** GOTO lbl191
            ret = DownloadUtility.asAttachment(sink.getClosingRandomAccess(), preparedFileName, sink.getLength());
            sink = null;
            var22_47 = ret;
        }
        Streams.close((Closeable)sink);
        return var22_47;
lbl-1000:
        // 1 sources

        {
            block53: {
                pos = ct.indexOf(47);
                contentType.setPrimaryType(ct.substring(0, pos));
                contentType.setSubType(ct.substring(pos + 1));
                break block53;
lbl188:
                // 1 sources

                if (!extensions.contains(fileExtension)) {
                    fn = DownloadUtility.addFileExtension(fileExtension, (String)extensions.iterator().next());
                    preparedFileName = DownloadUtility.getSaveAsFileName(fn, msieOnWindows, contentType.getBaseType());
                }
            }
            detectedCT = ImageTypeDetector.getMimeType(sink.getStream());
            if (!"application/octet-stream".equals(detectedCT)) ** GOTO lbl-1000
            if (!HTMLDetector.containsHTMLTags((InputStream)sink.getStream(), (boolean)false)) ** GOTO lbl203
            ret = DownloadUtility.asAttachment(sink.getClosingRandomAccess(), preparedFileName, sink.getLength());
            sink = null;
            var22_48 = ret;
        }
        Streams.close((Closeable)sink);
        return var22_48;
lbl-1000:
        // 1 sources

        {
            block54: {
                if (!contentType.isMimeType(detectedCT)) {
                    contentType.setBaseType(detectedCT);
                }
lbl203:
                // 5 sources

                in = sink.getClosingRandomAccess();
                sink = null;
                break block54;
lbl206:
                // 1 sources

                if (DownloadUtility.fileNameImpliesHtml(fileName)) {
                    if (null == sContentDisposition) {
                        sContentDisposition = "attachment";
                    } else if (Strings.toLowerCase((CharSequence)sContentDisposition).startsWith("inline")) {
                        sink = new ThresholdFileHolder();
                        sink.write(in);
                        in = null;
                        if (HTMLDetector.containsHTMLTags((InputStream)sink.getStream(), (boolean)true)) {
                            cs = contentType.getCharsetParameter();
                            if (!CharsetDetector.isValid((String)cs) && "US-ASCII".equalsIgnoreCase(cs = CharsetDetector.detectCharset((InputStream)sink.getStream()))) {
                                cs = "ISO-8859-1";
                            }
                            if (sink.getLength() > (long)HtmlServices.htmlThreshold()) {
                                oxe = AjaxExceptionCodes.HTML_TOO_BIG.create();
                                htmlContent = SessionServlet.getErrorPage(200, oxe.getDisplayMessage(locale), "");
                            } else {
                                htmlContent = new String(sink.toByteArray(), Charsets.forName((String)cs));
                                htmlService = ServerServiceRegistry.getInstance().getService(HtmlService.class);
                                htmlContent = htmlService.sanitize(htmlContent, null, true, null, null);
                            }
                            sink.close();
                            sink = null;
                            contentType.setCharsetParameter("UTF-8");
                            tmp = htmlContent.getBytes(Charsets.UTF_8);
                            sz = tmp.length;
                            in = new ByteArrayRandomAccess(tmp);
                        } else {
                            in = sink.getClosingRandomAccess();
                        }
                    }
                }
            }
            if (sContentDisposition == null) {
                builder = new StringBuilder(32).append("inline");
                DownloadUtility.appendFilenameParameter(fileName, contentType.isBaseType("application", "octet-stream") != false ? null : contentType.toString(), userAgent, builder);
                contentType.removeParameter("name");
                retval = new CheckedDownload(contentType.toString(), builder.toString(), in, sz);
            } else if (sContentDisposition.indexOf(59) < 0) {
                builder = new StringBuilder(32).append(sContentDisposition);
                DownloadUtility.appendFilenameParameter(fileName, contentType.isBaseType("application", "octet-stream") != false ? null : contentType.toString(), userAgent, builder);
                contentType.removeParameter("name");
                retval = new CheckedDownload(contentType.toString(), builder.toString(), in, sz);
            } else {
                contentType.removeParameter("name");
                retval = new CheckedDownload(contentType.toString(), sContentDisposition, in, sz);
            }
            var16_29 = retval;
        }
        Streams.close((Closeable)sink);
        return var16_29;
    }

    private static boolean fileNameImpliesHtml(String fileName) {
        return null != fileName && MimeType2ExtMap.getContentType(fileName).startsWith(MIME_TEXT_HTML);
    }

    private static boolean fileNameImpliesImage(String fileName) {
        return null != fileName && MimeType2ExtMap.getContentType(fileName).startsWith("image/");
    }

    public static void appendFilenameParameter(String fileName, String userAgent, StringBuilder appendTo) {
        DownloadUtility.appendFilenameParameter(fileName, null, userAgent, appendTo);
    }

    public static void appendFilenameParameter(String fileName, String baseCT, String userAgent, StringBuilder appendTo) {
        boolean isAndroid;
        if (null == fileName) {
            appendTo.append("; filename=\"").append(DEFAULT_FILENAME).append('\"');
            return;
        }
        String fn = fileName;
        if (null != baseCT && null == DownloadUtility.getFileExtension(fn)) {
            if (baseCT.regionMatches(true, 0, MIME_TEXT_PLAIN, 0, MIME_TEXT_PLAIN.length()) && !fileName.toLowerCase(Locale.US).endsWith(".txt")) {
                fn = fn + ".txt";
            } else if (baseCT.regionMatches(true, 0, MIME_TEXT_HTML, 0, MIME_TEXT_HTML.length()) && !fileName.toLowerCase(Locale.US).endsWith(".html")) {
                fn = fn + ".html";
            }
        }
        fn = DownloadUtility.escapeBackslashAndQuote(fn);
        if (null != userAgent && BrowserDetector.detectorFor(userAgent).isMSIE()) {
            appendTo.append("; filename=\"").append(Helper.encodeFilenameForIE(fn, Charsets.UTF_8)).append('\"');
            return;
        }
        String foo = new String(fn.getBytes(Charsets.UTF_8), Charsets.ISO_8859_1);
        boolean bl = isAndroid = null != userAgent && Strings.toLowerCase((CharSequence)userAgent).indexOf("android") >= 0;
        if (isAndroid) {
            int pos = foo.lastIndexOf(46);
            if (pos >= 0) {
                foo = foo.substring(0, pos) + Strings.toUpperCase((CharSequence)foo.substring(pos));
            }
        } else {
            appendTo.append("; filename*=UTF-8''").append(URLCoder.encode(fn));
        }
        appendTo.append("; filename=\"").append(foo).append('\"');
    }

    private static String escapeBackslashAndQuote(String str) {
        return PAT_QUOTE.matcher(PAT_BSLASH.matcher(str).replaceAll("\\\\\\\\")).replaceAll("\\\\\\\"");
    }

    private static CheckedDownload asAttachment(IFileHolder.RandomAccess randomAccess, String preparedFileName, long size) {
        return new CheckedDownload(MIME_APPL_OCTET, new StringBuilder(64).append("attachment; filename=\"").append(preparedFileName).append('\"').toString(), (Readable)randomAccess, size);
    }

    private static String getFileExtension(String fileName) {
        if (null == fileName) {
            return null;
        }
        int pos = fileName.lastIndexOf(46);
        if (pos <= 0 || pos >= fileName.length()) {
            return null;
        }
        return fileName.substring(pos);
    }

    private static String addFileExtension(String fileName, String ext) {
        if (null == fileName) {
            return null;
        }
        int pos = fileName.indexOf(46);
        if (-1 == pos) {
            return fileName + '.' + ext;
        }
        return fileName.substring(0, pos) + '.' + ext;
    }

    public static final String getSaveAsFileName(String fileName, boolean internetExplorer, String baseCT) {
        if (null == fileName) {
            return DEFAULT_FILENAME;
        }
        StringBuilder tmp = new StringBuilder(32);
        try {
            if (fileName.indexOf(32) >= 0) {
                tmp.append(Helper.encodeFilename(fileName.replaceAll(" ", "_"), "UTF-8", internetExplorer));
            } else {
                tmp.append(Helper.encodeFilename(fileName, "UTF-8", internetExplorer));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error("", (Throwable)e);
            return fileName;
        }
        if (null != baseCT && null == DownloadUtility.getFileExtension(fileName)) {
            if (baseCT.regionMatches(true, 0, MIME_TEXT_PLAIN, 0, MIME_TEXT_PLAIN.length()) && !fileName.toLowerCase(Locale.US).endsWith(".txt")) {
                tmp.append(".txt");
            } else if (baseCT.regionMatches(true, 0, MIME_TEXT_HTML, 0, MIME_TEXT_HTML.length()) && !fileName.toLowerCase(Locale.US).endsWith(".html")) {
                tmp.append(".html");
            }
        }
        return tmp.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] stream2bytes(Readable r) throws IOException {
        if (null == r) {
            return new byte[0];
        }
        if (r instanceof InputStreamReadable) {
            return Streams.stream2bytes((InputStream)((InputStreamReadable)r).getInputStream());
        }
        try {
            int read;
            ByteArrayOutputStream bos = Streams.newByteArrayOutputStream((int)4096);
            int buflen = 2048;
            byte[] buf = new byte[2048];
            while ((read = r.read(buf, 0, 2048)) > 0) {
                bos.write(buf, 0, read);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            Streams.close((Closeable)r);
        }
    }

    public static final class CheckedDownload {
        private final String contentType;
        private final String contentDisposition;
        private final Readable inputStream;
        private final long size;

        CheckedDownload(String contentType, String contentDisposition, Readable inputStream, long size) {
            this.contentType = contentType;
            this.contentDisposition = contentDisposition;
            this.inputStream = inputStream;
            this.size = size;
        }

        public long getSize() {
            return this.size;
        }

        public String getContentType() {
            return this.contentType;
        }

        public String getContentDisposition() {
            return this.contentDisposition;
        }

        public boolean isAttachment() {
            return null != this.contentDisposition && Strings.toLowerCase((CharSequence)this.contentDisposition).startsWith("attachment");
        }

        public Readable getInputStream() {
            return this.inputStream;
        }
    }
}

