/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.requesthandler;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.Converter;
import com.openexchange.ajax.requesthandler.DefaultConverter;
import com.openexchange.ajax.requesthandler.ResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.tools.session.ServerSession;
import junit.framework.TestCase;

public class DefaultConverterTest
extends TestCase {
    private final DefaultConverter converter = new DefaultConverter();

    public void testSingleStepConversion() {
        try {
            TestConverter tc = new TestConverter("A", "B", ResultConverter.Quality.GOOD);
            this.converter.addConverter((ResultConverter)tc);
            DefaultConverter.Step shortestPath = this.converter.getShortestPath("A", "B");
            DefaultConverterTest.assertTrue((shortestPath.next == null ? 1 : 0) != 0);
            DefaultConverterTest.assertEquals((Object)tc, (Object)shortestPath.converter);
        }
        catch (DefaultConverter.NoSuchPath e) {
            DefaultConverterTest.fail((String)e.getMessage());
        }
    }

    public void testMultiStepConversion() {
        try {
            TestConverter a = new TestConverter("A", "B", ResultConverter.Quality.GOOD);
            TestConverter b = new TestConverter("B", "C", ResultConverter.Quality.GOOD);
            TestConverter c = new TestConverter("C", "D", ResultConverter.Quality.GOOD);
            this.converter.addConverter((ResultConverter)a);
            this.converter.addConverter((ResultConverter)b);
            this.converter.addConverter((ResultConverter)c);
            DefaultConverter.Step shortestPath = this.converter.getShortestPath("A", "D");
            this.assertPath(shortestPath, a, b, c);
        }
        catch (DefaultConverter.NoSuchPath e) {
            DefaultConverterTest.fail((String)e.getMessage());
        }
    }

    public void testRetrace() {
        try {
            TestConverter a = new TestConverter("A", "B", ResultConverter.Quality.GOOD);
            TestConverter b = new TestConverter("B", "C", ResultConverter.Quality.GOOD);
            TestConverter b2 = new TestConverter("B", "E", ResultConverter.Quality.GOOD);
            TestConverter c = new TestConverter("C", "D", ResultConverter.Quality.GOOD);
            this.converter.addConverter((ResultConverter)a);
            this.converter.addConverter((ResultConverter)b);
            this.converter.addConverter((ResultConverter)b2);
            this.converter.addConverter((ResultConverter)c);
            DefaultConverter.Step shortestPath = this.converter.getShortestPath("A", "D");
            this.assertPath(shortestPath, a, b, c);
        }
        catch (DefaultConverter.NoSuchPath e) {
            DefaultConverterTest.fail((String)e.getMessage());
        }
    }

    public void testPreferHighQuality() {
        try {
            TestConverter a = new TestConverter("A", "B", ResultConverter.Quality.GOOD);
            TestConverter b = new TestConverter("B", "C", ResultConverter.Quality.GOOD);
            TestConverter b2 = new TestConverter("B", "C", ResultConverter.Quality.BAD);
            TestConverter c = new TestConverter("C", "D", ResultConverter.Quality.GOOD);
            this.converter.addConverter((ResultConverter)a);
            this.converter.addConverter((ResultConverter)b);
            this.converter.addConverter((ResultConverter)b2);
            this.converter.addConverter((ResultConverter)c);
            DefaultConverter.Step shortestPath = this.converter.getShortestPath("A", "D");
            this.assertPath(shortestPath, a, b, c);
        }
        catch (DefaultConverter.NoSuchPath e) {
            DefaultConverterTest.fail((String)e.getMessage());
        }
    }

    public void testImpossible() {
        try {
            TestConverter a = new TestConverter("A", "B", ResultConverter.Quality.GOOD);
            TestConverter b = new TestConverter("B", "C", ResultConverter.Quality.GOOD);
            TestConverter c = new TestConverter("C", "D", ResultConverter.Quality.GOOD);
            this.converter.addConverter((ResultConverter)a);
            this.converter.addConverter((ResultConverter)b);
            this.converter.addConverter((ResultConverter)c);
            try {
                this.converter.getShortestPath("A", "E");
                DefaultConverterTest.fail((String)"Huh?!");
            }
            catch (IllegalArgumentException x) {
                DefaultConverterTest.assertTrue((boolean)true);
            }
        }
        catch (DefaultConverter.NoSuchPath e) {
            DefaultConverterTest.fail((String)e.getMessage());
        }
    }

    private void assertPath(DefaultConverter.Step shortestPath, TestConverter ... converters) {
        DefaultConverter.Step current = shortestPath;
        for (TestConverter testConverter : converters) {
            DefaultConverterTest.assertNotNull((String)("Missing one for " + testConverter), (Object)current);
            DefaultConverterTest.assertEquals((Object)testConverter, (Object)current.converter);
            current = current.next;
        }
    }

    public static class TestConverter
    implements ResultConverter {
        private final String input;
        private final String output;
        private final ResultConverter.Quality quality;

        public TestConverter(String input, String output, ResultConverter.Quality quality) {
            this.input = input;
            this.output = output;
            this.quality = quality;
        }

        public void convert(AJAXRequestData requestData, AJAXRequestResult result, ServerSession session, Converter converter) throws OXException {
        }

        public String getInputFormat() {
            return this.input;
        }

        public String getOutputFormat() {
            return this.output;
        }

        public ResultConverter.Quality getQuality() {
            return this.quality;
        }

        public boolean handles(AJAXRequestData request, AJAXRequestResult result) {
            return true;
        }

        public String toString() {
            return this.input + " -> " + this.output;
        }
    }
}

