/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.osgi;

import com.openexchange.server.ServiceHolder;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleServiceTracker<S>
implements ServiceTrackerCustomizer<S, S> {
    private static final Logger LOG = LoggerFactory.getLogger(BundleServiceTracker.class);
    protected final BundleContext context;
    protected final ServiceHolder<S> serviceHolder;
    protected final Class<S> serviceClass;

    public BundleServiceTracker(BundleContext context, Class<S> serviceClass) {
        this(context, null, serviceClass);
    }

    public BundleServiceTracker(BundleContext context, ServiceHolder<S> serviceHolder, Class<S> serviceClass) {
        this.context = context;
        this.serviceClass = serviceClass;
        this.serviceHolder = serviceHolder;
    }

    public final S addingService(ServiceReference<S> reference) {
        Object addedService = this.context.getService(reference);
        if (null == addedService) {
            LOG.warn("added service is null! {}", (Object)this.serviceClass.getName(), (Object)new Throwable());
        }
        if (this.serviceClass.isInstance(addedService)) {
            try {
                S service = this.serviceClass.cast(addedService);
                if (this.serviceHolder != null) {
                    this.serviceHolder.setService(service);
                }
                this.addingServiceInternal(service);
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
        }
        return (S)addedService;
    }

    protected void addingServiceInternal(S service) {
        LOG.trace("BundleServiceTracker.addingServiceInternal(): {}", service);
    }

    public final void modifiedService(ServiceReference<S> reference, S service) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removedService(ServiceReference<S> reference, S service) {
        try {
            if (this.serviceClass.isInstance(service)) {
                try {
                    if (this.serviceHolder != null) {
                        this.serviceHolder.removeService();
                    }
                    this.removedServiceInternal(this.serviceClass.cast(service));
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                }
            }
        }
        finally {
            this.context.ungetService(reference);
        }
    }

    protected void removedServiceInternal(S service) {
        LOG.trace("BundleServiceTracker.removedServiceInternal()");
    }
}

