/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.java;

import com.openexchange.java.Charsets;
import com.openexchange.java.Streams;
import com.openexchange.java.Strings;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class HTMLDetector {
    private static final Set<String> JS_EVENT_HANDLER = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("onabort", "onblur", "onchange", "onclick", "ondblclick", "onerror", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onselect", "onsubmit", "onunload")));

    private HTMLDetector() {
    }

    public static boolean containsHTMLTags(String sequence) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        String lc = Strings.toLowerCase(sequence);
        if (lc.indexOf("<html>") >= 0) {
            return true;
        }
        if (lc.indexOf("<head>") >= 0) {
            return true;
        }
        if (lc.indexOf("<body>") >= 0) {
            return true;
        }
        if (lc.indexOf("<script") >= 0) {
            return true;
        }
        if (lc.indexOf("javascript") >= 0) {
            return true;
        }
        if (lc.indexOf("<img") >= 0) {
            return true;
        }
        if (lc.indexOf("<object") >= 0) {
            return true;
        }
        if (lc.indexOf("<embed") >= 0) {
            return true;
        }
        for (String jsEventHandler : JS_EVENT_HANDLER) {
            if (lc.indexOf(jsEventHandler) < 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsHTMLTags(String sequence, boolean strict) {
        return strict ? HTMLDetector.containsHTMLTags(sequence, "<br", "<p>") : HTMLDetector.containsHTMLTags(sequence);
    }

    public static boolean containsHTMLTags(String sequence, String ... tags) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        String lc = Strings.toLowerCase(sequence);
        if (lc.indexOf("html>") >= 0) {
            return true;
        }
        if (lc.indexOf("head>") >= 0) {
            return true;
        }
        if (lc.indexOf("body>") >= 0) {
            return true;
        }
        if (lc.indexOf("<script") >= 0) {
            return true;
        }
        if (lc.indexOf("javascript") >= 0) {
            return true;
        }
        if (lc.indexOf("<img") >= 0) {
            return true;
        }
        if (lc.indexOf("<object") >= 0) {
            return true;
        }
        if (lc.indexOf("<embed") >= 0) {
            return true;
        }
        for (String jsEventHandler : JS_EVENT_HANDLER) {
            if (lc.indexOf(jsEventHandler) < 0) continue;
            return true;
        }
        if (null != tags) {
            int i = tags.length;
            while (i-- > 0) {
                String tag = tags[i];
                if (Strings.isEmpty(tag) || lc.indexOf(tag) < 0) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsHTMLTag(String sequence, String tag) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        return HTMLDetector.containsIgnoreCase(sequence, new StringBuilder(tag.length() + 2).append('<').append(tag).append('>').toString());
    }

    private static boolean containsIgnoreCase(String sequence, String str) {
        return Strings.toLowerCase(sequence).indexOf(Strings.toLowerCase(str)) >= 0;
    }

    public static boolean containsHTMLTags(byte[] sequence) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (HTMLDetector.containsHTMLTag(sequence, "html")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, "head")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, "body")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, "<script")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, "javascript")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, "<img")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, "<object")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, "<embed")) {
            return true;
        }
        for (String jsEventHandler : JS_EVENT_HANDLER) {
            if (!HTMLDetector.containsIgnoreCase(sequence, jsEventHandler)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsHTMLTags(InputStream in, boolean strict) throws IOException {
        return HTMLDetector.containsHTMLTags(in, strict, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsHTMLTags(InputStream in, boolean strict, boolean oneShot) throws IOException {
        if (null == in) {
            return false;
        }
        try {
            int read;
            int buflen = 8192;
            byte[] buf = new byte[buflen];
            boolean found = false;
            while (!found && (read = in.read(buf, 0, buflen)) > 0) {
                boolean bl = found = strict ? HTMLDetector.containsHTMLTags(buf, 0, read, "<br", "<p>") : HTMLDetector.containsHTMLTags(buf, 0, read);
                if (!oneShot) continue;
                boolean bl2 = found;
                return bl2;
            }
            boolean bl = found;
            return bl;
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    public static boolean containsHTMLTags(byte[] sequence, boolean strict) {
        return strict ? HTMLDetector.containsHTMLTags(sequence, "<br", "<p>") : HTMLDetector.containsHTMLTags(sequence);
    }

    public static boolean containsHTMLTags(byte[] sequence, String ... tags) {
        if (HTMLDetector.containsHTMLTags(sequence)) {
            return true;
        }
        if (null != tags) {
            int i = tags.length;
            while (i-- > 0) {
                String tag = tags[i];
                if (Strings.isEmpty(tag) || !HTMLDetector.containsIgnoreCase(sequence, tag)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsHTMLTags(byte[] sequence, int off, int len, String ... tags) {
        if (HTMLDetector.containsHTMLTags(sequence, off, len)) {
            return true;
        }
        if (null != tags) {
            int i = tags.length;
            while (i-- > 0) {
                String tag = tags[i];
                if (Strings.isEmpty(tag) || !HTMLDetector.containsIgnoreCase(sequence, off, len, tag)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsHTMLTags(byte[] sequence, int off, int len) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > sequence.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (HTMLDetector.containsHTMLTag(sequence, off, len, "html")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, off, len, "head")) {
            return true;
        }
        if (HTMLDetector.containsHTMLTag(sequence, off, len, "body")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, off, len, "<script")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, off, len, "javascript")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, off, len, "<img")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, off, len, "<object")) {
            return true;
        }
        if (HTMLDetector.containsIgnoreCase(sequence, off, len, "<embed")) {
            return true;
        }
        for (String jsEventHandler : JS_EVENT_HANDLER) {
            if (!HTMLDetector.containsIgnoreCase(sequence, off, len, jsEventHandler)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsHTMLTag(byte[] sequence, String tag) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        return HTMLDetector.containsIgnoreCase(sequence, new StringBuilder(tag.length() + 2).append('<').append(tag).append('>').toString());
    }

    public static boolean containsHTMLTag(byte[] sequence, int off, int len, String tag) {
        if (sequence == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > sequence.length - off) {
            throw new IndexOutOfBoundsException();
        }
        return HTMLDetector.containsIgnoreCase(sequence, off, len, new StringBuilder(tag.length() + 2).append('<').append(tag).append('>').toString());
    }

    private static boolean containsIgnoreCase(byte[] sequence, String str) {
        if (HTMLDetector.indexOf(sequence, Charsets.toAsciiBytes(Strings.toLowerCase(str)), 0, sequence.length) >= 0) {
            return true;
        }
        return HTMLDetector.indexOf(sequence, Charsets.toAsciiBytes(Strings.toUpperCase(str)), 0, sequence.length) >= 0;
    }

    private static boolean containsIgnoreCase(byte[] sequence, int off, int len, String str) {
        if (HTMLDetector.indexOf(sequence, Charsets.toAsciiBytes(Strings.toLowerCase(str)), off, len) >= 0) {
            return true;
        }
        return HTMLDetector.indexOf(sequence, Charsets.toAsciiBytes(Strings.toUpperCase(str)), off, len) >= 0;
    }

    private static int indexOf(byte[] data, byte[] pattern, int beginIndex, int endIndex) {
        if (beginIndex < 0 || beginIndex > data.length) {
            throw new IndexOutOfBoundsException(Integer.toString(beginIndex));
        }
        if (endIndex < 0 || endIndex > data.length) {
            throw new IndexOutOfBoundsException(Integer.toString(endIndex));
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException(Integer.toString(endIndex - beginIndex));
        }
        if (data.length == 0) {
            return -1;
        }
        int[] failure = HTMLDetector.computeFailure(pattern);
        if (failure == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        int j = 0;
        for (int i = beginIndex; i < endIndex; ++i) {
            while (j > 0 && pattern[j] != data[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == data[i]) {
                ++j;
            }
            if (j != pattern.length) continue;
            return i - pattern.length + 1;
        }
        return -1;
    }

    private static int[] computeFailure(byte[] pattern) {
        if (pattern == null) {
            return null;
        }
        int[] failure = new int[pattern.length];
        int j = 0;
        for (int i = 1; i < pattern.length; ++i) {
            while (j > 0 && pattern[j] != pattern[i]) {
                j = failure[j - 1];
            }
            if (pattern[j] == pattern[i]) {
                // empty if block
            }
            failure[i] = ++j;
        }
        return failure;
    }
}

