/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.strings;

import com.openexchange.tools.strings.StringParser;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;

public class BasicTypesStringParser
implements StringParser {
    private final Map<Class<?>, Parser<?>> parsers;

    public BasicTypesStringParser() {
        HashMap parsers = new HashMap(16, 0.9f);
        Parser<Constable> parser = new Parser<Integer>(){

            @Override
            public Integer parse(String s) {
                try {
                    return Integer.valueOf(s.trim());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
        parsers.put(Integer.class, parser);
        parsers.put(Integer.TYPE, parser);
        parser = new Parser<Long>(){

            @Override
            public Long parse(String s) {
                try {
                    return Long.valueOf(s.trim());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
        parsers.put(Long.class, parser);
        parsers.put(Long.TYPE, parser);
        parser = new Parser<Short>(){

            @Override
            public Short parse(String s) {
                try {
                    return Short.valueOf(s.trim());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
        parsers.put(Short.class, parser);
        parsers.put(Short.TYPE, parser);
        parser = new Parser<Float>(){

            @Override
            public Float parse(String s) {
                try {
                    return Float.valueOf(s.trim());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
        parsers.put(Float.class, parser);
        parsers.put(Float.TYPE, parser);
        parser = new Parser<Double>(){

            @Override
            public Double parse(String s) {
                try {
                    return Double.valueOf(s.trim());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
        parsers.put(Double.class, parser);
        parsers.put(Double.TYPE, parser);
        parser = new Parser<Byte>(){

            @Override
            public Byte parse(String s) {
                try {
                    return Byte.valueOf(s.trim());
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
        };
        parsers.put(Byte.class, parser);
        parsers.put(Byte.TYPE, parser);
        parser = new Parser<Boolean>(){

            @Override
            public Boolean parse(String s) {
                return Boolean.valueOf(s.trim());
            }
        };
        parsers.put(Boolean.class, parser);
        parsers.put(Boolean.TYPE, parser);
        this.parsers = parsers;
    }

    @Override
    public <T> T parse(String s, Class<T> t) {
        if (s == null) {
            return null;
        }
        if (t == String.class) {
            return (T)s;
        }
        Parser<?> parser = this.parsers.get(t);
        if (null == parser) {
            return null;
        }
        return (T)parser.parse(s);
    }

    private static interface Parser<T> {
        public T parse(String var1);
    }
}

