/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server;

import com.openexchange.exception.OXException;
import com.openexchange.java.Streams;
import com.openexchange.server.Initialization;
import com.openexchange.server.ServiceExceptionCode;
import com.openexchange.server.ServiceHolder;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceHolderInit
implements Initialization {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceHolderInit.class);
    private static final String DEFAULT_TIMEOUT = "10000";
    private static final ServiceHolderInit SINGLETON = new ServiceHolderInit();
    private final AtomicBoolean started = new AtomicBoolean();

    public static ServiceHolderInit getInstance() {
        return SINGLETON;
    }

    private ServiceHolderInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws OXException {
        block13: {
            FileInputStream in;
            if (!this.started.compareAndSet(false, true)) {
                LOG.error("Service holder initialization already started", new Throwable());
                return;
            }
            String propDir = System.getProperties().getProperty("openexchange.propdir");
            if (null == propDir) {
                LOG.error("Missing property \"openexchange.propdir\"");
                throw ServiceExceptionCode.SERVICE_INITIALIZATION_FAILED.create();
            }
            File sysPropFile = new File(propDir, "system.properties");
            if (!sysPropFile.exists() || !sysPropFile.isFile()) {
                LOG.error("Missing property file \"system.properties\" in properties path \"{}{}", (Object)propDir, (Object)Character.valueOf('\"'));
                throw ServiceExceptionCode.SERVICE_INITIALIZATION_FAILED.create();
            }
            try {
                in = new FileInputStream(sysPropFile);
            }
            catch (FileNotFoundException e) {
                LOG.error("", (Throwable)e);
                throw ServiceExceptionCode.SERVICE_INITIALIZATION_FAILED.create();
            }
            try {
                Properties sysProps = new Properties();
                try {
                    sysProps.load(in);
                    boolean serviceUsageInscpection = Boolean.parseBoolean(sysProps.getProperty("serviceUsageInspection", "false").trim());
                    if (serviceUsageInscpection) {
                        String serviceUsageTimeoutStr = sysProps.getProperty("serviceUsageTimeout", DEFAULT_TIMEOUT).trim();
                        int serviceUsageTimeout = -1;
                        try {
                            serviceUsageTimeout = Integer.parseInt(serviceUsageTimeoutStr);
                        }
                        catch (NumberFormatException e) {
                            LOG.error("Invalid property value for \"serviceUsageTimeout\": {}", (Object)serviceUsageTimeoutStr);
                            serviceUsageTimeout = Integer.parseInt(DEFAULT_TIMEOUT);
                        }
                        ServiceHolder.enableServiceUsageInspection(serviceUsageTimeout);
                        LOG.info("Service usage inspection successfully enabled");
                        break block13;
                    }
                    LOG.info("Service usage inspection not enabled");
                }
                catch (IOException e) {
                    throw ServiceExceptionCode.IO_ERROR.create();
                }
            }
            finally {
                Streams.close((Closeable)in);
            }
        }
    }

    @Override
    public void stop() throws OXException {
        if (!this.started.compareAndSet(true, false)) {
            LOG.error("Service holder initialization has not been started", new Throwable());
            return;
        }
        ServiceHolder.disableServiceUsageInspection();
    }
}

