/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.ziputil;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.IdVersionPair;
import com.openexchange.filestore.FileStorageCodes;
import com.openexchange.groupware.upload.impl.UploadUtility;
import com.openexchange.java.Streams;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.servlet.AjaxExceptionCodes;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipException;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;

@NotThreadSafe
public class ZipMaker {
    private final IDBasedFileAccess fileAccess;
    private final IDBasedFolderAccess folderAccess;
    private final List<IdVersionPair> idVersionPairs;
    private final boolean recursive;

    public ZipMaker(List<IdVersionPair> idVersionPairs, boolean recursive, IDBasedFileAccess fileAccess, IDBasedFolderAccess folderAccess) {
        this.idVersionPairs = idVersionPairs;
        this.recursive = recursive;
        this.fileAccess = fileAccess;
        this.folderAccess = folderAccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeZipArchive(OutputStream out) throws OXException {
        ZipArchiveOutputStream zipOutput = null;
        try {
            zipOutput = new ZipArchiveOutputStream(out);
            zipOutput.setEncoding("UTF-8");
            zipOutput.setUseLanguageEncodingFlag(true);
            zipOutput.setLevel(AbstractFileAction.getZipDocumentsCompressionLevel());
            int buflen = 65536;
            byte[] buf = new byte[buflen];
            for (IdVersionPair idVersionPair : this.idVersionPairs) {
                if (null == idVersionPair.getIdentifier()) {
                    this.addFolder2Archive(idVersionPair.getFolderId(), zipOutput, "", buflen, buf);
                    continue;
                }
                File file = this.fileAccess.getFileMetadata(idVersionPair.getIdentifier(), idVersionPair.getVersion());
                this.addFile2Archive(file, this.fileAccess.getDocument(idVersionPair.getIdentifier(), idVersionPair.getVersion()), zipOutput, "", buflen, buf);
            }
        }
        catch (Throwable throwable) {
            Streams.close(zipOutput);
            throw throwable;
        }
        Streams.close((Closeable)zipOutput);
    }

    private void addFolder2Archive(String folderId, ZipArchiveOutputStream zipOutput, String pathPrefix, int buflen, byte[] buf) throws OXException {
        try {
            List<File> files = this.getFilesInFolder(folderId, File.Field.ID, File.Field.FOLDER_ID, File.Field.FILENAME, File.Field.FILE_MIMETYPE);
            for (File file : files) {
                try {
                    this.addFile2Archive(file, this.fileAccess.getDocument(file.getId(), FileStorageFileAccess.CURRENT_VERSION), zipOutput, pathPrefix, buflen, buf);
                }
                catch (OXException e) {
                    if (FileStorageCodes.FILE_NOT_FOUND.equals(e)) continue;
                    throw e;
                }
            }
            if (this.recursive) {
                for (FileStorageFolder f : this.folderAccess.getSubfolders(folderId, false)) {
                    String path;
                    String name = f.getName();
                    int num = 1;
                    while (true) {
                        try {
                            int pos = name.indexOf(46);
                            String entryName = pos < 0 ? name + (num > 1 ? "_(" + num + ")" : "") : name.substring(0, pos) + (num > 1 ? "_(" + num + ")" : "") + name.substring(pos);
                            path = pathPrefix + entryName + "/";
                            ZipArchiveEntry entry = new ZipArchiveEntry(path);
                            zipOutput.putArchiveEntry((ArchiveEntry)entry);
                        }
                        catch (ZipException e) {
                            String message = e.getMessage();
                            if (message == null || !message.startsWith("duplicate entry")) {
                                throw e;
                            }
                            ++num;
                            continue;
                        }
                        break;
                    }
                    zipOutput.closeArchiveEntry();
                    this.addFolder2Archive(f.getId(), zipOutput, path, buflen, buf);
                }
            }
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.HTTP_ERROR.create((Throwable)e, new Object[]{500, "Internal Server Error"});
        }
    }

    private void addFile2Archive(File file, InputStream in, ZipArchiveOutputStream zipOutput, String pathPrefix, int buflen, byte[] buf) throws OXException {
        try {
            int read;
            ZipArchiveEntry entry;
            String name = file.getFileName();
            if (null == name) {
                List extensions = MimeType2ExtMap.getFileExtensions((String)file.getFileMIMEType());
                name = extensions == null || extensions.isEmpty() ? "part.dat" : "part." + (String)extensions.get(0);
            }
            int num = 1;
            while (true) {
                try {
                    int pos = name.indexOf(46);
                    String entryName = pos < 0 ? name + (num > 1 ? "_(" + num + ")" : "") : name.substring(0, pos) + (num > 1 ? "_(" + num + ")" : "") + name.substring(pos);
                    entry = new ZipArchiveEntry(pathPrefix + entryName);
                    zipOutput.putArchiveEntry((ArchiveEntry)entry);
                }
                catch (ZipException e) {
                    String message = e.getMessage();
                    if (message == null || !message.startsWith("duplicate entry")) {
                        throw e;
                    }
                    ++num;
                    continue;
                }
                break;
            }
            long size = 0L;
            while ((read = in.read(buf, 0, buflen)) > 0) {
                zipOutput.write(buf, 0, read);
                size += (long)read;
            }
            entry.setSize(size);
            zipOutput.closeArchiveEntry();
        }
        catch (IOException e) {
            throw AjaxExceptionCodes.HTTP_ERROR.create((Throwable)e, new Object[]{500, "Internal Server Error"});
        }
        finally {
            Streams.close((Closeable)in);
        }
    }

    public void checkThreshold(long threshold) throws OXException {
        if (threshold > 0L) {
            long total = 0L;
            for (IdVersionPair idVersionPair : this.idVersionPairs) {
                total = this.examineResources4Archive(idVersionPair, total, threshold);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long examineResources4Archive(IdVersionPair idVersionPair, long totalSize, long threshold) throws OXException {
        if (null == idVersionPair.getIdentifier()) {
            String folderId = idVersionPair.getFolderId();
            List<File.Field> columns = Arrays.asList(File.Field.ID, File.Field.FILE_SIZE);
            SearchIterator it = this.fileAccess.getDocuments(folderId, columns).results();
            try {
                long total = totalSize;
                while (it.hasNext()) {
                    File file = (File)it.next();
                    long fileSize = file.getFileSize();
                    if (fileSize <= 0L || (total += fileSize) <= threshold) continue;
                    throw FileStorageExceptionCodes.ARCHIVE_MAX_SIZE_EXCEEDED.create(new Object[]{UploadUtility.getSize((long)threshold, (int)2, (boolean)false, (boolean)true)});
                }
                SearchIterators.close((SearchIterator)it);
                it = null;
                if (this.recursive) {
                    for (FileStorageFolder f : this.folderAccess.getSubfolders(folderId, false)) {
                        total = this.examineResources4Archive(new IdVersionPair(null, null, f.getId()), total, threshold);
                    }
                }
                long l = total;
                return l;
            }
            finally {
                SearchIterators.close((SearchIterator)it);
            }
        }
        File file = this.fileAccess.getFileMetadata(idVersionPair.getIdentifier(), idVersionPair.getVersion());
        long fileSize = file.getFileSize();
        if (fileSize > 0L) {
            long total = totalSize;
            if ((total += fileSize) > threshold) {
                throw FileStorageExceptionCodes.ARCHIVE_MAX_SIZE_EXCEEDED.create(new Object[]{UploadUtility.getSize((long)threshold, (int)2, (boolean)false, (boolean)true)});
            }
            return total;
        }
        return totalSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<File> getFilesInFolder(String folderId, File.Field ... columns) throws OXException {
        List list;
        SearchIterator iterator = null;
        try {
            iterator = this.fileAccess.getDocuments(folderId, Arrays.asList(columns)).results();
            list = SearchIterators.asList((SearchIterator)iterator);
        }
        catch (Throwable throwable) {
            SearchIterators.close(iterator);
            throw throwable;
        }
        SearchIterators.close((SearchIterator)iterator);
        return list;
    }
}

