/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractListingAction;
import com.openexchange.file.storage.json.actions.files.CreatedByComparator;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.ArrayList;
import java.util.List;

@Action(method=RequestMethod.GET, name="shares", description="Get documents of the user shared to other entities", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="columns", description="The requested fields as per tables Common object data and Detailed infoitem data."), @Parameter(name="sort", optional=true, description="The identifier of a column which determines the sort order of the response. If this parameter is specified, then the parameter order must be also specified."), @Parameter(name="order", optional=true, description="\"asc\" if the response entires should be sorted in the ascending order, \"desc\" if the response entries should be sorted in the descending order. If this parameter is specified, then the parameter sort must be also specified.")}, responseDescription="Response: An array with infoitem data. Each array element describes one infoitem and is itself an array. The elements of each array contain the information specified by the corresponding identifiers in the columns parameter.")
public class SharesAction
extends AbstractListingAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        IDBasedFileAccess fileAccess = request.getFileAccess();
        File.Field sortingField = request.getSortingField();
        FileStorageFileAccess.SortDirection sortDirection = request.getSortingOrder();
        List<File.Field> columns = request.getFieldsToLoad();
        boolean copy = false;
        if (!columns.contains(File.Field.FOLDER_ID)) {
            columns = new ArrayList<File.Field>(columns);
            columns.add(File.Field.FOLDER_ID);
            copy = true;
        }
        if (!columns.contains(File.Field.ID)) {
            if (!copy) {
                columns = new ArrayList<File.Field>(columns);
                copy = true;
            }
            columns.add(File.Field.ID);
        }
        SearchIterator<File> searchIterator = fileAccess.getUserSharedDocuments(columns, sortingField, sortDirection);
        if (File.Field.CREATED_BY.equals((Object)sortingField)) {
            searchIterator = CreatedByComparator.resort(request.getSession(), searchIterator, sortDirection);
        }
        return this.results(searchIterator, request);
    }
}

