/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Actions;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.DefaultFileStorageFolder;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageExceptionCodes;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStoragePermission;
import com.openexchange.file.storage.composition.FileID;
import com.openexchange.file.storage.composition.FolderID;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.composition.IDBasedFolderAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AbstractWriteAction;
import com.openexchange.file.storage.json.actions.files.IdVersionPair;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.actions.files.UpdateAction;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIterators;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.LoggerFactory;

@Actions(value={@Action(method=RequestMethod.PUT, name="move", description="Moves an infoitem via PUT", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the updated infoitem."), @Parameter(name="folder", description="The Folder of the Object."), @Parameter(name="timestamp", description="Timestamp of the infostore object.")}, requestBody="Infoitem object as described in Common object data and Detailed infoitem data. Only modified fields are present.", responseDescription="The id of the newly created object."), @Action(method=RequestMethod.POST, name="copy", description="Copy an infoitem via POST", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the updated infoitem."), @Parameter(name="timestamp", description="Timestamp of the updated infoitem. If the infoitem was modified after the specified timestamp, then the update must fail."), @Parameter(name="json", description="Infoitem object as described in Common object data and Detailed infoitem data. Only modified fields are present."), @Parameter(name="file", description="File metadata as per <input type=\"file\" />")}, requestBody="Body of content-type \"multipart/form-data\" or \"multipart/mixed\" containing the above mentioned fields and file-data.", responseDescription="The response is sent as a HTML document (see introduction).")})
public class MoveAction
extends AbstractWriteAction {
    private final List<File.Field> fields = Collections.singletonList(File.Field.FOLDER_ID);

    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        List<IdVersionPair> pairs = request.optIdVersionPairs();
        if (null != pairs) {
            return this.handlePairs(pairs, request);
        }
        request.require(AbstractFileAction.Param.ID, AbstractFileAction.Param.FOLDER_ID, AbstractFileAction.Param.TIMESTAMP);
        DefaultFile file = new DefaultFile();
        file.setId(request.getId());
        file.setFolderId(request.getFolderId());
        FileID id = new FileID(file.getId());
        IDBasedFileAccess fileAccess = request.getFileAccess();
        boolean ignoreWarnings = AJAXRequestDataTools.parseBoolParameter((String)"ignoreWarnings", (AJAXRequestData)request.getRequestData(), (boolean)false);
        String newId = fileAccess.saveFileMetadata((File)file, request.getTimestamp(), this.fields, ignoreWarnings);
        AJAXRequestResult result = null != newId && request.extendedResponse() ? this.result(fileAccess.getFileMetadata(newId, FileStorageFileAccess.CURRENT_VERSION), request) : new AJAXRequestResult((Object)newId, new Date(file.getSequenceNumber()));
        List warnings = fileAccess.getAndFlushWarnings();
        result.addWarnings((Collection)warnings);
        if (null == newId && null != warnings && !warnings.isEmpty() && !ignoreWarnings) {
            result.setException(FileStorageExceptionCodes.FILE_UPDATE_ABORTED.create(new Object[]{MoveAction.getFilenameSave(id, fileAccess), id.toUniqueID()}));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AJAXRequestResult handlePairs(List<IdVersionPair> pairs, InfostoreRequest request) throws OXException {
        request.require(AbstractFileAction.Param.FOLDER_ID);
        boolean adjustFilenamesAsNeeded = AJAXRequestDataTools.parseBoolParameter((String)"autorename", (AJAXRequestData)request.getRequestData(), (boolean)true);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        IDBasedFolderAccess folderAccess = request.getFolderAccess();
        String destFolder = request.getFolderId();
        LinkedList<String> oldFiles = new LinkedList<String>();
        LinkedList<String> deleteableFolders = new LinkedList<String>();
        boolean error = true;
        try {
            ArrayList<String> conflicting = new ArrayList<String>(pairs.size());
            for (IdVersionPair pair : pairs) {
                if (pair.getIdentifier() == null) {
                    String folderId = pair.getFolderId();
                    FileStorageFolder srcFolder = folderAccess.getFolder(new FolderID(folderId));
                    DefaultFileStorageFolder newFolder = new DefaultFileStorageFolder();
                    newFolder.setName(srcFolder.getName());
                    newFolder.setParentId(destFolder);
                    newFolder.setSubscribed(srcFolder.isSubscribed());
                    for (FileStoragePermission permission : srcFolder.getPermissions()) {
                        newFolder.addPermission(permission);
                    }
                    String newFolderID = folderAccess.createFolder((FileStorageFolder)newFolder);
                    ArrayList<String> fileIds = new ArrayList<String>();
                    TimedResult documents = fileAccess.getDocuments(folderId);
                    SearchIterator iter = documents.results();
                    try {
                        while (iter.hasNext()) {
                            File file = (File)iter.next();
                            fileIds.add(file.getId());
                        }
                    }
                    finally {
                        SearchIterators.close((SearchIterator)iter);
                    }
                    deleteableFolders.addLast(newFolderID);
                    conflicting.addAll(fileAccess.move(fileIds, Long.MAX_VALUE, newFolderID, adjustFilenamesAsNeeded));
                    deleteableFolders.removeLast();
                    deleteableFolders.addLast(folderId);
                    continue;
                }
                String id = pair.getIdentifier();
                oldFiles.add(id);
            }
            if (!oldFiles.isEmpty()) {
                conflicting.addAll(fileAccess.move(oldFiles, Long.MAX_VALUE, destFolder, adjustFilenamesAsNeeded));
            }
            for (String folderId : deleteableFolders) {
                try {
                    folderAccess.deleteFolder(folderId, true);
                }
                catch (Exception e) {}
            }
            error = false;
            AJAXRequestResult aJAXRequestResult = this.result(conflicting, request);
            return aJAXRequestResult;
        }
        finally {
            if (error) {
                for (String folderId : deleteableFolders) {
                    try {
                        folderAccess.deleteFolder(folderId, true);
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private String moveFile(String fileId, String newFolderId, IDBasedFileAccess fileAccess) throws OXException {
        DefaultFile file = new DefaultFile();
        file.setId(fileId);
        file.setFolderId(newFolderId);
        return fileAccess.saveFileMetadata((File)file, Long.MAX_VALUE, this.fields, true);
    }

    private static String getFilenameSave(FileID id, IDBasedFileAccess fileAccess) {
        String name = null;
        if (null != id && null != fileAccess) {
            try {
                File metadata = fileAccess.getFileMetadata(id.toUniqueID(), FileStorageFileAccess.CURRENT_VERSION);
                if (null != metadata && null == (name = metadata.getFileName())) {
                    name = metadata.getTitle();
                }
            }
            catch (OXException e) {
                LoggerFactory.getLogger(UpdateAction.class).debug("Error getting name for file {}: {}", new Object[]{id, e.getMessage(), e});
            }
        }
        return name;
    }
}

