/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;

@Action(method=RequestMethod.GET, name="get", description="Get an infoitem", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="id", description="Object ID of the requested infoitem."), @Parameter(name="version", optional=true, description="If present the infoitem data describes the given version. Otherwise the current version is returned.")}, responseDescription="Response with timestamp: An object containing all data of the requested infoitem. The fields of the object are listed in Common object data and Detailed infoitem data. The field id is not included.")
public class GetAction
extends AbstractFileAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        request.require(AbstractFileAction.Param.ID);
        IDBasedFileAccess fileAccess = request.getFileAccess();
        File fileMetadata = fileAccess.getFileMetadata(request.getId(), request.getVersion());
        return this.result(fileMetadata, request);
    }
}

