/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.documentation.RequestMethod;
import com.openexchange.documentation.Type;
import com.openexchange.documentation.annotations.Action;
import com.openexchange.documentation.annotations.Parameter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.AbstractWriteAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import java.util.List;

@Action(method=RequestMethod.PUT, name="delete", description="Delete infoitems", parameters={@Parameter(name="session", description="A session ID previously obtained from the login module."), @Parameter(name="timestamp", description="Timestamp of the last update of the deleted infoitems."), @Parameter(name="hardDelete", type=Type.BOOLEAN, description="Optional, defaults to \"false\". If set to \"true\", the file is deleted permanently. Otherwise, and if the underlying storage supports a trash folder and the file is not yet located below the trash folder, it is moved to the trash folder.")}, requestBody="An array with objects to delete. The fields for the object are described in Full identifier for an infostore document.", responseDescription="An array with [[]].")
public class DeleteAction
extends AbstractWriteAction {
    @Override
    public AJAXRequestResult handle(InfostoreRequest request) throws OXException {
        request.requireBody().require(AbstractFileAction.Param.TIMESTAMP);
        boolean hardDelete = "true".equals(request.getParameter("hardDelete"));
        IDBasedFileAccess fileAccess = request.getFileAccess();
        List conflicting = fileAccess.removeDocument(request.getIds(), request.getTimestamp(), hardDelete);
        return this.result(conflicting, request);
    }
}

