/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.java.Collators;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorDelegator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.session.ServerSession;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;

public class CreatedByComparator
implements Comparator<File> {
    private final TIntObjectMap<String> cache = new TIntObjectHashMap(24);
    private final Collator collator;
    private final Context context;
    private boolean desc;

    public CreatedByComparator(Locale locale, Context context) {
        this.collator = Collators.getSecondaryInstance((Locale)locale);
        this.context = context;
    }

    public CreatedByComparator setDescending(boolean desc) {
        this.desc = desc;
        return this;
    }

    @Override
    public int compare(File o1, File o2) {
        int result;
        int owner1 = o1.getCreatedBy();
        int owner2 = o2.getCreatedBy();
        if (owner1 > 0 && owner2 > 0) {
            result = this.collator.compare(this.getDisplayName(owner1), this.getDisplayName(owner2));
        } else {
            int n = owner1 < owner2 ? -1 : (result = owner1 == owner2 ? 0 : 1);
        }
        if (this.desc) {
            return result > 0 ? -1 : (result == 0 ? 0 : 1);
        }
        return result;
    }

    private String getDisplayName(int userId) {
        String displayName = (String)this.cache.get(userId);
        if (null == displayName) {
            try {
                displayName = UserStorage.getInstance().getUser(userId, this.context).getDisplayName();
            }
            catch (OXException e) {
                return null;
            }
            this.cache.put(userId, (Object)displayName);
        }
        return displayName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchIterator<File> resort(SearchIterator<File> iter, CreatedByComparator comparator) throws OXException {
        if (null == iter) {
            return null;
        }
        boolean close = true;
        try {
            LinkedList<Object> files = new LinkedList<Object>();
            while (iter.hasNext()) {
                files.add(iter.next());
            }
            iter.close();
            close = false;
            Collections.sort(files, comparator);
            SearchIteratorDelegator searchIteratorDelegator = new SearchIteratorDelegator(files);
            return searchIteratorDelegator;
        }
        finally {
            if (close) {
                iter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SearchIterator<File> resort(ServerSession session, SearchIterator<File> searchIterator, FileStorageFileAccess.SortDirection sortDirection) throws OXException {
        if (null == searchIterator) {
            return null;
        }
        try {
            List files = SearchIterators.asList(searchIterator);
            if (1 < files.size()) {
                CreatedByComparator comparator = new CreatedByComparator(session.getUser().getLocale(), session.getContext());
                comparator.setDescending(FileStorageFileAccess.SortDirection.DESC.equals((Object)sortDirection));
                Collections.sort(files, comparator);
            }
            SearchIteratorDelegator searchIteratorDelegator = new SearchIteratorDelegator((Collection)files);
            return searchIteratorDelegator;
        }
        finally {
            SearchIterators.close(searchIterator);
        }
    }
}

