/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.ajax.container.FileHolder;
import com.openexchange.ajax.fileholder.IFileHolder;
import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestDataTools;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.ajax.requesthandler.converters.preview.AbstractPreviewResultConverter;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.FileStorageUtility;
import com.openexchange.file.storage.composition.IDBasedFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.services.Services;
import com.openexchange.groupware.results.Delta;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.preview.PreviewOutput;
import com.openexchange.preview.PreviewService;
import com.openexchange.preview.RemoteInternalPreviewService;
import com.openexchange.session.Session;
import com.openexchange.startup.ThreadControlService;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPoolService;
import com.openexchange.threadpool.ThreadRenamer;
import com.openexchange.tools.iterator.SearchIterator;
import com.openexchange.tools.iterator.SearchIteratorDelegator;
import com.openexchange.tools.iterator.SearchIterators;
import com.openexchange.tools.session.ServerSession;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractListingAction
extends AbstractFileAction {
    static final Logger LOGGER = LoggerFactory.getLogger(AbstractListingAction.class);
    private static final String PARAMETER_PREGENERATE_PREVIEWS = "pregenerate_previews";

    protected AbstractListingAction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AJAXRequestResult result(TimedResult<File> documents, InfostoreRequest request) throws OXException {
        TimedResultImpl timedResult = documents;
        if (AJAXRequestDataTools.parseBoolParameter((String)PARAMETER_PREGENERATE_PREVIEWS, (AJAXRequestData)request.getRequestData())) {
            PreviewService previewService = Services.getPreviewService();
            ThreadPoolService threadPool = Services.getThreadPoolService();
            if (null != previewService && null != threadPool) {
                SearchIterator results = timedResult.results();
                try {
                    LinkedList<File> files = new LinkedList<File>();
                    while (results.hasNext()) {
                        File fileMetadata = (File)results.next();
                        files.add(fileMetadata);
                    }
                    SearchIteratorDelegator sf = new SearchIteratorDelegator(files);
                    timedResult = new TimedResultImpl((SearchIterator<File>)sf, timedResult.sequenceNumber());
                    threadPool.submit((Task)new TriggerPreviewServiceTask(files, FileStorageUtility.getNumberOfPregeneratedPreviews(), request, previewService, Services.getThreadControlService()));
                }
                finally {
                    SearchIterators.close((SearchIterator)results);
                }
            }
        }
        return new AJAXRequestResult(timedResult, "infostore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AJAXRequestResult results(SearchIterator<File> searchIterator, long timestamp, InfostoreRequest request) throws OXException {
        SearchIteratorDelegator results = searchIterator;
        if (AJAXRequestDataTools.parseBoolParameter((String)PARAMETER_PREGENERATE_PREVIEWS, (AJAXRequestData)request.getRequestData())) {
            PreviewService previewService = Services.getPreviewService();
            ThreadPoolService threadPool = Services.getThreadPoolService();
            if (null != previewService && null != threadPool) {
                try {
                    LinkedList<File> files = new LinkedList<File>();
                    while (results.hasNext()) {
                        File fileMetadata = (File)results.next();
                        files.add(fileMetadata);
                    }
                    results = new SearchIteratorDelegator(files);
                    threadPool.submit((Task)new TriggerPreviewServiceTask(files, FileStorageUtility.getNumberOfPregeneratedPreviews(), request, previewService, Services.getThreadControlService()));
                }
                catch (Throwable throwable) {
                    SearchIterators.close(searchIterator);
                    throw throwable;
                }
                SearchIterators.close((SearchIterator)searchIterator);
            }
        }
        return new AJAXRequestResult(results, new Date(timestamp), "infostore");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AJAXRequestResult results(SearchIterator<File> searchIterator, InfostoreRequest request) throws OXException {
        SearchIteratorDelegator results = searchIterator;
        if (AJAXRequestDataTools.parseBoolParameter((String)PARAMETER_PREGENERATE_PREVIEWS, (AJAXRequestData)request.getRequestData())) {
            PreviewService previewService = Services.getPreviewService();
            ThreadPoolService threadPool = Services.getThreadPoolService();
            if (null != previewService && null != threadPool) {
                try {
                    LinkedList<File> files = new LinkedList<File>();
                    while (results.hasNext()) {
                        File fileMetadata = (File)results.next();
                        files.add(fileMetadata);
                    }
                    results = new SearchIteratorDelegator(files);
                    threadPool.submit((Task)new TriggerPreviewServiceTask(files, FileStorageUtility.getNumberOfPregeneratedPreviews(), request, previewService, Services.getThreadControlService()));
                }
                catch (Throwable throwable) {
                    SearchIterators.close(searchIterator);
                    throw throwable;
                }
                SearchIterators.close((SearchIterator)searchIterator);
            }
        }
        return new AJAXRequestResult(results, null, "infostore");
    }

    protected AJAXRequestResult result(Delta<File> delta, InfostoreRequest request) throws OXException {
        return new AJAXRequestResult(delta, new Date(delta.sequenceNumber()), "infostore");
    }

    private static final class TimedResultImpl
    implements TimedResult<File> {
        private final SearchIterator<File> newIter;
        private final long sequenceNumber;

        TimedResultImpl(SearchIterator<File> newIter, long sequenceNumber) {
            this.newIter = newIter;
            this.sequenceNumber = sequenceNumber;
        }

        public long sequenceNumber() throws OXException {
            return this.sequenceNumber;
        }

        public SearchIterator<File> results() throws OXException {
            return this.newIter;
        }
    }

    private static final class TriggerPreviewServiceTask
    extends AbstractTask<Void> {
        private final ThreadControlService threadControl;
        final ServerSession session;
        private final List<File> files;
        private final AJAXRequestData requestData;
        private final PreviewService previewService;
        private int numberOfPregeneratedPreviews;
        private final boolean loadFileMetadata;

        TriggerPreviewServiceTask(List<File> files, int numberOfPregeneratedPreviews, InfostoreRequest request, PreviewService previewService, ThreadControlService threadControl) throws OXException {
            this.files = files;
            this.numberOfPregeneratedPreviews = numberOfPregeneratedPreviews;
            this.session = request.getSession();
            this.previewService = previewService;
            this.threadControl = null == threadControl ? ThreadControlService.DUMMY_CONTROL : threadControl;
            AJAXRequestData requestData = request.getRequestData().copyOf();
            requestData.putParameter("width", "160");
            requestData.putParameter("height", "160");
            requestData.putParameter("delivery", "view");
            requestData.putParameter("scaleType", "cover");
            this.requestData = requestData;
            List<File.Field> columns = request.getFieldsToLoad();
            if (null == columns || columns.isEmpty()) {
                this.loadFileMetadata = true;
            } else {
                boolean load = false;
                if (!columns.contains(File.Field.FILENAME)) {
                    load = true;
                }
                if (!load && !columns.contains(File.Field.FILE_MIMETYPE)) {
                    load = true;
                }
                if (!load && !columns.contains(File.Field.FILE_SIZE)) {
                    load = true;
                }
                this.loadFileMetadata = load;
            }
        }

        public void setThreadName(ThreadRenamer threadRenamer) {
            threadRenamer.renamePrefix("Async-DC-Trigger");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void call() {
            Thread currentThread = Thread.currentThread();
            boolean added = this.threadControl.addThread(currentThread);
            try {
                if (this.loadFileMetadata) {
                    IDBasedFileAccess fileAccess = Services.getFileAccessFactory().createAccess((Session)this.session);
                    Iterator<File> iter = this.files.iterator();
                    while (!currentThread.isInterrupted() && this.numberOfPregeneratedPreviews > 0 && iter.hasNext()) {
                        File fileMetadata = iter.next();
                        String id = fileMetadata.getId();
                        try {
                            fileMetadata = fileAccess.getFileMetadata(id, FileStorageFileAccess.CURRENT_VERSION);
                            this.triggerFor(id, fileMetadata);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to pre-generate preview image from file {} for user {} in context {}", new Object[]{fileMetadata.getId(), this.session.getUserId(), this.session.getContextId(), e});
                        }
                    }
                } else {
                    Iterator<File> iter = this.files.iterator();
                    while (!currentThread.isInterrupted() && this.numberOfPregeneratedPreviews > 0 && iter.hasNext()) {
                        File fileMetadata = iter.next();
                        if (fileMetadata.getFileSize() == 0L) continue;
                        String id = fileMetadata.getId();
                        try {
                            this.triggerFor(id, fileMetadata);
                        }
                        catch (Exception e) {
                            LOGGER.warn("Failed to pre-generate preview image from file {} for user {} in context {}", new Object[]{fileMetadata.getId(), this.session.getUserId(), this.session.getContextId(), e});
                        }
                    }
                }
            }
            finally {
                if (added) {
                    this.threadControl.removeThread(currentThread);
                }
            }
            return null;
        }

        private void triggerFor(final String id, File fileMetadata) {
            RemoteInternalPreviewService candidate = AbstractPreviewResultConverter.getRemoteInternalPreviewServiceFrom((PreviewService)this.previewService, (String)fileMetadata.getFileName(), (PreviewOutput)PreviewOutput.IMAGE);
            if (null != candidate) {
                IFileHolder.InputStreamClosure isClosure = new IFileHolder.InputStreamClosure(){

                    public InputStream newStream() throws OXException, IOException {
                        IDBasedFileAccess fileAccess = Services.getFileAccessFactory().createAccess((Session)TriggerPreviewServiceTask.this.session);
                        InputStream inputStream = fileAccess.getDocument(id, FileStorageFileAccess.CURRENT_VERSION);
                        if (inputStream instanceof BufferedInputStream || inputStream instanceof ByteArrayInputStream) {
                            return inputStream;
                        }
                        return new BufferedInputStream(inputStream, 65536);
                    }
                };
                FileHolder fileHolder = new FileHolder(isClosure, fileMetadata.getFileSize(), fileMetadata.getFileMIMEType(), fileMetadata.getFileName());
                AbstractPreviewResultConverter.triggerPreviewService((ServerSession)this.session, (IFileHolder)fileHolder, (AJAXRequestData)this.requestData, (RemoteInternalPreviewService)candidate, (PreviewOutput)PreviewOutput.IMAGE);
                LOGGER.debug("Triggered to create preview from file {} for user {} in context {}", new Object[]{id, this.session.getUserId(), this.session.getContextId()});
                --this.numberOfPregeneratedPreviews;
            } else {
                LOGGER.debug("Found no suitable {} service to trigger preview creation from file {} for user {} in context {}", new Object[]{RemoteInternalPreviewService.class.getSimpleName(), id, this.session.getUserId(), this.session.getContextId()});
            }
        }
    }
}

