/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.accounts;

import com.openexchange.ajax.requesthandler.AJAXRequestData;
import com.openexchange.ajax.requesthandler.AJAXRequestResult;
import com.openexchange.exception.OXException;
import com.openexchange.file.storage.AccountAware;
import com.openexchange.file.storage.CapabilityAware;
import com.openexchange.file.storage.FileStorageAccount;
import com.openexchange.file.storage.FileStorageAccountAccess;
import com.openexchange.file.storage.FileStorageCapability;
import com.openexchange.file.storage.FileStorageFolder;
import com.openexchange.file.storage.FileStorageService;
import com.openexchange.file.storage.json.actions.accounts.AbstractFileStorageAccountAction;
import com.openexchange.file.storage.registry.FileStorageServiceRegistry;
import com.openexchange.session.Session;
import com.openexchange.tools.session.ServerSession;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllAction
extends AbstractFileStorageAccountAction {
    static final Logger LOG = LoggerFactory.getLogger((String)AllAction.class.getName());

    public AllAction(FileStorageServiceRegistry registry) {
        super(registry);
    }

    @Override
    protected AJAXRequestResult doIt(AJAXRequestData request, ServerSession session) throws JSONException, OXException {
        String fsServiceId = request.getParameter("filestorageService");
        ArrayList<FileStorageService> services = new ArrayList<FileStorageService>();
        if (fsServiceId != null) {
            services.add(this.registry.getFileStorageService(fsServiceId));
        } else {
            services.addAll(this.registry.getAllServices());
        }
        JSONArray result = new JSONArray(services.size() << 1);
        AJAXRequestResult requestResult = new AJAXRequestResult((Object)result);
        for (FileStorageService fsService : services) {
            List userAccounts = null;
            if (fsService instanceof AccountAware) {
                userAccounts = ((AccountAware)fsService).getAccounts((Session)session);
            }
            if (null == userAccounts) {
                userAccounts = fsService.getAccountManager().getAccounts((Session)session);
            }
            for (FileStorageAccount account : userAccounts) {
                Set<String> caps;
                FileStorageAccountAccess access = null;
                try {
                    access = fsService.getAccountAccess(account.getId(), (Session)session);
                    FileStorageFolder rootFolder = access.getRootFolder();
                    if (null == rootFolder) continue;
                    caps = this.determineCapabilities(access);
                    result.put((Object)this.writer.write(account, rootFolder, caps));
                }
                catch (OXException e) {
                    LOG.debug(e.getMessage());
                    if (e.equalsCode(6, "OAUTH")) {
                        try {
                            fsService.getAccountManager().deleteAccount(account, (Session)session);
                        }
                        catch (Exception x) {}
                        continue;
                    }
                    caps = this.determineCapabilities(access);
                    result.put((Object)this.writer.write(account, null, caps, e, (Session)session));
                }
            }
        }
        return requestResult;
    }

    private Set<String> determineCapabilities(FileStorageAccountAccess access) {
        if (!(access instanceof CapabilityAware)) {
            return null;
        }
        CapabilityAware capabilityAware = (CapabilityAware)access;
        HashSet<String> caps = new HashSet<String>();
        Boolean supported = capabilityAware.supports(FileStorageCapability.FILE_VERSIONS);
        if (null != supported && supported.booleanValue()) {
            caps.add(FileStorageCapability.FILE_VERSIONS.name());
        }
        if (null != (supported = capabilityAware.supports(FileStorageCapability.EXTENDED_METADATA)) && supported.booleanValue()) {
            caps.add(FileStorageCapability.EXTENDED_METADATA.name());
        }
        if (null != (supported = capabilityAware.supports(FileStorageCapability.RANDOM_FILE_ACCESS)) && supported.booleanValue()) {
            caps.add(FileStorageCapability.RANDOM_FILE_ACCESS.name());
        }
        if (null != (supported = capabilityAware.supports(FileStorageCapability.LOCKS)) && supported.booleanValue()) {
            caps.add(FileStorageCapability.LOCKS.name());
        }
        return caps;
    }
}

