/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.DefaultFile;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.json.actions.files.AbstractFileAction;
import com.openexchange.file.storage.json.actions.files.FileActionTest;
import com.openexchange.file.storage.json.actions.files.InfostoreRequest;
import com.openexchange.file.storage.json.actions.files.RevertAction;
import com.openexchange.groupware.results.TimedResult;
import com.openexchange.tools.iterator.ArrayIterator;
import com.openexchange.tools.iterator.SearchIterator;
import java.util.Date;

public class RevertTest
extends FileActionTest {
    public void testMissingParameters() {
        try {
            this.action.handle((InfostoreRequest)this.request());
            RevertTest.fail((String)"Expected Exception due to missing parameters");
        }
        catch (OXException x) {
            RevertTest.assertTrue((boolean)true);
        }
    }

    public void testAction() throws OXException {
        this.request().param("id", "12");
        final DefaultFile f1 = new DefaultFile();
        f1.setVersion("0");
        final DefaultFile f2 = new DefaultFile();
        f2.setVersion("3");
        final DefaultFile f3 = new DefaultFile();
        f3.setVersion("4");
        this.fileAccess().expectCall("getVersions", new Object[]{"12"}).andReturn((Object)new TimedResult<File>(){

            public SearchIterator<File> results() throws OXException {
                return new ArrayIterator((Object[])new File[]{f1, f2, f3});
            }

            public long sequenceNumber() throws OXException {
                return 0L;
            }
        });
        this.fileAccess().expectCall("removeVersion", new Object[]{"12", new int[]{3, 4}}).andReturn((Object)new int[0]);
        DefaultFile updated = new DefaultFile();
        updated.setLastModified(new Date());
        this.fileAccess().expectCall("getFileMetadata", new Object[]{"12", FileStorageFileAccess.CURRENT_VERSION}).andReturn((Object)updated);
        this.perform();
        this.fileAccess().assertAllWereCalled();
    }

    @Override
    public AbstractFileAction createAction() {
        return new RevertAction();
    }
}

