/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.file.storage.json.actions.files;

import com.openexchange.exception.OXException;
import com.openexchange.file.storage.File;
import com.openexchange.file.storage.FileStorageFileAccess;
import com.openexchange.file.storage.json.FileTest;
import com.openexchange.groupware.ldap.SimUser;
import com.openexchange.groupware.ldap.User;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class InfostoreRequestTest
extends FileTest {
    public void testShouldGetTheFolderId() throws OXException {
        this.request().param("folder", "12");
        InfostoreRequestTest.assertEquals((String)this.request.getFolderId(), (String)"12");
    }

    public void testShouldGetColumns() throws OXException {
        this.request().param("columns", "1,700,702");
        InfostoreRequestTest.assertEquals(Arrays.asList(File.Field.ID, File.Field.TITLE, File.Field.FILENAME), (Object)this.request.getFieldsToLoad());
    }

    public void testShouldGetColumnsByName() throws OXException {
        this.request().param("columns", "id,title,filename");
        InfostoreRequestTest.assertEquals(Arrays.asList(File.Field.ID, File.Field.TITLE, File.Field.FILENAME), (Object)this.request.getFieldsToLoad());
    }

    public void testColumnsDefaultToAllColumns() throws OXException {
        InfostoreRequestTest.assertEquals(Arrays.asList(File.Field.values()), (Object)this.request().getFieldsToLoad());
    }

    public void testUnknownColumns() {
        this.request().param("columns", "1,700,702,1023");
        try {
            this.request.getFieldsToLoad();
            InfostoreRequestTest.fail((String)"Expected Exception");
        }
        catch (OXException x) {
            InfostoreRequestTest.assertTrue((boolean)true);
        }
    }

    public void testInvalidColumnString() {
        this.request().param("columns", "1,700,702,niceColumn");
        try {
            this.request.getFieldsToLoad();
            InfostoreRequestTest.fail((String)"Expected Exception");
        }
        catch (OXException x) {
            InfostoreRequestTest.assertTrue((boolean)true);
        }
    }

    public void testSortingColumn() throws OXException {
        this.request().param("sort", "700");
        InfostoreRequestTest.assertEquals((Object)File.Field.TITLE, (Object)this.request.getSortingField());
        this.request().param("sort", "title");
        InfostoreRequestTest.assertEquals((Object)File.Field.TITLE, (Object)this.request.getSortingField());
    }

    public void testUnsetSortingColumn() throws OXException {
        InfostoreRequestTest.assertEquals(null, (Object)this.request().getSortingField());
    }

    public void testUnknownSortingColumn() {
        try {
            this.request().param("sort", "1024").getSortingField();
            InfostoreRequestTest.fail((String)"Expected Exception");
        }
        catch (OXException x) {
            InfostoreRequestTest.assertTrue((boolean)true);
        }
        try {
            this.request().param("sort", "gnitzness").getSortingField();
            InfostoreRequestTest.fail((String)"Expected Exception");
        }
        catch (OXException x) {
            InfostoreRequestTest.assertTrue((boolean)true);
        }
    }

    public void testGetSortingOrder() throws OXException {
        this.request().param("order", "asc");
        InfostoreRequestTest.assertEquals((Object)FileStorageFileAccess.SortDirection.ASC, (Object)this.request.getSortingOrder());
        this.request().param("order", "desc");
        InfostoreRequestTest.assertEquals((Object)FileStorageFileAccess.SortDirection.DESC, (Object)this.request.getSortingOrder());
    }

    public void testSortingOrderDefault() throws OXException {
        InfostoreRequestTest.assertEquals((Object)FileStorageFileAccess.SortDirection.ASC, (Object)this.request().getSortingOrder());
    }

    public void testInvalidSortingOrder() {
        try {
            this.request().param("order", "supercalifragilisticexplialidocious").getSortingOrder();
            InfostoreRequestTest.fail((String)"Expected Exception");
        }
        catch (OXException x) {
            InfostoreRequestTest.assertTrue((boolean)true);
        }
    }

    public void testGetTimezone() throws OXException {
        this.request().param("timezone", "Europe/Berlin");
        InfostoreRequestTest.assertEquals((Object)TimeZone.getTimeZone("Europe/Berlin"), (Object)this.request.getTimezone());
    }

    public void testGetTimezoneDefaultsToUserTimeZone() throws OXException {
        SimUser simUser = new SimUser();
        simUser.setTimeZone("Europe/Berlin");
        this.request().getSimSession().setUser((User)simUser);
        InfostoreRequestTest.assertEquals((Object)TimeZone.getTimeZone("Europe/Berlin"), (Object)this.request.getTimezone());
    }

    public void testGetId() {
        String id = this.request().param("id", "12").getId();
        InfostoreRequestTest.assertEquals((String)"12", (String)id);
    }

    public void testGetVersion() {
        String version = this.request().param("version", "2").getVersion();
        InfostoreRequestTest.assertEquals((String)"2", (String)version);
    }

    public void testGetVersionDefaultsToCurrentVersion() {
        String version = this.request().getVersion();
        InfostoreRequestTest.assertEquals((String)FileStorageFileAccess.CURRENT_VERSION, (String)version);
    }

    public void testGetIgnore() {
        Set ignore = this.request().param("ignore", "deleted,nice,blue").getIgnore();
        InfostoreRequestTest.assertEquals(new HashSet<String>(Arrays.asList("deleted", "nice", "blue")), (Object)ignore);
    }

    public void testGetTimestamp() {
        long timestamp = this.request().param("timestamp", "1337").getTimestamp();
        InfostoreRequestTest.assertEquals((long)1337L, (long)timestamp);
    }

    public void testTimestampDefaultsToDistantPast() {
        long timestamp = this.request().getTimestamp();
        InfostoreRequestTest.assertEquals((long)-1L, (long)timestamp);
    }

    public void testGetIDs() throws JSONException, OXException {
        List ids = this.request().body(new JSONArray("[{id: 'id1', folder: 'folder'}, {id: 'id2', folder: 'folder'}]")).getIds();
        InfostoreRequestTest.assertEquals(Arrays.asList("id1", "id2"), (Object)ids);
    }

    public void testGetVersions() throws JSONException, OXException {
        String[] versions = this.request().body(new JSONArray("[1,3,5]")).getVersions();
        InfostoreRequestTest.assertEquals((String)"1", (String)versions[0]);
        InfostoreRequestTest.assertEquals((String)"3", (String)versions[1]);
        InfostoreRequestTest.assertEquals((String)"5", (String)versions[2]);
    }

    public void testGetDiff() {
        long diff = this.request().param("diff", "1337").getDiff();
        InfostoreRequestTest.assertEquals((long)1337L, (long)diff);
        diff = this.request().getDiff();
        InfostoreRequestTest.assertEquals((long)-1L, (long)diff);
    }

    public void testStartAndEnd() throws OXException {
        this.request().param("start", "10").param("end", "20");
        InfostoreRequestTest.assertEquals((int)10, (int)this.request.getStart());
        InfostoreRequestTest.assertEquals((int)20, (int)this.request.getEnd());
    }

    public void testLimit() throws OXException {
        this.request().param("limit", "12");
        InfostoreRequestTest.assertEquals((int)0, (int)this.request.getStart());
        InfostoreRequestTest.assertEquals((int)11, (int)this.request.getEnd());
    }

    public void testStartAndEndUnset() throws OXException {
        this.request();
        InfostoreRequestTest.assertEquals((int)-11, (int)this.request.getStart());
        InfostoreRequestTest.assertEquals((int)-11, (int)this.request.getEnd());
    }

    public void testSearchFolder() throws OXException {
        String searchFolderId = this.request().param("folder", "12").getSearchFolderId();
        InfostoreRequestTest.assertEquals((String)"12", (String)searchFolderId);
    }

    public void testSearchFolderDefaultsToAllFolders() throws OXException {
        String searchFolderId = this.request().getSearchFolderId();
        InfostoreRequestTest.assertEquals((String)FileStorageFileAccess.ALL_FOLDERS, (String)searchFolderId);
    }

    public void testSearchQuery() throws JSONException, OXException {
        String searchQuery = this.request().body(new JSONObject("{pattern: 'somePattern'}")).getSearchQuery();
        InfostoreRequestTest.assertEquals((String)"somePattern", (String)searchQuery);
    }
}

