/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.config.osgi;

import com.openexchange.config.ForcedReloadable;
import com.openexchange.config.internal.ConfigurationImpl;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForcedReloadableServiceTracker
implements ServiceTrackerCustomizer<ForcedReloadable, ForcedReloadable> {
    private static final Logger LOG = LoggerFactory.getLogger(ForcedReloadableServiceTracker.class);
    private final ConfigurationImpl configService;
    private final BundleContext context;

    public ForcedReloadableServiceTracker(BundleContext context, ConfigurationImpl configService) {
        this.context = context;
        this.configService = configService;
    }

    public ForcedReloadable addingService(ServiceReference<ForcedReloadable> serviceRef) {
        ForcedReloadable service = (ForcedReloadable)this.context.getService(serviceRef);
        if (this.configService.addReloadable(service)) {
            LOG.debug("Reloadable service added: {}", (Object)service.getClass().getName());
            return service;
        }
        this.context.ungetService(serviceRef);
        return null;
    }

    public void modifiedService(ServiceReference<ForcedReloadable> serviceRef, ForcedReloadable reloadable) {
    }

    public void removedService(ServiceReference<ForcedReloadable> serviceRef, ForcedReloadable reloadable) {
        this.configService.removeReloadable(reloadable);
        LOG.debug("Reloadable service removed: {}", (Object)reloadable.getClass().getName());
        this.context.ungetService(serviceRef);
    }
}

