/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.xml.appointment;

import com.openexchange.exception.OXException;
import com.openexchange.group.Group;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.container.GroupParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.webdav.xml.AppointmentTest;
import com.openexchange.webdav.xml.AttachmentTest;
import com.openexchange.webdav.xml.FolderTest;
import com.openexchange.webdav.xml.GroupUserTest;
import java.io.ByteArrayInputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class NewTest
extends AppointmentTest {
    public NewTest(String name) {
        super(name);
    }

    public void testNewAppointment() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testNewAppointment");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj.setObjectID(objectId);
        Thread.sleep(1000L);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        Date modified = loadAppointment.getLastModified();
        loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, NewTest.decrementDate(modified), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        NewTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testNewAppointmentWithAlarm() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testNewAppointmentWithAlarm");
        appointmentObj.setIgnoreConflicts(true);
        appointmentObj.setAlarm(45);
        int objectId = NewTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj.setObjectID(objectId);
        appointmentObj.setAlarmFlag(true);
        Thread.sleep(1000L);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        Date modified = loadAppointment.getLastModified();
        loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, NewTest.decrementDate(modified), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        NewTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testNewAppointmentWithParticipants() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testNewAppointmentWithParticipants");
        appointmentObj.setIgnoreConflicts(true);
        Group[] groupArray = GroupUserTest.searchGroup(this.getWebConversation(), this.groupParticipant, new Date(0L), "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.assertTrue((String)"group array size is not > 0", (groupArray.length > 0 ? 1 : 0) != 0);
        int groupParticipantId = groupArray[0].getIdentifier();
        Participant[] participants = new Participant[]{new UserParticipant(this.userId), new GroupParticipant(groupParticipantId)};
        appointmentObj.setParticipants(participants);
        int objectId = NewTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj.setObjectID(objectId);
        Thread.sleep(1000L);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        Date modified = loadAppointment.getLastModified();
        loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, NewTest.decrementDate(modified), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        NewTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testNewAppointmentWithUsers() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testNewAppointmentWithUsers");
        appointmentObj.setIgnoreConflicts(true);
        int userParticipantId = GroupUserTest.getUserId(this.getSecondWebConversation(), "http://" + this.getHostName(), this.getSecondLogin(), this.getPassword(), this.context);
        NewTest.assertTrue((String)"user participant not found", (userParticipantId != -1 ? 1 : 0) != 0);
        UserParticipant[] users = new UserParticipant[2];
        users[0] = new UserParticipant(this.userId);
        users[0].setConfirm(1);
        users[1] = new UserParticipant(userParticipantId);
        users[1].setConfirm(2);
        appointmentObj.setUsers(users);
        appointmentObj.setParticipants((Participant[])users);
        int objectId = NewTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj.setObjectID(objectId);
        Thread.sleep(1000L);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        Date modified = loadAppointment.getLastModified();
        loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, NewTest.decrementDate(modified), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        NewTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testNewAppointmentWithExternalUserParticipants() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testNewAppointmentWithExternalParticipants");
        appointmentObj.setIgnoreConflicts(true);
        int userParticipantId = GroupUserTest.getUserId(this.getWebConversation(), "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.assertTrue((String)"user participant not found", (userParticipantId != -1 ? 1 : 0) != 0);
        Participant[] participant = new Participant[]{new UserParticipant(this.userId), new ExternalUserParticipant("externaluser@example.org")};
        appointmentObj.setParticipants(participant);
        int objectId = NewTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj.setObjectID(objectId);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        Date modified = loadAppointment.getLastModified();
        loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, NewTest.decrementDate(modified), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        int[][] objectIdAndFolderId = new int[][]{{objectId, this.appointmentFolderId}};
        NewTest.deleteAppointment(this.webCon, objectIdAndFolderId, "http://" + this.hostName, this.login, this.password, this.context);
    }

    public void testDailyRecurrence() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date until = new Date(c.getTimeInMillis() + 1296000000L);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDailyRecurrence");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setUntil(until);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(objectId);
        Thread.sleep(1000L);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        Date modified = loadAppointment.getLastModified();
        loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, NewTest.decrementDate(modified), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testDailyRecurrenceWithOccurrences() throws Exception {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        c.setTime(this.startTime);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        int occurrences = 5;
        c.add(5, 4);
        Date until = c.getTime();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDailyRecurrence");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOccurrence(5);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(objectId);
        appointmentObj.setUntil(until);
        Thread.sleep(1000L);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        Date modified = loadAppointment.getLastModified();
        loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, NewTest.decrementDate(modified), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testDailyFullTimeRecurrenceWithOccurrences() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        int occurrences = 2;
        Date startDate = c.getTime();
        Date endDate = new Date(c.getTimeInMillis() + 86400000L);
        Date until = new Date(startDate.getTime() + 86400000L);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDailyFullTimeRecurrenceWithOccurrences");
        appointmentObj.setStartDate(startDate);
        appointmentObj.setEndDate(endDate);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setFullTime(true);
        appointmentObj.setOccurrence(2);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setObjectID(objectId);
        appointmentObj.setUntil(until);
        Thread.sleep(1000L);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        Date modified = loadAppointment.getLastModified();
        loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, NewTest.decrementDate(modified), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testAppointmentInPrivateFlagInPublicFolder() throws Exception {
        FolderObject folderObj = new FolderObject();
        folderObj.setFolderName("testAppointmentInPrivateFlagInPublicFolder" + System.currentTimeMillis());
        folderObj.setModule(2);
        folderObj.setType(2);
        folderObj.setParentFolderID(2);
        OCLPermission[] permission = new OCLPermission[]{FolderTest.createPermission(this.userId, false, 128, 128, 128, 128)};
        folderObj.setPermissionsAsArray(permission);
        int parentFolderId = FolderTest.insertFolder(this.getWebConversation(), folderObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testAppointmentInPrivateFlagInPublicFolder");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(parentFolderId);
        appointmentObj.setPrivateFlag(true);
        appointmentObj.setIgnoreConflicts(true);
        try {
            int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
            NewTest.deleteAppointment(this.getWebConversation(), objectId, parentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
            NewTest.fail((String)"conflict exception expected!");
        }
        catch (OXException exc) {
            NewTest.assertExceptionMessage(exc.getDisplayMessage(Locale.ENGLISH), "APP-0070");
        }
        FolderTest.deleteFolder(this.getWebConversation(), new int[]{parentFolderId}, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testDailyRecurrenceWithDeletingFirstOccurrence() throws Exception {
        Calendar c = Calendar.getInstance();
        c.setTime(this.startTime);
        c.setTimeZone(TimeZone.getTimeZone("UTC"));
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        int occurrences = 5;
        Date recurrenceDatePosition = c.getTime();
        c.add(5, 4);
        Date until = c.getTime();
        Appointment appointmentObj = new Appointment();
        appointmentObj.setTitle("testDailyRecurrenceWithDeletingFirstOccurrence");
        appointmentObj.setStartDate(this.startTime);
        appointmentObj.setEndDate(this.endTime);
        appointmentObj.setShownAs(3);
        appointmentObj.setParentFolderID(this.appointmentFolderId);
        appointmentObj.setRecurrenceType(1);
        appointmentObj.setInterval(1);
        appointmentObj.setOccurrence(5);
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.getWebConversation(), appointmentObj, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Date modified = loadAppointment.getLastModified();
        appointmentObj.setObjectID(objectId);
        appointmentObj.setUntil(until);
        NewTest.compareObject(appointmentObj, loadAppointment);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, modified, recurrenceDatePosition, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        appointmentObj.setDeleteExceptions(new Date[]{recurrenceDatePosition});
        Thread.sleep(1000L);
        loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        modified = loadAppointment.getLastModified();
        loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, NewTest.decrementDate(modified), this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        NewTest.compareObject(appointmentObj, loadAppointment);
        NewTest.deleteAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, "http://" + this.getHostName(), this.getLogin(), this.getPassword(), this.context);
    }

    public void testAppointmentWithAttachment() throws Exception {
        Appointment appointmentObj = this.createAppointmentObject("testContactWithAttachment");
        appointmentObj.setIgnoreConflicts(true);
        int objectId = NewTest.insertAppointment(this.webCon, appointmentObj, "http://" + this.hostName, this.login, this.password, this.context);
        appointmentObj.setObjectID(objectId);
        AttachmentImpl attachmentMeta = new AttachmentImpl();
        attachmentMeta.setAttachedId(objectId);
        attachmentMeta.setFolderId(this.appointmentFolderId);
        attachmentMeta.setFileMIMEType("text/plain");
        attachmentMeta.setModuleId(1);
        attachmentMeta.setFilename("test.txt");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream("test".getBytes());
        AttachmentTest.insertAttachment(this.webCon, (AttachmentMetadata)attachmentMeta, byteArrayInputStream, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment loadAppointment = NewTest.loadAppointment(this.getWebConversation(), objectId, this.appointmentFolderId, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        Appointment[] appointmentArray = NewTest.listAppointment(this.getWebConversation(), this.appointmentFolderId, NewTest.decrementDate(loadAppointment.getLastModified()), true, false, this.getHostName(), this.getLogin(), this.getPassword(), this.context);
        boolean found = false;
        for (int a = 0; a < appointmentArray.length; ++a) {
            if (appointmentArray[a].getObjectID() != objectId) continue;
            NewTest.compareObject(appointmentObj, appointmentArray[a]);
            found = true;
        }
        NewTest.assertTrue((String)"appointment not found", (boolean)found);
    }
}

