/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.test.json;

import com.openexchange.test.json.JSONCondition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONValue;
import org.junit.Assert;

public class JSONAssertion
implements JSONCondition {
    private final Stack<JSONAssertion> stack = new Stack();
    private final List<JSONCondition> conditions = new LinkedList<JSONCondition>();
    private String key;
    private String complaint;
    private int lastIndex;

    public static final void assertValidates(JSONAssertion assertion, Object o) {
        Assert.assertNotNull((String)"Object was null", (Object)o);
        if (!assertion.validate(o)) {
            Assert.fail((String)assertion.getComplaint());
        }
    }

    public static boolean equals(JSONValue jsonValue1, JSONValue jsonValue2) {
        if (jsonValue1 == jsonValue2) {
            return true;
        }
        if (null == jsonValue1) {
            return null == jsonValue2;
        }
        if (null == jsonValue2) {
            return false;
        }
        if (jsonValue1.isArray()) {
            if (!jsonValue2.isArray()) {
                return false;
            }
            return JSONAssertion.getListFrom(jsonValue1.toArray()).equals(JSONAssertion.getListFrom(jsonValue2.toArray()));
        }
        if (jsonValue1.isObject()) {
            if (!jsonValue2.isObject()) {
                return false;
            }
            return JSONAssertion.getMapFrom(jsonValue1.toObject()).equals(JSONAssertion.getMapFrom(jsonValue2.toObject()));
        }
        return false;
    }

    public static boolean equals(Object jsonData1, Object jsonData2) {
        if (jsonData1 == jsonData2) {
            return true;
        }
        if (null == jsonData1) {
            return null == jsonData2;
        }
        if (null == jsonData2) {
            return false;
        }
        if (!jsonData1.getClass().equals(jsonData2.getClass())) {
            return false;
        }
        return JSONAssertion.getFrom(jsonData2).equals(JSONAssertion.getFrom(jsonData2));
    }

    private static List<Object> getListFrom(JSONArray jsonArray) {
        int length = jsonArray.length();
        ArrayList<Object> list = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            try {
                list.add(JSONAssertion.getFrom(jsonArray.get(i)));
                continue;
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        return list;
    }

    private static Map<String, Object> getMapFrom(JSONObject jsonObject) {
        int length = jsonObject.length();
        HashMap<String, Object> map = new HashMap<String, Object>(length);
        for (Map.Entry entry : jsonObject.entrySet()) {
            map.put((String)entry.getKey(), JSONAssertion.getFrom(entry.getValue()));
        }
        return map;
    }

    private static Object getFrom(Object object) {
        if (object instanceof JSONArray) {
            return JSONAssertion.getListFrom((JSONArray)object);
        }
        if (object instanceof JSONObject) {
            return JSONAssertion.getMapFrom((JSONObject)object);
        }
        return object;
    }

    public JSONAssertion isObject() {
        if (!this.stack.isEmpty()) {
            this.stack.peek().isObject();
        } else {
            this.conditions.add(new IsOfType(JSONObject.class));
        }
        return this;
    }

    public JSONAssertion hasKey(String key) {
        if (!this.stack.isEmpty()) {
            this.stack.peek().hasKey(key);
        } else {
            this.conditions.add(new HasKey(key));
            this.key = key;
        }
        return this;
    }

    public JSONAssertion lacksKey(String key) {
        if (!this.stack.isEmpty()) {
            this.stack.peek().lacksKey(key);
        } else {
            this.conditions.add(new LacksKey(key));
            this.key = key;
        }
        return this;
    }

    public JSONAssertion withValue(Object value) {
        if (!this.stack.isEmpty()) {
            this.stack.peek().withValue(value);
        } else {
            this.conditions.add(new KeyValuePair(this.key, value));
        }
        return this;
    }

    public JSONAssertion withValueObject() {
        JSONAssertion stackElement = new JSONAssertion();
        this.conditions.add(new ValueObject(this.key, stackElement));
        stackElement.isObject();
        this.stack.push(stackElement);
        return this;
    }

    public JSONAssertion withValueArray() {
        JSONAssertion stackElement = new JSONAssertion();
        this.conditions.add(new ValueArray(this.key, stackElement));
        stackElement.isArray();
        this.stack.push(stackElement);
        return this;
    }

    public JSONAssertion atIndex(int i) {
        if (!this.stack.isEmpty()) {
            this.stack.peek().atIndex(i);
            return this;
        }
        this.lastIndex = i;
        this.conditions.add(new HasIndex(i));
        return null;
    }

    public JSONAssertion hasNoMoreKeys() {
        if (!this.stack.isEmpty()) {
            this.stack.pop();
        }
        return this;
    }

    public JSONAssertion isArray() {
        this.conditions.add(new IsOfType(JSONArray.class));
        return this;
    }

    public JSONAssertion withValues(Object ... values) {
        this.conditions.add(new WithValues(values));
        return this;
    }

    public JSONAssertion objectEnds() {
        return this.hasNoMoreKeys();
    }

    @Override
    public boolean validate(Object o) {
        for (JSONCondition condition : this.conditions) {
            if (condition.validate(o)) continue;
            this.complaint = condition.getComplaint();
            return false;
        }
        return true;
    }

    @Override
    public String getComplaint() {
        return this.complaint;
    }

    private static final class WithValues
    implements JSONCondition {
        private final Object[] values;
        private String complaint;

        public WithValues(Object[] values) {
            this.values = values;
        }

        @Override
        public boolean validate(Object o) {
            JSONArray arr = (JSONArray)o;
            if (arr.length() != this.values.length) {
                this.complaint = "Lengths differ: expected " + this.values.length + " was: " + arr.length();
                return false;
            }
            for (int i = 0; i < this.values.length; ++i) {
                Object actual;
                Object expected = this.values[i];
                try {
                    actual = arr.get(i);
                }
                catch (JSONException e) {
                    this.complaint = e.toString();
                    return false;
                }
                if (expected.equals(actual)) continue;
                this.complaint = "Expected " + expected + " got: " + actual + " at index " + i;
                return false;
            }
            return true;
        }

        @Override
        public String getComplaint() {
            return this.complaint;
        }
    }

    private static final class ValueArray
    implements JSONCondition {
        private final String key;
        private final JSONAssertion assertion;

        public ValueArray(String key, JSONAssertion assertion) {
            this.key = key;
            this.assertion = assertion;
        }

        @Override
        public String getComplaint() {
            return this.assertion.getComplaint();
        }

        @Override
        public boolean validate(Object o) {
            try {
                Object subObject = ((JSONObject)o).get(this.key);
                return this.assertion.validate(subObject);
            }
            catch (JSONException x) {
                return false;
            }
        }
    }

    private static final class ValueObject
    implements JSONCondition {
        private final String key;
        private final JSONAssertion assertion;

        public ValueObject(String key, JSONAssertion assertion) {
            this.key = key;
            this.assertion = assertion;
        }

        @Override
        public String getComplaint() {
            return this.assertion.getComplaint();
        }

        @Override
        public boolean validate(Object o) {
            try {
                Object subObject = ((JSONObject)o).get(this.key);
                return this.assertion.validate(subObject);
            }
            catch (JSONException x) {
                return false;
            }
        }
    }

    private static final class KeyValuePair
    implements JSONCondition {
        private final String key;
        private final Object value;
        private String complaint;

        public KeyValuePair(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean validate(Object o) {
            try {
                Object object = ((JSONObject)o).get(this.key);
                if (!object.equals(this.value)) {
                    this.complaint = "Expected value " + this.value + " for key " + this.key + " but got " + object;
                    return false;
                }
                return true;
            }
            catch (JSONException e) {
                return false;
            }
        }

        @Override
        public String getComplaint() {
            return this.complaint;
        }
    }

    private static final class HasIndex
    implements JSONCondition {
        private final int index;

        public HasIndex(int index) {
            this.index = index;
        }

        @Override
        public boolean validate(Object o) {
            return ((JSONArray)o).length() > this.index;
        }

        @Override
        public String getComplaint() {
            return "Missing index: " + this.index;
        }
    }

    private static final class LacksKey
    implements JSONCondition {
        private final String key;

        public LacksKey(String key) {
            this.key = key;
        }

        @Override
        public boolean validate(Object o) {
            return !((JSONObject)o).has(this.key);
        }

        @Override
        public String getComplaint() {
            return "Key should be missing: " + this.key;
        }
    }

    private static final class HasKey
    implements JSONCondition {
        private final String key;

        public HasKey(String key) {
            this.key = key;
        }

        @Override
        public boolean validate(Object o) {
            return ((JSONObject)o).has(this.key);
        }

        @Override
        public String getComplaint() {
            return "Missing key: " + this.key;
        }
    }

    private static final class IsOfType
    implements JSONCondition {
        private String complaint;
        private final Class type;

        public IsOfType(Class type) {
            this.type = type;
        }

        @Override
        public boolean validate(Object o) {
            boolean isCorrectType = this.type.isInstance(o);
            if (!isCorrectType) {
                this.complaint = "Expected " + this.type.getName() + " was: " + o.getClass().getName();
            }
            return isCorrectType;
        }

        @Override
        public String getComplaint() {
            return this.complaint;
        }
    }
}

