/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.messagestorage;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.contexts.impl.ContextImpl;
import com.openexchange.mail.AbstractMailTest;
import com.openexchange.mail.MailPath;
import com.openexchange.mail.api.MailAccess;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.compose.ComposedMailMessage;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObject;
import com.openexchange.smtp.dataobjects.SMTPMailMessage;
import java.util.Arrays;
import java.util.HashSet;
import javax.mail.internet.InternetAddress;

public final class MailSaveDraftTest
extends AbstractMailTest {
    public MailSaveDraftTest() {
    }

    public MailSaveDraftTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMailDraft() {
        try {
            String uid;
            String draftFullname;
            MailAccess mailAccess;
            block12: {
                SessionObject session = this.getSession();
                ContextImpl dummyContext = new ContextImpl(session.getContextId());
                SMTPMailMessage draftMail = new SMTPMailMessage("The first line", (Session)session, (Context)dummyContext);
                draftMail.addFrom(new InternetAddress("someone@somewhere.com", true));
                draftMail.addTo(new InternetAddress("someone.else@another.com", true));
                mailAccess = MailAccess.getInstance((Session)session);
                mailAccess.connect();
                draftFullname = mailAccess.getFolderStorage().getDraftsFolder();
                String prevUid = null;
                uid = null;
                try {
                    MailMessage mail = mailAccess.getMessageStorage().saveDraft(draftFullname, (ComposedMailMessage)draftMail);
                    prevUid = uid = mail.getMailId();
                    String content = mail.getContent().toString();
                    MailSaveDraftTest.assertEquals((String)"Content mismatch", (String)"The first line", (String)content);
                    draftMail = new SMTPMailMessage("The first line<br>And the second line", (Session)session, (Context)dummyContext);
                    draftMail.addFrom(new InternetAddress("someone@somewhere.com", true));
                    draftMail.addTo(new InternetAddress("someone.else@another.com", true));
                    draftMail.addTo(new InternetAddress("Jane Doe <another.one@anywhere.org>", true));
                    draftMail.setMsgref(new MailPath(mailAccess.getAccountId(), mail.getFolder(), mail.getMailId()));
                    mail = mailAccess.getMessageStorage().saveDraft(draftFullname, (ComposedMailMessage)draftMail);
                    uid = mail.getMailId();
                    OXException exc = null;
                    MailMessage tmp = null;
                    try {
                        tmp = mailAccess.getMessageStorage().getMessage(draftFullname, prevUid, false);
                    }
                    catch (OXException e) {
                        prevUid = null;
                        exc = e;
                    }
                    MailSaveDraftTest.assertTrue((String)"Former draft version still available", (exc != null || tmp == null ? 1 : 0) != 0);
                    String expected = "The first line<br>And the second line";
                    HashSet<String> expectees = new HashSet<String>(Arrays.asList("The first line<br>And the second line", "The first line\nAnd the second line", "The first line\r\nAnd the second line"));
                    content = mail.getContent().toString();
                    if (!expectees.contains(content)) {
                        int i;
                        StringBuilder sb = new StringBuilder(1024);
                        sb.append("Expected value:\n");
                        char[] chars = "The first line<br>And the second line".toCharArray();
                        sb.append((int)chars[0]);
                        for (i = 1; i < chars.length; ++i) {
                            sb.append(' ').append((int)chars[i]);
                        }
                        sb.append("\nReturned value:\n");
                        chars = content.toCharArray();
                        sb.append((int)chars[0]);
                        for (i = 1; i < chars.length; ++i) {
                            sb.append(' ').append((int)chars[i]);
                        }
                        sb.append("\nIn words:");
                        sb.append('\"').append("The first line<br>And the second line").append('\"').append('\n');
                        sb.append('\"').append(content).append('\"');
                        MailSaveDraftTest.fail((String)sb.toString());
                    }
                    if (prevUid == null) break block12;
                }
                catch (Throwable throwable) {
                    if (prevUid != null) {
                        mailAccess.getMessageStorage().deleteMessages(draftFullname, new String[]{prevUid}, true);
                    }
                    if (uid != null) {
                        mailAccess.getMessageStorage().deleteMessages(draftFullname, new String[]{uid}, true);
                    }
                    mailAccess.close(false);
                    throw throwable;
                }
                mailAccess.getMessageStorage().deleteMessages(draftFullname, new String[]{prevUid}, true);
            }
            if (uid != null) {
                mailAccess.getMessageStorage().deleteMessages(draftFullname, new String[]{uid}, true);
            }
            mailAccess.close(false);
        }
        catch (Exception e) {
            e.printStackTrace();
            MailSaveDraftTest.fail((String)e.getMessage());
        }
    }
}

