/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.update;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentBaseImpl;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.filestore.FilestoreStorage;
import com.openexchange.groupware.update.UpdateTest;
import com.openexchange.groupware.update.tasks.ClearLeftoverAttachmentsUpdateTask;
import com.openexchange.session.Session;
import com.openexchange.tools.file.FileStorage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ClearLeftoverAttachmentsTest
extends UpdateTest {
    private AttachmentBase attachmentBase;
    private static final int OFFSET = 3;
    private final List<AttachmentImpl> attachments = new ArrayList<AttachmentImpl>();

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.attachmentBase = new AttachmentBaseImpl(this.getProvider());
        this.attachmentBase.setTransactional(true);
        this.attachmentBase.startTransaction();
    }

    @Override
    public void tearDown() throws Exception {
        for (AttachmentImpl attachment : this.attachments) {
            try {
                this.attachmentBase.detachFromObject(22, 22, 22, new int[]{attachment.getId()}, (Session)this.session, this.ctx, this.user, null);
            }
            catch (OXException oXException) {}
        }
        super.tearDown();
    }

    public void testFixSchema() throws OXException, SQLException {
        this.createAttachments();
        this.resetSequenceCounter();
        new ClearLeftoverAttachmentsUpdateTask().perform(this.schema, this.existing_ctx_id);
        this.assertNoLeftoversInDatabase();
        this.assertRemovedFiles();
    }

    public void testRunMultipleTimesNonDestructively() throws OXException, SQLException {
        this.createAttachments();
        this.resetSequenceCounter();
        new ClearLeftoverAttachmentsUpdateTask().perform(this.schema, this.existing_ctx_id);
        new ClearLeftoverAttachmentsUpdateTask().perform(this.schema, this.existing_ctx_id);
        new ClearLeftoverAttachmentsUpdateTask().perform(this.schema, this.existing_ctx_id);
        new ClearLeftoverAttachmentsUpdateTask().perform(this.schema, this.existing_ctx_id);
    }

    public void testIgnoreMissingFiles() throws OXException, SQLException {
        this.createAttachments();
        this.resetSequenceCounter();
        this.removeSomeFiles();
        new ClearLeftoverAttachmentsUpdateTask().perform(this.schema, this.existing_ctx_id);
        this.assertNoLeftoversInDatabase();
        this.assertRemovedFiles();
    }

    private void createAttachments() throws OXException {
        AttachmentImpl original = new AttachmentImpl();
        original.setAttachedId(22);
        original.setComment("");
        original.setCreatedBy(this.user_id);
        original.setCreationDate(new Date());
        original.setFolderId(22);
        original.setModuleId(22);
        original.setFileMIMEType("text/plain");
        original.setFilename("blupp.txt");
        this.createCopy(original);
        this.createCopy(original);
        this.createCopy(original);
        this.createCopy(original);
        this.createCopy(original);
        this.createCopy(original);
        this.createCopy(original);
        this.createCopy(original);
        this.createCopy(original);
        this.createCopy(original);
    }

    private void createCopy(AttachmentImpl original) throws OXException {
        AttachmentImpl copy = new AttachmentImpl((AttachmentMetadata)original);
        this.attachmentBase.attachToObject((AttachmentMetadata)copy, (InputStream)new ByteArrayInputStream(new byte[10]), (Session)this.session, this.ctx, this.user, null);
        this.attachments.add(copy);
    }

    private void resetSequenceCounter() throws SQLException, OXException {
        this.exec("UPDATE sequence_attachment SET id = ? WHERE cid = ?", this.attachments.get(3).getId(), this.existing_ctx_id);
    }

    private void removeSomeFiles() throws OXException, OXException {
        FileStorage fs = FileStorage.getInstance((URI)FilestoreStorage.createURI((Context)this.ctx));
        fs.deleteFile(this.attachments.get(5).getFileId());
        fs.deleteFile(this.attachments.get(6).getFileId());
    }

    private void assertNoLeftoversInDatabase() throws SQLException, OXException {
        this.assertNoResults("SELECT 1 FROM prg_attachment JOIN sequence_attachment ON prg_attachment.cid = sequence_attachment.cid WHERE prg_attachment.id > sequence_attachment.id AND prg_attachment.cid = ?", this.existing_ctx_id);
    }

    private void assertRemovedFiles() throws OXException, OXException {
        FileStorage fs = FileStorage.getInstance((URI)FilestoreStorage.createURI((Context)this.ctx));
        for (int i = 4; i < this.attachments.size(); ++i) {
            try {
                fs.getFile(this.attachments.get(i).getFileId());
                ClearLeftoverAttachmentsTest.assertFalse((String)("File of attachment " + i + " was not deleted"), (boolean)true);
                continue;
            }
            catch (OXException x) {
                ClearLeftoverAttachmentsTest.assertTrue((boolean)true);
            }
        }
    }
}

