/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.groupware.attach.actions;

import com.openexchange.database.provider.DBPoolProvider;
import com.openexchange.database.provider.DBProvider;
import com.openexchange.groupware.Init;
import com.openexchange.groupware.attach.AttachmentBase;
import com.openexchange.groupware.attach.AttachmentField;
import com.openexchange.groupware.attach.AttachmentMetadata;
import com.openexchange.groupware.attach.impl.AttachmentBaseImpl;
import com.openexchange.groupware.attach.impl.AttachmentImpl;
import com.openexchange.groupware.attach.impl.AttachmentQueryCatalog;
import com.openexchange.groupware.attach.util.GetSwitch;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.groupware.ldap.User;
import com.openexchange.groupware.ldap.UserStorage;
import com.openexchange.groupware.tx.AbstractActionTest;
import com.openexchange.session.Session;
import com.openexchange.sessiond.impl.SessionObjectWrapper;
import com.openexchange.setuptools.TestConfig;
import com.openexchange.setuptools.TestContextToolkit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public abstract class AbstractAttachmentActionTest
extends AbstractActionTest {
    private User user;
    private Context ctx;
    private final List<AttachmentMetadata> attachments = new ArrayList<AttachmentMetadata>();
    private AttachmentBase attachmentBase = null;
    private AttachmentQueryCatalog queryCatalog = new AttachmentQueryCatalog();
    private DBProvider provider;

    public void setUp() throws Exception {
        Init.startServer();
        this.provider = new DBPoolProvider();
        this.queryCatalog = new AttachmentQueryCatalog();
        TestConfig config = new TestConfig();
        String userName = config.getUser();
        TestContextToolkit tools = new TestContextToolkit();
        String ctxName = config.getContextName();
        this.ctx = null == ctxName || ctxName.trim().length() == 0 ? tools.getDefaultContext() : tools.getContextByName(ctxName);
        this.user = UserStorage.getInstance().getUser(tools.resolveUser(userName, this.ctx), this.ctx);
        this.attachmentBase = new AttachmentBaseImpl(this.provider);
        this.initAttachments();
    }

    public void tearDown() throws Exception {
        Init.stopServer();
    }

    protected User getUser() {
        return this.user;
    }

    protected Context getContext() {
        return this.ctx;
    }

    protected Session getSession() throws Exception {
        return SessionObjectWrapper.createSessionObject((int)this.user.getId(), (int)this.getContext().getContextId(), (String)String.valueOf(System.currentTimeMillis()));
    }

    protected List<AttachmentMetadata> getAttachments() {
        return this.attachments;
    }

    protected AttachmentBase getAttachmentBase() {
        return this.attachmentBase;
    }

    protected AttachmentQueryCatalog getQueryCatalog() {
        return this.queryCatalog;
    }

    protected DBProvider getProvider() {
        return this.provider;
    }

    private void initAttachments() {
        AttachmentImpl m = new AttachmentImpl();
        m.setFileMIMEType("text/plain");
        m.setFilesize(1024L);
        m.setFilename("testfile.txt");
        m.setFileId("00/00/23");
        m.setAttachedId(22);
        m.setModuleId(22);
        m.setRtfFlag(true);
        m.setFolderId(22);
        m.setId(1024);
        m.setCreationDate(new Date());
        this.attachments.add((AttachmentMetadata)m);
        m = new AttachmentImpl();
        m.setFileMIMEType("text/plain");
        m.setFilesize(2048L);
        m.setFilename("testfile2.txt");
        m.setFileId("00/00/24");
        m.setAttachedId(22);
        m.setModuleId(22);
        m.setRtfFlag(true);
        m.setFolderId(22);
        m.setId(2048);
        m.setCreationDate(new Date());
        this.attachments.add((AttachmentMetadata)m);
        m = new AttachmentImpl();
        m.setFileMIMEType("text/plain");
        m.setFilesize(4096L);
        m.setFilename("testfile3.txt");
        m.setFileId("00/00/25");
        m.setAttachedId(22);
        m.setModuleId(22);
        m.setRtfFlag(true);
        m.setFolderId(22);
        m.setId(4096);
        m.setCreationDate(new Date());
        this.attachments.add((AttachmentMetadata)m);
    }

    public static final void assertEquals(AttachmentMetadata m1, AttachmentMetadata m2) {
        GetSwitch get1 = new GetSwitch(m1);
        GetSwitch get2 = new GetSwitch(m2);
        for (AttachmentField field : AttachmentField.VALUES) {
            AbstractAttachmentActionTest.assertEquals((Object)field.doSwitch((AttachmentField.AttachmentSwitch)get1), (Object)field.doSwitch((AttachmentField.AttachmentSwitch)get2));
        }
    }
}

