/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.dav.carddav.tests;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.user.actions.GetRequest;
import com.openexchange.ajax.user.actions.GetResponse;
import com.openexchange.dav.Config;
import com.openexchange.dav.PropertyNames;
import com.openexchange.dav.carddav.CardDAVTest;
import com.openexchange.groupware.container.Contact;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;

public class PrincipalPropertiesTest
extends CardDAVTest {
    public PrincipalPropertiesTest(String name) {
        super(name);
    }

    public void testDiscoverPrincipalProperties() throws Exception {
        DavPropertyNameSet props = new DavPropertyNameSet();
        props.add(PropertyNames.ADDRESSBOOK_HOME_SET);
        props.add(PropertyNames.DIRECTORY_GATEWAY);
        props.add(PropertyNames.DISPLAYNAME);
        props.add(PropertyNames.EMAIL_ADDRESS_SET);
        props.add(PropertyNames.PRINCIPAL_COLLECTION_SET);
        props.add(PropertyNames.PRINCIPAL_URL);
        props.add(PropertyNames.RESOURCE_ID);
        props.add(PropertyNames.SUPPORTED_REPORT_SET);
        PropFindMethod propFind = new PropFindMethod(super.getWebDAVClient().getBaseURI() + "/principals/users/" + Config.getUsername() + "/", 0, props, 0);
        MultiStatusResponse response = PrincipalPropertiesTest.assertSingleResponse(super.getWebDAVClient().doPropFind(propFind));
        GetRequest getRequest = new GetRequest(super.getAJAXClient().getValues().getUserId(), super.getAJAXClient().getValues().getTimeZone());
        GetResponse getResponse = Executor.execute(this.client, getRequest);
        Contact contact = getResponse.getContact();
        String expectedDisplayName = contact.getDisplayName();
        PrincipalPropertiesTest.assertEquals((String)(PropertyNames.DISPLAYNAME + " wrong"), (String)expectedDisplayName, (String)super.extractTextContent(PropertyNames.DISPLAYNAME, response));
        String principalURL = super.extractHref(PropertyNames.PRINCIPAL_URL, response);
        PrincipalPropertiesTest.assertTrue((String)("username not found in href child of " + PropertyNames.PRINCIPAL_URL), (boolean)principalURL.contains(Config.getUsername()));
        String addressbookHome = super.extractHref(PropertyNames.ADDRESSBOOK_HOME_SET, response);
        PrincipalPropertiesTest.assertEquals((String)(PropertyNames.ADDRESSBOOK_HOME_SET + " wrong"), (String)"/carddav/", (String)addressbookHome);
    }
}

