/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.session;

import com.openexchange.ajax.LoginServlet;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXSession;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.session.actions.EmptyHttpAuthRequest;
import com.openexchange.ajax.session.actions.HttpAuthRequest;
import com.openexchange.ajax.session.actions.HttpAuthResponse;
import com.openexchange.ajax.session.actions.StoreRequest;
import com.openexchange.configuration.AJAXConfig;
import com.openexchange.java.Strings;
import java.util.List;
import org.apache.http.cookie.Cookie;
import org.apache.http.impl.cookie.BasicClientCookie;

public class Bug34928Test
extends AbstractAJAXSession {
    private AJAXClient client;
    private String login;
    private String password;

    public Bug34928Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        AJAXConfig.init();
        this.login = AJAXConfig.getProperty(AJAXConfig.Property.LOGIN) + "@" + AJAXConfig.getProperty(AJAXConfig.Property.CONTEXTNAME);
        this.password = AJAXConfig.getProperty(AJAXConfig.Property.PASSWORD);
        this.client = new AJAXClient(new AJAXSession(), true);
        this.client.getSession().getHttpClient().getParams().setBooleanParameter("http.protocol.handle-redirects", false);
    }

    @Override
    protected void tearDown() throws Exception {
        if (null != this.client && !Strings.isEmpty((String)this.client.getSession().getId())) {
            this.client.logout();
        }
        super.tearDown();
    }

    public void testAutoHttpAuthLogin() throws Exception {
        String firstSessionID = this.firstHttpAuthLogin(true);
        this.client.getSession().setId(null);
        HttpAuthResponse httpAuthResponse = this.client.execute(new EmptyHttpAuthRequest());
        String secondSessionID = this.extractSessionID(httpAuthResponse);
        Bug34928Test.assertNotNull((String)"No session ID", (Object)secondSessionID);
        Bug34928Test.assertEquals((String)"Different session IDs", (String)firstSessionID, (String)secondSessionID);
        this.client.getSession().setId(firstSessionID);
    }

    public void testAutoHttpLoginWithWrongSecretCookie() throws Exception {
        String firstSessionID = this.firstHttpAuthLogin(true);
        this.client.getSession().setId(null);
        BasicClientCookie cookie = this.findCookie(LoginServlet.SECRET_PREFIX);
        String correctSecret = cookie.getValue();
        cookie.setValue("wrongsecret");
        HttpAuthResponse httpAuthResponse = this.client.execute(new EmptyHttpAuthRequest());
        Bug34928Test.assertEquals((String)"Wrong response code", (int)401, (int)httpAuthResponse.getStatusCode());
        this.client.getSession().setId(firstSessionID);
        cookie.setValue(correctSecret);
    }

    public void testAutoHttpLoginWithWrongSessionCookie() throws Exception {
        String firstSessionID = this.firstHttpAuthLogin(true);
        this.client.getSession().setId(null);
        BasicClientCookie cookie = this.findCookie(LoginServlet.SESSION_PREFIX);
        String correctSession = cookie.getValue();
        cookie.setValue("wrongsecret");
        HttpAuthResponse httpAuthResponse = this.client.execute(new EmptyHttpAuthRequest());
        Bug34928Test.assertEquals((String)"Wrong response code", (int)401, (int)httpAuthResponse.getStatusCode());
        this.client.getSession().setId(firstSessionID);
        cookie.setValue(correctSession);
    }

    public void testAutoHttpLoginWithoutStore() throws Exception {
        String firstSessionID = this.firstHttpAuthLogin(false);
        this.client.getSession().setId(null);
        HttpAuthResponse httpAuthResponse = this.client.execute(new EmptyHttpAuthRequest());
        Bug34928Test.assertEquals((String)"Wrong response code", (int)401, (int)httpAuthResponse.getStatusCode());
        this.client.getSession().setId(firstSessionID);
    }

    private String firstHttpAuthLogin(boolean store) throws Exception {
        HttpAuthResponse httpAuthResponse = this.client.execute(new HttpAuthRequest(this.login, this.password));
        String sessionID = this.extractSessionID(httpAuthResponse);
        this.client.getSession().setId(sessionID);
        if (store) {
            this.client.execute(new StoreRequest(sessionID));
        }
        return sessionID;
    }

    private BasicClientCookie findCookie(String prefix) {
        List cookies = this.client.getSession().getHttpClient().getCookieStore().getCookies();
        for (int i = 0; i < cookies.size(); ++i) {
            if (!((Cookie)cookies.get(i)).getName().startsWith(prefix)) continue;
            return (BasicClientCookie)cookies.get(i);
        }
        Bug34928Test.fail((String)("No cookie with prefix \"" + prefix + "\" found"));
        return null;
    }

    private String extractSessionID(HttpAuthResponse httpAuthResponse) {
        String location = httpAuthResponse.getLocation();
        Bug34928Test.assertNotNull((String)"Location is missing in response", (Object)location);
        int sessionStart = location.indexOf("session=");
        Bug34928Test.assertTrue((String)"No session ID", (0 <= sessionStart ? 1 : 0) != 0);
        return location.substring(sessionStart + 8, location.indexOf(38, sessionStart + 8));
    }
}

