/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.resource;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.resource.AbstractResourceTest;
import com.openexchange.ajax.resource.actions.ResourceAllRequest;
import com.openexchange.ajax.resource.actions.ResourceAllResponse;
import com.openexchange.ajax.resource.actions.ResourceListRequest;
import com.openexchange.ajax.resource.actions.ResourceListResponse;
import com.openexchange.exception.OXException;
import com.openexchange.resource.Resource;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.xml.sax.SAXException;

public final class ResourceListAJAXTest
extends AbstractResourceTest {
    public ResourceListAJAXTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testList() throws OXException, JSONException, IOException, SAXException {
        int id = -1;
        try {
            Resource resource = new Resource();
            resource.setAvailable(true);
            resource.setMail("my.resource@domain.tdl");
            resource.setSimpleName(ResourceListAJAXTest.class.getName());
            resource.setDisplayName(ResourceListAJAXTest.class.getName());
            resource.setDescription(ResourceListAJAXTest.class.getName());
            id = this.createResource(resource);
            ResourceAllResponse allResponse = Executor.execute(this.getSession(), new ResourceAllRequest(true));
            int[] ids = allResponse.getIDs();
            ResourceListAJAXTest.assertTrue((String)"All request failed", (ids != null ? 1 : 0) != 0);
            ResourceListResponse listResponse = Executor.execute(this.getSession(), new ResourceListRequest(ids, true));
            Resource[] resources = listResponse.getResources();
            ResourceListAJAXTest.assertTrue((String)"List failed", (resources != null && resources.length == ids.length ? 1 : 0) != 0);
            JSONArray arr = (JSONArray)listResponse.getData();
            int size = arr.length();
            for (int i = 0; i < size; ++i) {
                JSONObject res = arr.optJSONObject(i);
                ResourceListAJAXTest.assertNotNull((Object)res);
                ResourceListAJAXTest.assertTrue((boolean)res.has("last_modified_utc"));
            }
        }
        finally {
            this.deleteResource(id);
        }
    }
}

