/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.reminder.actions;

import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.parser.ReminderParser;
import com.openexchange.ajax.reminder.ReminderTools;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.reminder.ReminderObject;
import com.openexchange.tools.servlet.OXJSONExceptionCodes;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class RangeResponse
extends AbstractAJAXResponse {
    private List<ReminderObject> reminders;

    RangeResponse(Response response) {
        super(response);
    }

    public ReminderObject[] getReminder(TimeZone timeZone) throws OXException {
        if (null == this.reminders) {
            ReminderParser parser = new ReminderParser(timeZone);
            JSONArray array = (JSONArray)this.getData();
            this.reminders = new ArrayList<ReminderObject>(array.length());
            for (int i = 0; i < array.length(); ++i) {
                try {
                    JSONObject jremind = array.getJSONObject(i);
                    ReminderObject reminder = new ReminderObject();
                    parser.parse(reminder, jremind);
                    this.reminders.add(reminder);
                    continue;
                }
                catch (JSONException e) {
                    throw OXJSONExceptionCodes.JSON_READ_ERROR.create(new Object[]{array.toString()});
                }
            }
        }
        return this.reminders.toArray(new ReminderObject[this.reminders.size()]);
    }

    public ReminderObject getReminderByTarget(TimeZone timeZone, int targetId) throws OXException {
        return ReminderTools.searchByTarget(this.getReminder(timeZone), targetId);
    }
}

