/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail.filter.parser;

import com.openexchange.ajax.mail.filter.Rule;
import com.openexchange.ajax.mail.filter.action.AbstractAction;
import com.openexchange.ajax.mail.filter.parser.action.ActionParser;
import com.openexchange.ajax.mail.filter.parser.action.ActionParserFactory;
import com.openexchange.ajax.mail.filter.parser.test.TestParser;
import com.openexchange.ajax.mail.filter.parser.test.TestParserFactory;
import com.openexchange.ajax.mail.filter.test.AbstractTest;
import com.openexchange.ajax.parser.DataParser;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MailFilterParser
extends DataParser {
    public void parseMailFilter(Rule rule, JSONObject jsonObj) throws JSONException {
        rule.setId(MailFilterParser.parseString((JSONObject)jsonObj, (String)"id"));
        rule.setName(MailFilterParser.parseString((JSONObject)jsonObj, (String)"rulename"));
        rule.setActive(MailFilterParser.parseBoolean((JSONObject)jsonObj, (String)"active"));
        if (jsonObj.has("flags")) {
            JSONArray flagsArray = jsonObj.getJSONArray("flags");
            MailFilterParser.parseFlags(flagsArray, rule);
        }
        JSONArray actionCommandArray = jsonObj.getJSONArray("actioncmds");
        MailFilterParser.parseActionCommand(actionCommandArray, rule);
        JSONObject testObj = jsonObj.getJSONObject("test");
        MailFilterParser.parseTest(testObj, rule);
    }

    public static void parseFlags(JSONArray jsonFlagArray, Rule rule) throws JSONException {
        String[] flags = new String[jsonFlagArray.length()];
        for (int a = 0; a < jsonFlagArray.length(); ++a) {
            flags[a] = jsonFlagArray.getString(a);
        }
        rule.setFlags(flags);
    }

    public static void parseActionCommand(JSONArray jsonActionArray, Rule rule) throws JSONException {
        AbstractAction[] abstractActionArray = new AbstractAction[jsonActionArray.length()];
        for (int a = 0; a < jsonActionArray.length(); ++a) {
            JSONObject actionCommandObj = jsonActionArray.getJSONObject(a);
            String actionId = actionCommandObj.getString("id");
            ActionParser actionParser = ActionParserFactory.getWriter(actionId);
            abstractActionArray[a] = actionParser.parseAction(actionId, actionCommandObj);
        }
        rule.setActioncmds(abstractActionArray);
    }

    public static void parseTest(JSONObject jsonObj, Rule rule) throws JSONException {
        String testId = jsonObj.getString("id");
        TestParser testParser = TestParserFactory.getParser(testId);
        AbstractTest abstractTest = testParser.parseTest(testId, jsonObj);
        rule.setTest(abstractTest);
    }
}

