/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.mail;

import com.openexchange.ajax.framework.Executor;
import com.openexchange.ajax.mail.AbstractMailTest;
import com.openexchange.ajax.mail.actions.AllRequest;
import com.openexchange.ajax.mail.actions.AllResponse;
import com.openexchange.ajax.mail.actions.NewMailRequest;
import com.openexchange.mail.dataobjects.MailMessage;
import javax.mail.internet.InternetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AllTest
extends AbstractMailTest {
    private static final Logger LOG = LoggerFactory.getLogger(AllTest.class);
    String mailObject_25kb;

    public AllTest(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        this.mailObject_25kb = this.createSelfAddressed25KBMailObject().toString();
    }

    @Override
    public void tearDown() throws Exception {
        this.clearFolder(this.getInboxFolder());
        this.clearFolder(this.getSentFolder());
        this.clearFolder(this.getTrashFolder());
        super.tearDown();
    }

    public void testAll() throws Throwable {
        int numOfMails = 25;
        LOG.info("Sending 25 mails to fill emptied INBOX");
        String eml = "Message-Id: <4A002517.4650.0059.1@foobar.com>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Invitation for launch\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"US-ASCII\"\n" + "Content-Transfer-Encoding: 7bit\n" + "\n" + "Blah blah blah blah blah blah";
        for (int i = 0; i < 25; ++i) {
            this.getClient().execute(new NewMailRequest(this.client.getValues().getInboxFolder(), eml, -1, true));
            LOG.info("Appended " + (i + 1) + ". mail of " + 25);
        }
        AllResponse allR = Executor.execute(this.getSession(), new AllRequest(this.getInboxFolder(), COLUMNS_DEFAULT_LIST, 0, null, true));
        if (allR.hasError()) {
            AllTest.fail((String)allR.getException().toString());
        }
        Object[][] array = allR.getArray();
        AllTest.assertNotNull((String)"Array of all request is null.", (Object)array);
        AllTest.assertEquals((String)"All request shows different number of mails.", (int)25, (int)array.length);
        AllTest.assertEquals((String)"Number of columns differs from request ones.", (int)COLUMNS_DEFAULT_LIST.length, (int)array[0].length);
    }

    public void testAllLimit() throws Throwable {
        int numOfMails = 25;
        LOG.info("Sending 25 mails to fill emptied INBOX");
        String eml = "Message-Id: <4A002517.4650.0059.1@foobar.com>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Invitation for launch\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"US-ASCII\"\n" + "Content-Transfer-Encoding: 7bit\n" + "\n" + "Blah blah blah blah blah blah";
        for (int i = 0; i < 25; ++i) {
            this.getClient().execute(new NewMailRequest(this.client.getValues().getInboxFolder(), eml, -1, true));
            LOG.info("Appended " + (i + 1) + ". mail of " + 25);
        }
        boolean left = false;
        int right = 10;
        AllRequest allRequest = new AllRequest(this.getInboxFolder(), COLUMNS_DEFAULT_LIST, 0, null, true);
        allRequest.setLeftHandLimit(0);
        allRequest.setRightHandLimit(10);
        AllResponse allR = Executor.execute(this.getSession(), allRequest);
        if (allR.hasError()) {
            AllTest.fail((String)allR.getException().toString());
        }
        Object[][] array = allR.getArray();
        AllTest.assertNotNull((String)"Array of all request is null.", (Object)array);
        AllTest.assertEquals((String)"All request shows different number of mails.", (int)10, (int)array.length);
        AllTest.assertEquals((String)"Number of columns differs from request ones.", (int)COLUMNS_DEFAULT_LIST.length, (int)array[0].length);
    }

    public void testAllResponseGetMailObjects() throws Exception {
        MailMessage[] mailMessages;
        int numOfMails = 5;
        LOG.info("Sending 5 mails to fill emptied INBOX");
        String eml = "Message-Id: <4A002517.4650.0059.1@foobar.com>\nDate: Tue, 05 May 2009 11:37:58 -0500\nFrom: " + this.getSendAddress() + "\n" + "To: " + this.getSendAddress() + "\n" + "Subject: Invitation for launch\n" + "Mime-Version: 1.0\n" + "Content-Type: text/plain; charset=\"US-ASCII\"\n" + "Content-Transfer-Encoding: 7bit\n" + "\n" + "Blah blah blah blah blah blah";
        for (int i = 0; i < 5; ++i) {
            this.getClient().execute(new NewMailRequest(this.client.getValues().getInboxFolder(), eml, -1, true));
            LOG.info("Appended " + (i + 1) + ". mail of " + 5);
        }
        AllResponse allR = Executor.execute(this.getSession(), new AllRequest(this.getInboxFolder(), COLUMNS_DEFAULT_LIST, 0, null, true));
        if (allR.hasError()) {
            AllTest.fail((String)allR.getException().toString());
        }
        for (MailMessage mailMessage : mailMessages = allR.getMailMessages(COLUMNS_DEFAULT_LIST)) {
            AllTest.assertEquals((String)"From is not equal", (Object)new InternetAddress(this.getSendAddress()), (Object)mailMessage.getFrom()[0]);
            AllTest.assertEquals((String)"Subject is not equal", (String)"Invitation for launch", (String)mailMessage.getSubject());
            AllTest.assertEquals((String)"Folder is not equal", (String)this.getInboxFolder(), (String)mailMessage.getFolder());
            AllTest.assertEquals((String)"hasAttachment is not equal", (boolean)false, (boolean)mailMessage.hasAttachment());
            AllTest.assertEquals((String)"To is not equal", (Object)new InternetAddress(this.getSendAddress()), (Object)mailMessage.getTo()[0]);
        }
    }
}

