/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.importexport;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.PostMethodWebRequest;
import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.openexchange.ajax.importexport.AbstractImportExportServletTest;
import com.openexchange.importexport.formats.Format;
import com.openexchange.test.OXTestToolkit;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class VCardImportExportServletTest
extends AbstractImportExportServletTest {
    public VCardImportExportServletTest(String name) {
        super(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testVCardRoundtrip() throws Exception {
        String insertedCSV = this.IMPORT_VCARD;
        Format format = Format.VCARD;
        int folderId = this.createFolder("vcard-contact-roundtrip-" + System.currentTimeMillis(), 3);
        try {
            InputStream is = new ByteArrayInputStream(insertedCSV.getBytes());
            WebConversation webconv = this.getWebConversation();
            PostMethodWebRequest req = new PostMethodWebRequest(this.getUrl(this.IMPORT_SERVLET, folderId, format), true);
            req.selectFile("file", "contact.vcf", is, format.getMimeType());
            WebResponse webRes = webconv.getResource((WebRequest)req);
            VCardImportExportServletTest.extractFromCallback(webRes.getText());
            webconv = this.getWebConversation();
            req = new GetMethodWebRequest(this.getUrl(this.EXPORT_SERVLET, folderId, format));
            webRes = webconv.sendRequest((WebRequest)req);
            is = webRes.getInputStream();
            String resultingVCard = OXTestToolkit.readStreamAsString(is);
            for (String test : this.IMPORT_VCARD_AWAITED_ELEMENTS) {
                VCardImportExportServletTest.assertTrue((String)("VCard contains " + test + "?"), (boolean)resultingVCard.contains(test));
            }
        }
        finally {
            this.removeFolder(folderId);
        }
    }
}

