/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder.actions;

import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.AbstractFolderRequest;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.CommonDeleteParser;
import com.openexchange.ajax.framework.CommonDeleteResponse;
import com.openexchange.groupware.container.FolderObject;
import java.util.Date;
import java.util.List;
import org.json.JSONArray;

public class DeleteRequest
extends AbstractFolderRequest<CommonDeleteResponse> {
    private final String[] folderIds;
    private final Date lastModified;
    private final boolean failOnError;
    private Boolean hardDelete;
    private Boolean failOnErrorParam;

    public DeleteRequest(API api, String[] folderIds, Date lastModified, boolean failOnError) {
        super(api);
        this.folderIds = folderIds;
        this.lastModified = lastModified;
        this.failOnError = failOnError;
    }

    public DeleteRequest(API api, String[] folderIds, Date lastModified) {
        this(api, folderIds, lastModified, true);
    }

    public DeleteRequest(API api, String folderId, Date lastModified) {
        this(api, new String[]{folderId}, lastModified);
    }

    public DeleteRequest(API api, int[] folderIds, Date lastModified) {
        this(api, DeleteRequest.i2s(folderIds), lastModified);
    }

    public DeleteRequest(API api, int folderId, Date lastModified) {
        this(api, new int[]{folderId}, lastModified);
    }

    public DeleteRequest(API api, boolean failOnError, FolderObject ... folder) {
        super(api);
        this.folderIds = new String[folder.length];
        Date maxLastModified = new Date(Long.MIN_VALUE);
        for (int i = 0; i < folder.length; ++i) {
            this.folderIds[i] = folder[i].containsObjectID() ? Integer.valueOf(folder[i].getObjectID()).toString() : folder[i].getFullName();
            if (!maxLastModified.before(folder[i].getLastModified())) continue;
            maxLastModified = folder[i].getLastModified();
        }
        this.lastModified = maxLastModified;
        this.failOnError = failOnError;
    }

    public DeleteRequest(API api, FolderObject ... folder) {
        this(api, true, folder);
    }

    public DeleteRequest setHardDelete(Boolean hardDelete) {
        this.hardDelete = hardDelete;
        return this;
    }

    public Boolean isHardDelete() {
        return this.hardDelete;
    }

    public DeleteRequest setFailOnErrorParam(Boolean failOnError) {
        this.failOnErrorParam = failOnError;
        return this;
    }

    public Boolean isFailOnErrorParam() {
        return this.failOnErrorParam;
    }

    @Override
    public Object getBody() {
        JSONArray array = new JSONArray();
        for (String folderId : this.folderIds) {
            array.put((Object)folderId);
        }
        return array;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    protected void addParameters(List<AJAXRequest.Parameter> params) {
        params.add(new AJAXRequest.Parameter("action", "delete"));
        params.add(new AJAXRequest.Parameter("timestamp", this.lastModified.getTime()));
        if (null != this.hardDelete) {
            params.add(new AJAXRequest.Parameter("hardDelete", String.valueOf(this.hardDelete)));
        }
        if (null != this.failOnErrorParam) {
            params.add(new AJAXRequest.Parameter("failOnError", String.valueOf(this.failOnErrorParam)));
        }
    }

    public CommonDeleteParser getParser() {
        return new CommonDeleteParser(this.failOnError);
    }
}

