/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.folder;

import com.openexchange.ajax.folder.FolderTools;
import com.openexchange.ajax.folder.actions.API;
import com.openexchange.ajax.folder.actions.EnumAPI;
import com.openexchange.ajax.folder.actions.GetRequest;
import com.openexchange.ajax.folder.actions.GetResponse;
import com.openexchange.ajax.folder.actions.ListRequest;
import com.openexchange.ajax.folder.actions.ListResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.mail.utils.MailFolderUtility;
import java.util.Iterator;
import java.util.List;

public class GetSortedMailFolderTest
extends AbstractAJAXSession {
    private static final int[] COLUMNS = new int[]{1, 300, 305, 306};
    private AJAXClient client;

    public GetSortedMailFolderTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
    }

    public void testGetSortedMailFolder() throws Throwable {
        ListRequest request = new ListRequest((API)EnumAPI.OX_OLD, String.valueOf(1));
        ListResponse response = this.client.execute(request);
        Iterator<FolderObject> iter = response.getFolder();
        FolderObject rootMailFolder = null;
        String primaryMailFolder = MailFolderUtility.prepareFullname((int)0, (String)"default");
        while (iter.hasNext()) {
            FolderObject fo = iter.next();
            if (!fo.containsFullName() || !primaryMailFolder.equals(fo.getFullName())) continue;
            rootMailFolder = fo;
            break;
        }
        GetSortedMailFolderTest.assertNotNull((String)"Default email folder not found.", rootMailFolder);
        GetSortedMailFolderTest.assertTrue((String)"Default email folder has no subfolders.", (boolean)rootMailFolder.hasSubfolders());
        request = new ListRequest((API)EnumAPI.OX_OLD, rootMailFolder.getFullName());
        response = this.client.execute(request);
        List<FolderObject> l = FolderTools.convert(response.getFolder());
        GetSortedMailFolderTest.assertTrue((String)"No folders below virtual primary mail account folder found.", (l.size() > 0 ? 1 : 0) != 0);
        int pos = 0;
        FolderObject inboxFolder = l.get(pos++);
        GetSortedMailFolderTest.assertTrue((String)"Default inbox folder not found.", (boolean)inboxFolder.getFullName().endsWith("INBOX"));
        GetRequest request2 = new GetRequest((API)EnumAPI.OX_OLD, inboxFolder.getFullName(), COLUMNS);
        GetResponse response2 = this.client.execute(request2);
        GetSortedMailFolderTest.assertFalse((String)"Getting folder information failed.", (boolean)response2.hasError());
        if (l.size() == 1) {
            request = new ListRequest((API)EnumAPI.OX_OLD, inboxFolder.getFullName());
            response = this.client.execute(request);
            l = FolderTools.convert(response.getFolder());
            pos = 0;
        }
        FolderObject draftsFolder = l.get(pos++);
        GetSortedMailFolderTest.assertTrue((String)"Default drafts folder not found.", (boolean)draftsFolder.isDefaultFolder());
        GetRequest request22 = new GetRequest((API)EnumAPI.OX_OLD, draftsFolder.getFullName(), COLUMNS);
        GetResponse response22 = this.client.execute(request22);
        GetSortedMailFolderTest.assertFalse((String)"Getting folder information failed.", (boolean)response22.hasError());
        FolderObject sentFolder = l.get(pos++);
        GetSortedMailFolderTest.assertTrue((String)"Default sent folder not found", (boolean)sentFolder.isDefaultFolder());
        request22 = new GetRequest((API)EnumAPI.OX_OLD, sentFolder.getFullName(), COLUMNS);
        response22 = this.client.execute(request22);
        GetSortedMailFolderTest.assertFalse((String)"Getting folder information failed.", (boolean)response22.hasError());
        FolderObject spamFolder = l.get(pos++);
        GetSortedMailFolderTest.assertTrue((String)"Default spam folder not found", (boolean)spamFolder.isDefaultFolder());
        request22 = new GetRequest((API)EnumAPI.OX_OLD, spamFolder.getFullName(), COLUMNS);
        response22 = this.client.execute(request22);
        GetSortedMailFolderTest.assertFalse((String)"Getting folder information failed.", (boolean)response22.hasError());
        FolderObject trashFolder = l.get(pos++);
        GetSortedMailFolderTest.assertTrue((String)"Default trash folder not found", (boolean)trashFolder.isDefaultFolder());
        request22 = new GetRequest((API)EnumAPI.OX_OLD, trashFolder.getFullName(), COLUMNS);
        response22 = this.client.execute(request22);
        GetSortedMailFolderTest.assertFalse((String)"Getting folder information failed.", (boolean)response22.hasError());
    }
}

