/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact.action;

import com.openexchange.ajax.FinalContactConstants;
import com.openexchange.ajax.contact.action.AbstractContactRequest;
import com.openexchange.ajax.contact.action.DoAssociationResponse;
import com.openexchange.ajax.container.Response;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXParser;
import com.openexchange.ajax.framework.Params;
import com.openexchange.groupware.container.Contact;
import org.json.JSONArray;
import org.json.JSONException;

public class DoAssociationRequest
extends AbstractContactRequest<DoAssociationResponse> {
    private final Contact contributor;
    private final Contact aggregator;

    public DoAssociationRequest(Contact contributor, Contact aggregator) {
        this.contributor = contributor;
        this.aggregator = aggregator;
    }

    @Override
    public Object getBody() throws JSONException {
        JSONArray arr = new JSONArray();
        arr.put((Object)this.convert(this.contributor));
        arr.put((Object)this.convert(this.aggregator));
        return arr;
    }

    @Override
    public AJAXRequest.Method getMethod() {
        return AJAXRequest.Method.PUT;
    }

    @Override
    public AJAXRequest.Parameter[] getParameters() {
        Params params = new Params("action", FinalContactConstants.ACTION_ASSOCIATE.getName());
        if (this.contributor.containsUserField20()) {
            params.add(FinalContactConstants.PARAMETER_UUID1.getName(), this.contributor.getUserField20());
        } else {
            params.add(FinalContactConstants.PARAMETER_FOLDER_ID1.getName(), String.valueOf(this.contributor.getParentFolderID()), FinalContactConstants.PARAMETER_CONTACT_ID1.getName(), String.valueOf(this.contributor.getObjectID()));
        }
        if (this.aggregator.containsUserField20()) {
            params.add(FinalContactConstants.PARAMETER_UUID2.getName(), this.aggregator.getUserField20());
        } else {
            params.add(FinalContactConstants.PARAMETER_FOLDER_ID2.getName(), String.valueOf(this.aggregator.getParentFolderID()), FinalContactConstants.PARAMETER_CONTACT_ID2.getName(), String.valueOf(this.aggregator.getObjectID()));
        }
        return params.toArray();
    }

    @Override
    public AbstractAJAXParser<? extends DoAssociationResponse> getParser() {
        return new AbstractAJAXParser<DoAssociationResponse>(true){

            @Override
            public DoAssociationResponse createResponse(Response response) {
                return new DoAssociationResponse(response);
            }
        };
    }
}

