/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.contact;

import com.openexchange.ajax.contact.action.ContactUpdatesResponse;
import com.openexchange.ajax.contact.action.DeleteRequest;
import com.openexchange.ajax.contact.action.GetRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.contact.action.InsertRequest;
import com.openexchange.ajax.contact.action.InsertResponse;
import com.openexchange.ajax.contact.action.UpdatesRequest;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.ajax.framework.AJAXRequest;
import com.openexchange.ajax.framework.AbstractAJAXResponse;
import com.openexchange.ajax.framework.AbstractAJAXSession;
import com.openexchange.ajax.framework.AbstractColumnsResponse;
import com.openexchange.groupware.container.Contact;
import com.openexchange.groupware.container.DataObject;
import com.openexchange.groupware.search.Order;
import com.openexchange.java.Autoboxing;
import java.util.Date;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONObject;

public class Bug13960Test
extends AbstractAJAXSession {
    private static final int[] COLUMNS = new int[]{1, 605, 599, 596};
    private AJAXClient client;
    private TimeZone timeZone;
    private Contact contact;

    public Bug13960Test(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.client = this.getClient();
        this.timeZone = this.client.getValues().getTimeZone();
        this.contact = new Contact();
        this.contact.setParentFolderID(this.client.getValues().getPrivateContactFolder());
        InsertResponse response = this.client.execute(new InsertRequest(this.contact));
        response.fillObject((DataObject)this.contact);
    }

    @Override
    protected void tearDown() throws Exception {
        this.client.execute(new DeleteRequest(this.contact));
        super.tearDown();
    }

    public void testJSONValues() throws Throwable {
        int row;
        AJAXRequest<GetResponse> request = new GetRequest(this.contact, this.timeZone);
        AbstractAJAXResponse response = this.client.execute(request);
        JSONObject json = (JSONObject)response.getData();
        Bug13960Test.assertFalse((String)"'Default address' should not be contained if not set.", (boolean)json.has("default_address"));
        Bug13960Test.assertFalse((String)"'File as should' not be contained if not set.", (boolean)json.has("file_as"));
        Bug13960Test.assertTrue((String)"'Number of images' should be contained always.", (boolean)json.has("number_of_images"));
        Bug13960Test.assertEquals((String)"'Number of images' should be zero.", (int)0, (int)json.getInt("number_of_images"));
        request = new UpdatesRequest(this.contact.getParentFolderID(), COLUMNS, 0, Order.ASCENDING, new Date(this.contact.getLastModified().getTime() - 1L));
        response = (ContactUpdatesResponse)((Object)this.client.execute(request));
        for (row = 0; row < ((AbstractColumnsResponse)response).size() && !((AbstractColumnsResponse)response).getValue(row, 1).equals(Autoboxing.I((int)this.contact.getObjectID())); ++row) {
        }
        JSONArray array = ((JSONArray)response.getData()).getJSONArray(row);
        int defaultAddressPos = ((AbstractColumnsResponse)response).getColumnPos(605);
        Bug13960Test.assertEquals((String)"Default address should not be contained if not set.", (Object)JSONObject.NULL, (Object)array.get(defaultAddressPos));
        int fileAsPos = ((AbstractColumnsResponse)response).getColumnPos(599);
        Bug13960Test.assertEquals((Object)JSONObject.NULL, (Object)array.get(fileAsPos));
        int numberOfImagesPos = ((AbstractColumnsResponse)response).getColumnPos(596);
        Bug13960Test.assertEquals((String)"'Number of images' should be zero.", (int)0, (int)array.getInt(numberOfImagesPos));
    }
}

