/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.ajax.appointment.recurrence;

import com.openexchange.ajax.appointment.recurrence.ManagedAppointmentTest;
import com.openexchange.ajax.contact.action.GetContactForUserRequest;
import com.openexchange.ajax.contact.action.GetResponse;
import com.openexchange.ajax.framework.AJAXClient;
import com.openexchange.groupware.container.Appointment;
import com.openexchange.groupware.container.ExternalUserParticipant;
import com.openexchange.groupware.container.Participant;
import com.openexchange.groupware.container.UserParticipant;
import java.util.TimeZone;

public class AppointmentParticipantsShouldBecomeUsersIfPossible
extends ManagedAppointmentTest {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public AppointmentParticipantsShouldBecomeUsersIfPossible(String name) {
        super(name);
    }

    public void testExternalParticipantIsRemovedIfAddressMatchesCreator() {
    }

    public void testExternalParticipantStaysIfTwoInternalUsersHaveTheSameSecondaryAddress() {
    }

    public void testExternalParticipantBecomesUserParticipantIfAddressMatches() throws Exception {
        Participant[] participants;
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int user2id = client2.getValues().getUserId();
        GetResponse response = client2.execute(new GetContactForUserRequest(user2id, true, TimeZone.getDefault()));
        String user2email = response.getContact().getEmail1();
        Appointment appointment = this.generateDailyAppointment();
        appointment.addParticipant((Participant)new ExternalUserParticipant(user2email));
        appointment.addParticipant((Participant)new UserParticipant(user2id));
        this.calendarManager.insert(appointment);
        Appointment actual = this.calendarManager.get(appointment);
        boolean foundAsExternal = false;
        boolean foundAsInternal = false;
        for (Participant participant : participants = actual.getParticipants()) {
            if (participant.getType() == 5 && participant.getEmailAddress().equals(user2email)) {
                foundAsExternal = true;
            }
            if (participant.getType() != 1 || participant.getIdentifier() != user2id) continue;
            foundAsInternal = true;
        }
        AppointmentParticipantsShouldBecomeUsersIfPossible.assertFalse((String)"Should not find user listed as external participant", (boolean)foundAsExternal);
        AppointmentParticipantsShouldBecomeUsersIfPossible.assertTrue((String)"Should find user listed as internal participant", (boolean)foundAsInternal);
    }

    public void testExternalParticipantIsRemovedIfAddressMatchesUserParticipant() throws Exception {
        Participant[] participants;
        GetResponse response = this.getClient().execute(new GetContactForUserRequest(this.userId, true, TimeZone.getDefault()));
        String user1email = response.getContact().getEmail1();
        Appointment appointment = this.generateDailyAppointment();
        appointment.addParticipant((Participant)new ExternalUserParticipant(user1email));
        this.calendarManager.insert(appointment);
        Appointment actual = this.calendarManager.get(appointment);
        boolean foundAsExternal = false;
        int foundAsInternal = 0;
        for (Participant participant : participants = actual.getParticipants()) {
            if (participant.getType() == 5 && participant.getEmailAddress().equals(user1email)) {
                foundAsExternal = true;
            }
            if (participant.getType() != 1 || participant.getIdentifier() != this.userId) continue;
            ++foundAsInternal;
        }
        AppointmentParticipantsShouldBecomeUsersIfPossible.assertFalse((String)"Should not find creator listed as external participant", (boolean)foundAsExternal);
        AppointmentParticipantsShouldBecomeUsersIfPossible.assertEquals((String)"Should find creator listed as internal participant once and only once", (int)1, (int)foundAsInternal);
    }

    public void testExternalParticipantBecomesUserParticipantIfAddressMatchesAfterUpdateToo() throws Exception {
        Participant[] participants;
        AJAXClient client2 = new AJAXClient(AJAXClient.User.User2);
        int user2id = client2.getValues().getUserId();
        GetResponse response = client2.execute(new GetContactForUserRequest(user2id, true, TimeZone.getDefault()));
        String user2email = response.getContact().getEmail1();
        Appointment appointment = this.generateDailyAppointment();
        Appointment result = this.calendarManager.insert(appointment);
        Appointment update = new Appointment();
        update.setLastModified(result.getLastModified());
        update.setObjectID(result.getObjectID());
        update.setParentFolderID(result.getParentFolderID());
        update.addParticipant((Participant)new ExternalUserParticipant(user2email));
        update.addParticipant((Participant)new UserParticipant(user2id));
        this.calendarManager.update(update);
        Appointment actual = this.calendarManager.get(appointment);
        boolean foundAsExternal = false;
        boolean foundAsInternal = false;
        for (Participant participant : participants = actual.getParticipants()) {
            if (participant.getType() == 5 && participant.getEmailAddress().equals(user2email)) {
                foundAsExternal = true;
            }
            if (participant.getType() != 1 || participant.getIdentifier() != user2id) continue;
            foundAsInternal = true;
        }
        AppointmentParticipantsShouldBecomeUsersIfPossible.assertFalse((String)"Should not find user listed as external participant", (boolean)foundAsExternal);
        AppointmentParticipantsShouldBecomeUsersIfPossible.assertTrue((String)"Should find user listed as internal participant", (boolean)foundAsInternal);
    }
}

