/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.webdav.action;

import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.tools.io.SizeAwareInputStream;
import com.openexchange.webdav.action.AbstractAction;
import com.openexchange.webdav.action.WebdavRequest;
import com.openexchange.webdav.action.WebdavResponse;
import com.openexchange.webdav.protocol.WebdavProtocolException;
import com.openexchange.webdav.protocol.WebdavResource;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebdavPutAction
extends AbstractAction {
    private static final Logger LOG = LoggerFactory.getLogger(WebdavPutAction.class);

    @Override
    public void perform(WebdavRequest req, WebdavResponse res) throws WebdavProtocolException {
        String contentType;
        WebdavResource resource = req.getResource();
        if (null != req.getHeader("content-length")) {
            resource.setLength(new Long(req.getHeader("content-length")));
        }
        if ("application/octet-stream".equals(contentType = MimeType2ExtMap.getContentType(resource.getUrl().name()))) {
            contentType = req.getHeader("content-type");
        }
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        resource.setContentType(contentType);
        SizeExceededInputStream in = null;
        try {
            InputStream data = null;
            if (-1L != this.getMaxSize()) {
                in = new SizeExceededInputStream(req.getBody(), this.getMaxSize());
                data = in;
            } else {
                data = req.getBody();
            }
            resource.putBodyAndGuessLength(data);
            if (resource.exists() && !resource.isLockNull()) {
                resource.save();
            } else {
                resource.create();
            }
            res.setStatus(201);
        }
        catch (IOException e) {
            LOG.debug("Client Gone?", (Throwable)e);
        }
        catch (WebdavProtocolException x) {
            if (in != null && in.hasExceeded()) {
                throw WebdavProtocolException.Code.GENERAL_ERROR.create(req.getUrl(), 413);
            }
            throw x;
        }
    }

    public long getMaxSize() {
        return -1L;
    }

    public static final class SizeExceededInputStream
    extends SizeAwareInputStream {
        private boolean exceeded;
        private final long maxSize;

        public SizeExceededInputStream(InputStream delegate, long maxSize) {
            super(delegate);
            this.maxSize = maxSize;
        }

        @Override
        public void size(long size) throws IOException {
            if (size > this.maxSize) {
                this.exceeded = true;
                throw new IOException("Exceeded max upload size of " + this.maxSize);
            }
        }

        public boolean hasExceeded() {
            return this.exceeded;
        }
    }
}

