/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.versit.valuedefinitions.rfc2445;

import com.openexchange.tools.versit.Property;
import com.openexchange.tools.versit.StringScanner;
import com.openexchange.tools.versit.ValueDefinition;
import com.openexchange.tools.versit.VersitException;
import java.io.IOException;
import java.text.DecimalFormat;

public class UTCOffsetValueDefinition
extends ValueDefinition {
    public static final ValueDefinition Default = new UTCOffsetValueDefinition();
    private static final DecimalFormat Format = new DecimalFormat("00");

    @Override
    public Object createValue(StringScanner s, Property property) throws IOException {
        int sign = 1;
        switch (s.peek) {
            case 45: {
                sign = -1;
            }
            case 43: {
                break;
            }
            default: {
                throw new VersitException(s, "UTC offset expected");
            }
        }
        s.read();
        int offset = s.parseNumber(2) * 3600000 + s.parseNumber(2) * 60000;
        if (s.peek >= 48 && s.peek <= 57) {
            offset += s.parseNumber(2) * 1000;
        }
        return sign * offset;
    }

    @Override
    public String writeValue(Object value) {
        int offset = (Integer)value;
        StringBuilder sb = new StringBuilder();
        sb.append(offset >= 0 ? (char)'+' : '-').append(Format.format(offset / 3600000)).append(Format.format(offset / 60000 % 60));
        if (offset % 60000 != 0) {
            sb.append(Format.format(offset / 1000 % 60));
        }
        return sb.toString();
    }
}

