/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.oxfolder.memory;

import com.javacodegeeks.concurrent.ConcurrentLinkedHashMap;
import com.javacodegeeks.concurrent.EvictionPolicy;
import com.openexchange.cache.impl.FolderCacheManager;
import com.openexchange.database.DatabaseService;
import com.openexchange.exception.OXException;
import com.openexchange.groupware.container.FolderObject;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.server.services.ServerServiceRegistry;
import com.openexchange.threadpool.AbstractTask;
import com.openexchange.threadpool.Task;
import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.oxfolder.OXFolderBatchLoader;
import com.openexchange.tools.oxfolder.OXFolderExceptionCode;
import com.openexchange.tools.oxfolder.memory.AgePolicy;
import com.openexchange.tools.oxfolder.memory.Condition;
import com.openexchange.tools.oxfolder.memory.ConditionTree;
import com.openexchange.tools.oxfolder.memory.Permission;
import com.openexchange.tools.sql.DBUtils;
import gnu.trove.EmptyTIntSet;
import gnu.trove.TIntCollection;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.procedure.TIntProcedure;
import gnu.trove.set.TIntSet;
import gnu.trove.set.hash.TIntHashSet;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConditionTreeMap {
    private static final Logger LOG = LoggerFactory.getLogger(ConditionTreeMap.class);
    private static final EmptyTIntSet EMPTY_SET = EmptyTIntSet.getInstance();
    final ConcurrentMap<Integer, Future<ConditionTree>> entity2tree;
    private final int contextId;
    private final int time2live;

    public ConditionTreeMap(int contextId, int time2live) {
        this.entity2tree = new ConcurrentLinkedHashMap(ConditionTreeMap.countEntities(contextId), 0.75f, 16, Integer.MAX_VALUE, (EvictionPolicy)new AgePolicy(time2live));
        this.contextId = contextId;
        this.time2live = time2live;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int countEntities(int contextId) {
        int n;
        DatabaseService service = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = service.getReadOnly(contextId);
            stmt = connection.prepareStatement("SELECT COUNT(id) FROM user WHERE cid=?");
            stmt.setInt(1, contextId);
            rs = stmt.executeQuery();
            int count = rs.next() ? rs.getInt(1) : 0;
            DBUtils.closeSQLStuff(rs, stmt);
            stmt = connection.prepareStatement("SELECT COUNT(id) FROM groups WHERE cid=?");
            stmt.setInt(1, contextId);
            rs = stmt.executeQuery();
            n = count += rs.next() ? rs.getInt(1) : 0;
        }
        catch (Exception e) {
            int n2;
            try {
                n2 = 1024;
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (null != connection) {
                    service.backReadOnly(contextId, connection);
                }
                throw throwable;
            }
            DBUtils.closeSQLStuff(rs, stmt);
            if (null != connection) {
                service.backReadOnly(contextId, connection);
            }
            return n2;
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (null != connection) {
            service.backReadOnly(contextId, connection);
        }
        return n;
    }

    public void trim() {
        this.trim(System.currentTimeMillis() - (long)this.time2live);
    }

    public void trim(long stamp) {
        Iterator it = this.entity2tree.values().iterator();
        while (it.hasNext()) {
            Future f = (Future)it.next();
            try {
                ConditionTree conditionTree = this.getFrom(f);
                if (null != conditionTree && !conditionTree.isElapsed(stamp)) continue;
                it.remove();
            }
            catch (Exception e) {
                it.remove();
            }
        }
    }

    public void init() throws OXException {
        this.entity2tree.clear();
        DatabaseService service = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = service.getReadOnly(this.contextId);
            stmt = connection.prepareStatement("SELECT ot.fuid, op.permission_id, op.admin_flag, op.fp, ot.module, ot.type, ot.created_from, ot.changing_date, ot.parent FROM oxfolder_tree AS ot JOIN oxfolder_permissions AS op ON ot.cid = op.cid AND ot.fuid = op.fuid WHERE ot.cid = ?");
            stmt.setInt(1, this.contextId);
            rs = stmt.executeQuery();
            while (rs.next()) {
                Permission p = new Permission();
                int pos = 1;
                p.fuid = rs.getInt(pos++);
                p.entity = rs.getInt(pos++);
                p.admin = rs.getInt(pos++) > 0;
                p.readFolder = rs.getInt(pos++) >= 2;
                p.module = rs.getInt(pos++);
                p.type = rs.getInt(pos++);
                p.creator = rs.getInt(pos++);
                p.lastModified = rs.getLong(pos++);
                p.parent = rs.getInt(pos);
                this.insert(p);
            }
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (null != connection) {
                    service.backReadOnly(this.contextId, connection);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (null != connection) {
            service.backReadOnly(this.contextId, connection);
        }
    }

    public ConditionTree newTreeForEntity(int entity) throws OXException {
        ConditionTree conditionTree;
        DatabaseService service = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection connection = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            connection = service.getReadOnly(this.contextId);
            stmt = connection.prepareStatement("SELECT ot.fuid, op.permission_id, op.admin_flag, op.fp, ot.module, ot.type, ot.created_from, ot.changing_date, ot.parent FROM oxfolder_tree AS ot JOIN oxfolder_permissions AS op ON ot.cid = op.cid AND ot.fuid = op.fuid WHERE ot.cid=? AND op.permission_id=?");
            stmt.setInt(1, this.contextId);
            stmt.setInt(2, entity);
            rs = stmt.executeQuery();
            ConditionTree tree = new ConditionTree();
            while (rs.next()) {
                Permission p = new Permission();
                int pos = 1;
                p.fuid = rs.getInt(pos++);
                p.entity = rs.getInt(pos++);
                p.admin = rs.getInt(pos++) > 0;
                p.readFolder = rs.getInt(pos++) >= 2;
                p.module = rs.getInt(pos++);
                p.type = rs.getInt(pos++);
                p.creator = rs.getInt(pos++);
                p.lastModified = rs.getLong(pos++);
                p.parent = rs.getInt(pos);
                tree.insert(p);
            }
            conditionTree = tree;
        }
        catch (SQLException e) {
            try {
                throw OXFolderExceptionCode.SQL_ERROR.create(e, e.getMessage());
            }
            catch (Throwable throwable) {
                DBUtils.closeSQLStuff(rs, stmt);
                if (null != connection) {
                    service.backReadOnly(this.contextId, connection);
                }
                throw throwable;
            }
        }
        DBUtils.closeSQLStuff(rs, stmt);
        if (null != connection) {
            service.backReadOnly(this.contextId, connection);
        }
        return conditionTree;
    }

    public void clear() {
        this.entity2tree.clear();
    }

    public void removeFor(int entity) {
        this.entity2tree.remove(entity);
    }

    public void insert(Permission permission) throws OXException {
        ConditionTree conditionTree;
        FutureTask<ConditionTree> ft;
        Integer entity = permission.entity;
        FutureTask<ConditionTree> f = (FutureTask<ConditionTree>)this.entity2tree.get(entity);
        if (null == f && null == (f = (Future)this.entity2tree.putIfAbsent(entity, ft = new FutureTask<ConditionTree>(new NewTreeCallable())))) {
            ft.run();
            f = ft;
        }
        if (null != (conditionTree = this.getFrom((Future<ConditionTree>)f))) {
            conditionTree.insert(permission);
        }
    }

    public TIntSet getVisibleForUser(int userId, int[] groups, int[] accessibleModules, Condition ... conditions) throws OXException {
        Future<ConditionTree> f = (FutureTask<ConditionTree>)this.entity2tree.get(userId);
        if (null == f) {
            FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(userId, LOG));
            f = this.entity2tree.putIfAbsent(userId, ft);
            if (null == f) {
                ft.run();
                f = ft;
            }
        }
        CombinedCondition condition = new CombinedCondition((Condition)new ModulesCondition(accessibleModules), conditions);
        TIntSet set = this.getFrom(f).getVisibleFolderIds(condition);
        if (null == set) {
            set = new TIntHashSet();
        }
        if (null != groups) {
            for (int group : groups) {
                ConditionTree conditionTree;
                f = (Future)this.entity2tree.get(group);
                if (null == f) {
                    FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(group, LOG));
                    f = this.entity2tree.putIfAbsent(group, ft);
                    if (null == f) {
                        ft.run();
                        f = ft;
                    }
                }
                if (null == (conditionTree = this.getFrom(f))) continue;
                set.addAll((TIntCollection)conditionTree.getVisibleFolderIds(condition));
            }
        }
        return set;
    }

    public TIntSet getVisibleForUser(int userId, int[] groups, int[] accessibleModules, Collection<Condition> conditions) throws OXException {
        Future<ConditionTree> f = (FutureTask<ConditionTree>)this.entity2tree.get(userId);
        if (null == f) {
            FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(userId, LOG));
            f = this.entity2tree.putIfAbsent(userId, ft);
            if (null == f) {
                ft.run();
                f = ft;
            }
        }
        CombinedCondition condition = new CombinedCondition(new ModulesCondition(accessibleModules), conditions);
        TIntSet set = this.getFrom(f).getVisibleFolderIds(condition);
        if (null == set) {
            set = new TIntHashSet();
        }
        if (null != groups) {
            for (int group : groups) {
                ConditionTree conditionTree;
                f = (Future)this.entity2tree.get(group);
                if (null == f) {
                    FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(group, LOG));
                    f = this.entity2tree.putIfAbsent(group, ft);
                    if (null == f) {
                        ft.run();
                        f = ft;
                    }
                }
                if (null == (conditionTree = this.getFrom(f))) continue;
                set.addAll((TIntCollection)conditionTree.getVisibleFolderIds(condition));
            }
        }
        return set;
    }

    public boolean isVisibleFolder(int userId, int[] groups, int[] accessibleModules, int folderId) throws OXException {
        Future<ConditionTree> f = (FutureTask<ConditionTree>)this.entity2tree.get(userId);
        if (null == f) {
            FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(userId, LOG));
            f = this.entity2tree.putIfAbsent(userId, ft);
            if (null == f) {
                ft.run();
                f = ft;
            }
        }
        ModulesCondition condition = new ModulesCondition(accessibleModules);
        TIntSet set = this.getFrom(f).getVisibleFolderIds(condition);
        if (!set.isEmpty() && set.contains(folderId)) {
            return true;
        }
        if (null != groups) {
            for (int group : groups) {
                f = (Future)this.entity2tree.get(group);
                if (null == f) {
                    FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(group, LOG));
                    f = this.entity2tree.putIfAbsent(group, ft);
                    if (null == f) {
                        ft.run();
                        f = ft;
                    }
                }
                if ((set = this.getFrom(f).getVisibleFolderIds(condition)).isEmpty() || !set.contains(folderId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasSharedFolder(int userId, int[] groups, int[] accessibleModules) throws OXException {
        Future<ConditionTree> f = (FutureTask<ConditionTree>)this.entity2tree.get(userId);
        if (null == f) {
            FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(userId, LOG));
            f = this.entity2tree.putIfAbsent(userId, ft);
            if (null == f) {
                ft.run();
                f = ft;
            }
        }
        CombinedCondition condition = new CombinedCondition((Condition)new ModulesCondition(accessibleModules), new TypeCondition(3, userId));
        TIntSet set = this.getFrom(f).getVisibleFolderIds(condition);
        if (null != set && !set.isEmpty()) {
            return true;
        }
        if (null != groups) {
            for (int group : groups) {
                ConditionTree conditionTree;
                f = (Future)this.entity2tree.get(group);
                if (null == f) {
                    FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(group, LOG));
                    f = this.entity2tree.putIfAbsent(group, ft);
                    if (null == f) {
                        ft.run();
                        f = ft;
                    }
                }
                if (null == (conditionTree = this.getFrom(f)) || conditionTree.getVisibleFolderIds(condition).isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    public TIntSet getVisibleTypeForUser(int userId, int[] groups, int[] accessibleModules, int type) throws OXException {
        Future<ConditionTree> f = (FutureTask<ConditionTree>)this.entity2tree.get(userId);
        if (null == f) {
            FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(userId, LOG));
            f = this.entity2tree.putIfAbsent(userId, ft);
            if (null == f) {
                ft.run();
                f = ft;
            }
        }
        CombinedCondition condition = new CombinedCondition((Condition)new ModulesCondition(accessibleModules), new TypeCondition(type, userId));
        TIntSet set = this.getFrom(f).getVisibleFolderIds(condition);
        if (null == set) {
            set = new TIntHashSet();
        }
        if (null != groups) {
            for (int group : groups) {
                ConditionTree conditionTree;
                f = (Future)this.entity2tree.get(group);
                if (null == f) {
                    FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(group, LOG));
                    f = this.entity2tree.putIfAbsent(group, ft);
                    if (null == f) {
                        ft.run();
                        f = ft;
                    }
                }
                if (null == (conditionTree = this.getFrom(f))) continue;
                set.addAll((TIntCollection)conditionTree.getVisibleFolderIds(condition));
            }
        }
        return set;
    }

    public TIntSet getVisibleModuleForUser(int userId, int[] groups, int[] accessibleModules, int module) throws OXException {
        TIntSet set;
        TIntHashSet modules;
        if (null != accessibleModules && !(modules = new TIntHashSet(accessibleModules)).contains(module)) {
            return EMPTY_SET;
        }
        ModuleCondition condition = ModuleCondition.moduleCondition(module);
        Future<ConditionTree> f = (FutureTask<ConditionTree>)this.entity2tree.get(userId);
        if (null == f) {
            FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(userId, LOG));
            f = this.entity2tree.putIfAbsent(userId, ft);
            if (null == f) {
                ft.run();
                f = ft;
            }
        }
        if (null == (set = this.getFrom(f).getVisibleFolderIds(condition))) {
            set = new TIntHashSet();
        }
        if (null != groups) {
            for (int group : groups) {
                ConditionTree ct;
                f = (Future)this.entity2tree.get(group);
                if (null == f) {
                    FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(group, LOG));
                    f = this.entity2tree.putIfAbsent(group, ft);
                    if (null == f) {
                        ft.run();
                        f = ft;
                    }
                }
                if (null == (ct = this.getFrom(f))) continue;
                set.addAll((TIntCollection)ct.getVisibleFolderIds(condition));
            }
        }
        return set;
    }

    public TIntSet getVisibleForUser(int userId, int[] groups, int[] accessibleModules, int module, int type) throws OXException {
        TIntSet set;
        TIntHashSet modules;
        if (null != accessibleModules && !(modules = new TIntHashSet(accessibleModules)).contains(module)) {
            return EMPTY_SET;
        }
        CombinedCondition condition = new CombinedCondition(ModuleCondition.moduleCondition(module), new TypeCondition(type, userId));
        Future<ConditionTree> f = (FutureTask<ConditionTree>)this.entity2tree.get(userId);
        if (null == f) {
            FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(userId, LOG));
            f = this.entity2tree.putIfAbsent(userId, ft);
            if (null == f) {
                ft.run();
                f = ft;
            }
        }
        if (null == (set = this.getFrom(f).getVisibleFolderIds(condition))) {
            set = new TIntHashSet();
        }
        if (null != groups) {
            for (int group : groups) {
                ConditionTree conditionTree;
                f = (Future)this.entity2tree.get(group);
                if (null == f) {
                    FutureTask<ConditionTree> ft = new FutureTask<ConditionTree>(new InitEntityCallable(group, LOG));
                    f = this.entity2tree.putIfAbsent(group, ft);
                    if (null == f) {
                        ft.run();
                        f = ft;
                    }
                }
                if (null == (conditionTree = this.getFrom(f))) continue;
                set.addAll((TIntCollection)conditionTree.getVisibleFolderIds(condition));
            }
        }
        return set;
    }

    public static List<FolderObject> asList(TIntSet set, Context ctx) throws OXException {
        return ConditionTreeMap.asList(set, ctx, null);
    }

    public static List<FolderObject> asList(TIntSet set, Context ctx, Connection con) throws OXException {
        if (null == set || set.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            TIntObjectHashMap m = new TIntObjectHashMap(set.size());
            TIntHashSet toLoad = new TIntHashSet((TIntCollection)set);
            FolderCacheManager cacheManager = FolderCacheManager.getInstance();
            boolean cacheEnabled = FolderCacheManager.isEnabled();
            if (cacheEnabled) {
                for (FolderObject fo : cacheManager.getTrimedFolderObjects(set.toArray(), ctx)) {
                    int objectID = fo.getObjectID();
                    toLoad.remove(objectID);
                    m.put(objectID, (Object)fo);
                }
            }
            if (!toLoad.isEmpty()) {
                if (null == con) {
                    ConditionTreeMap.loadBy((TIntSet)toLoad, (TIntObjectMap<FolderObject>)m, cacheEnabled, cacheManager, ctx);
                } else {
                    ConditionTreeMap.loadBy((TIntSet)toLoad, (TIntObjectMap<FolderObject>)m, cacheEnabled, cacheManager, ctx, con);
                }
            }
            ArrayList<FolderObject> list = new ArrayList<FolderObject>(m.size());
            TIntProcedure procedure = new TIntProcedure((TIntObjectMap)m, list){
                final /* synthetic */ TIntObjectMap val$m;
                final /* synthetic */ List val$list;
                {
                    this.val$m = tIntObjectMap;
                    this.val$list = list;
                }

                public boolean execute(int folderId) {
                    try {
                        FolderObject fo = (FolderObject)this.val$m.get(folderId);
                        if (null != fo) {
                            this.val$list.add(fo);
                        }
                        return true;
                    }
                    catch (Exception e) {
                        throw new ProcedureFailedException(e);
                    }
                }
            };
            set.forEach(procedure);
            return list;
        }
        catch (ProcedureFailedException e) {
            Throwable cause = e.getCause();
            if (cause instanceof OXException) {
                throw (OXException)cause;
            }
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(cause, cause.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadBy(TIntSet toLoad, TIntObjectMap<FolderObject> m, boolean cacheEnabled, FolderCacheManager cacheManager, Context ctx) throws OXException {
        DatabaseService service = ServerServiceRegistry.getInstance().getService(DatabaseService.class);
        Connection con = null;
        try {
            con = service.getReadOnly(ctx);
            ConditionTreeMap.loadBy(toLoad, m, cacheEnabled, cacheManager, ctx, con);
        }
        finally {
            if (null != con) {
                service.backReadOnly(ctx, con);
            }
        }
    }

    private static void loadBy(TIntSet toLoad, TIntObjectMap<FolderObject> m, boolean cacheEnabled, final FolderCacheManager cacheManager, final Context ctx, Connection con) throws OXException {
        if (null == con) {
            ConditionTreeMap.loadBy(toLoad, m, cacheEnabled, cacheManager, ctx);
            return;
        }
        List<FolderObject> loaded = OXFolderBatchLoader.loadFolderObjectsFromDB(toLoad.toArray(), ctx, con, true, true);
        if (cacheEnabled) {
            final ArrayList<FolderObject> tmp = new ArrayList<FolderObject>(loaded);
            ThreadPools.getThreadPool().submit((Task)new AbstractTask<Void>(){

                public Void call() throws Exception {
                    for (FolderObject fo : tmp) {
                        if (null == fo) continue;
                        cacheManager.putFolderObject(fo, ctx, false, null);
                    }
                    return null;
                }
            });
        }
        for (FolderObject fo : loaded) {
            if (null == fo) continue;
            m.put(fo.getObjectID(), (Object)fo);
        }
    }

    protected static FolderObject getFolderObject(int folderId, Context ctx, Connection con) throws OXException {
        if (!FolderCacheManager.isEnabled()) {
            return FolderObject.loadFolderObjectFromDB(folderId, ctx, con, true, true);
        }
        FolderCacheManager cacheManager = FolderCacheManager.getInstance();
        FolderObject fo = cacheManager.getFolderObject(folderId, ctx);
        if (null == fo) {
            fo = FolderObject.loadFolderObjectFromDB(folderId, ctx, con, true, true);
            cacheManager.putFolderObject(fo, ctx, false, null);
        }
        return fo;
    }

    protected ConditionTree getFrom(Future<ConditionTree> f) throws OXException {
        if (null == f) {
            return null;
        }
        try {
            return f.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, e.getMessage());
        }
        catch (ExecutionException e) {
            throw (OXException)((Object)ThreadPools.launderThrowable((ExecutionException)e, OXException.class));
        }
    }

    protected ConditionTree timedFrom(Future<ConditionTree> f, long timeoutMillis) throws OXException {
        if (null == f) {
            return null;
        }
        try {
            return f.get(timeoutMillis, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, e.getMessage());
        }
        catch (ExecutionException e) {
            throw (OXException)((Object)ThreadPools.launderThrowable((ExecutionException)e, OXException.class));
        }
        catch (TimeoutException e) {
            return null;
        }
    }

    private final class InitEntityCallable
    implements Callable<ConditionTree> {
        private final int entity;
        private final Logger logger;

        protected InitEntityCallable(int entity, Logger logger) {
            this.entity = entity;
            this.logger = logger;
        }

        @Override
        public ConditionTree call() throws OXException {
            try {
                return ConditionTreeMap.this.newTreeForEntity(this.entity);
            }
            catch (OXException e) {
                this.logger.warn("", (Throwable)e);
                throw e;
            }
            catch (RuntimeException e) {
                this.logger.error("", (Throwable)e);
                throw OXFolderExceptionCode.RUNTIME_ERROR.create(e, e.getMessage());
            }
        }
    }

    private final class NewTreeCallable
    implements Callable<ConditionTree> {
        protected NewTreeCallable() {
        }

        @Override
        public ConditionTree call() {
            return new ConditionTree();
        }
    }

    private static final class ProcedureFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1821041261492515385L;

        protected ProcedureFailedException(Throwable cause) {
            super(cause);
        }
    }

    public static final class LastModifiedCondition
    implements Condition {
        private final long lastModified;

        public LastModifiedCondition(long lastModified) {
            this.lastModified = lastModified;
        }

        @Override
        public boolean fulfilled(Permission p) {
            return p.lastModified > this.lastModified;
        }
    }

    public static final class ModulesCondition
    implements Condition {
        private final TIntSet accessibleModules;

        public ModulesCondition(int[] accessibleModules) {
            this.accessibleModules = new TIntHashSet(accessibleModules);
        }

        public ModulesCondition(TIntCollection accessibleModules) {
            this.accessibleModules = new TIntHashSet(accessibleModules);
        }

        @Override
        public boolean fulfilled(Permission p) {
            return this.accessibleModules.contains(p.module);
        }
    }

    public static final class ModuleCondition
    implements Condition {
        private static final ConcurrentMap<Integer, ModuleCondition> conditions = new ConcurrentHashMap<Integer, ModuleCondition>(8);
        private final int module;

        static ModuleCondition moduleCondition(int module) {
            ModuleCondition nmc;
            Integer key = module;
            ModuleCondition mc = (ModuleCondition)conditions.get(key);
            if (null == mc && (mc = conditions.putIfAbsent(key, nmc = new ModuleCondition(module))) == null) {
                mc = nmc;
            }
            return mc;
        }

        private ModuleCondition(int module) {
            this.module = module;
        }

        @Override
        public boolean fulfilled(Permission p) {
            return this.module == p.module;
        }
    }

    public static final class TypeCondition
    implements Condition {
        private final int type;
        private final int userId;

        public TypeCondition(int type, int userId) {
            if (3 == type) {
                this.userId = userId;
                this.type = 1;
            } else {
                this.userId = -1;
                this.type = type;
            }
        }

        @Override
        public boolean fulfilled(Permission p) {
            return p.type == this.type && (this.userId < 0 || p.creator != this.userId);
        }
    }

    public static final class CreatorCondition
    implements Condition {
        private final int creator;

        public CreatorCondition(int creator) {
            this.creator = creator;
        }

        @Override
        public boolean fulfilled(Permission p) {
            return p.creator == this.creator;
        }
    }

    public static final class ParentCondition
    implements Condition {
        private final int parent;

        public ParentCondition(int parent) {
            this.parent = parent;
        }

        @Override
        public boolean fulfilled(Permission p) {
            return p.parent == this.parent;
        }
    }

    public static final class PrivateCondition
    implements Condition {
        private final int userId;

        public PrivateCondition(int userId) {
            this.userId = userId;
        }

        @Override
        public boolean fulfilled(Permission p) {
            return 1 == p.type && p.creator == this.userId;
        }
    }

    private static final class CombinedCondition
    implements Condition {
        private final List<Condition> conditions;

        protected CombinedCondition(Condition first, Condition ... others) {
            if (null != others) {
                this.conditions = new ArrayList<Condition>(others.length + 1);
                this.conditions.add(first);
                this.conditions.addAll(Arrays.asList(others));
            } else {
                this.conditions = new ArrayList<Condition>(1);
                this.conditions.add(first);
            }
        }

        public CombinedCondition(ModulesCondition first, Collection<Condition> conditions) {
            this.conditions = new ArrayList<Condition>(conditions.size() + 1);
            this.conditions.add(first);
            this.conditions.addAll(conditions);
        }

        @Override
        public boolean fulfilled(Permission p) {
            for (Condition condition : this.conditions) {
                if (condition.fulfilled(p)) continue;
                return false;
            }
            return true;
        }
    }
}

