/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.images.transformations;

import com.openexchange.threadpool.ThreadPools;
import com.openexchange.tools.images.scheduler.Scheduler;
import com.openexchange.tools.images.transformations.ImageTransformationsImpl;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public final class ImageTransformationsTask
extends ImageTransformationsImpl {
    private static final ThreadPools.ExpectedExceptionFactory<IOException> EXCEPTION_FACTORY = new ThreadPools.ExpectedExceptionFactory<IOException>(){

        public Class<IOException> getType() {
            return IOException.class;
        }

        public IOException newUnexpectedError(Throwable t) {
            return new IOException(t);
        }
    };

    public ImageTransformationsTask(BufferedImage sourceImage, Object optSource) {
        super(sourceImage, optSource);
    }

    public ImageTransformationsTask(InputStream sourceImageStream, Object optSource) {
        super(sourceImageStream, optSource);
    }

    @Override
    protected BufferedImage getImage(String formatName) throws IOException {
        FutureTask<BufferedImage> ft = new FutureTask<BufferedImage>(new CallableImpl(formatName));
        boolean success = Scheduler.getInstance().execute(this.optSource, ft);
        if (!success) {
            throw new IOException("Image transformation rejected");
        }
        return (BufferedImage)ThreadPools.getFrom(ft, EXCEPTION_FACTORY);
    }

    protected BufferedImage doGetImage(String formatName) throws IOException {
        return super.getImage(formatName);
    }

    private final class CallableImpl
    implements Callable<BufferedImage> {
        private final String formatName;

        CallableImpl(String formatName) {
            this.formatName = formatName;
        }

        @Override
        public BufferedImage call() throws Exception {
            return ImageTransformationsTask.this.doGetImage(this.formatName);
        }
    }
}

