/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file.osgi;

import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.QuotaFileStorage;
import com.openexchange.tools.file.external.FileStorageFactory;
import com.openexchange.tools.file.external.QuotaFileStorageFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class FileStorageWrapperActivator
implements BundleActivator {
    private ServiceTracker<FileStorageFactory, FileStorageFactory> FSTracker;
    private ServiceTracker<QuotaFileStorageFactory, QuotaFileStorageFactory> QFSTracker;

    public void start(BundleContext context) throws Exception {
        this.FSTracker = new ServiceTracker(context, FileStorageFactory.class, (ServiceTrackerCustomizer)new FSTrackerCustomizer(context));
        this.QFSTracker = new ServiceTracker(context, QuotaFileStorageFactory.class, (ServiceTrackerCustomizer)new QFSTrackerCustomizer(context));
        this.FSTracker.open();
        this.QFSTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.FSTracker.close();
        this.QFSTracker.close();
    }

    private static class QFSTrackerCustomizer
    implements ServiceTrackerCustomizer<QuotaFileStorageFactory, QuotaFileStorageFactory> {
        private final BundleContext context;

        public QFSTrackerCustomizer(BundleContext context) {
            this.context = context;
        }

        public QuotaFileStorageFactory addingService(ServiceReference<QuotaFileStorageFactory> reference) {
            QuotaFileStorageFactory service = (QuotaFileStorageFactory)this.context.getService(reference);
            QuotaFileStorage.setQuotaFileStorageStarter(service);
            return service;
        }

        public void modifiedService(ServiceReference<QuotaFileStorageFactory> reference, QuotaFileStorageFactory service) {
        }

        public void removedService(ServiceReference<QuotaFileStorageFactory> reference, QuotaFileStorageFactory service) {
            QuotaFileStorage.setQuotaFileStorageStarter(null);
            this.context.ungetService(reference);
        }
    }

    private static class FSTrackerCustomizer
    implements ServiceTrackerCustomizer<FileStorageFactory, FileStorageFactory> {
        private final BundleContext context;

        public FSTrackerCustomizer(BundleContext context) {
            this.context = context;
        }

        public FileStorageFactory addingService(ServiceReference<FileStorageFactory> reference) {
            FileStorageFactory service = (FileStorageFactory)this.context.getService(reference);
            FileStorage.setFileStorageStarter(service);
            return service;
        }

        public void modifiedService(ServiceReference<FileStorageFactory> reference, FileStorageFactory service) {
        }

        public void removedService(ServiceReference<FileStorageFactory> reference, FileStorageFactory service) {
            FileStorage.setFileStorageStarter(null);
            this.context.ungetService(reference);
        }
    }
}

