/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.tools.file;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.contexts.Context;
import com.openexchange.tools.file.FileStorage;
import com.openexchange.tools.file.external.FileStorageCodes;
import com.openexchange.tools.file.external.QuotaFileStorageFactory;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.SortedSet;

public final class QuotaFileStorage
extends FileStorage {
    private static volatile QuotaFileStorageFactory qfss;
    private com.openexchange.tools.file.external.QuotaFileStorage delegateQuotaFileStorage;

    public static final QuotaFileStorage getInstance(URI uri, Context ctx) throws OXException {
        QuotaFileStorageFactory factory = qfss;
        if (factory == null) {
            throw FileStorageCodes.INSTANTIATIONERROR.create("No quota file storage starter registered.");
        }
        return new QuotaFileStorage(uri, ctx, factory);
    }

    public static void setQuotaFileStorageStarter(QuotaFileStorageFactory qfss) {
        QuotaFileStorage.qfss = qfss;
    }

    private QuotaFileStorage(URI uri, Context ctx, QuotaFileStorageFactory qfss) throws OXException {
        this.delegateQuotaFileStorage = qfss.getQuotaFileStorage(ctx, uri);
    }

    private com.openexchange.tools.file.external.QuotaFileStorage getDelegateQuotaFileStorage() {
        com.openexchange.tools.file.external.QuotaFileStorage tmp = this.delegateQuotaFileStorage;
        if (null == tmp) {
            throw new IllegalStateException("QuotaFileStorage has already been closed.");
        }
        return tmp;
    }

    public long getUsage() throws OXException {
        return this.getDelegateQuotaFileStorage().getUsage();
    }

    public void recalculateUsage() throws OXException {
        this.getDelegateQuotaFileStorage().recalculateUsage();
    }

    public void recalculateUsage(Set<String> filesToIgnore) throws OXException {
        this.getDelegateQuotaFileStorage().recalculateUsage(filesToIgnore);
    }

    public long getQuota() {
        return this.getDelegateQuotaFileStorage().getQuota();
    }

    @Override
    public boolean deleteFile(String identifier) throws OXException {
        return this.getDelegateQuotaFileStorage().deleteFile(identifier);
    }

    @Override
    public Set<String> deleteFiles(String[] identifiers) throws OXException {
        if (null == identifiers || 0 == identifiers.length) {
            return Collections.emptySet();
        }
        return this.getDelegateQuotaFileStorage().deleteFiles(identifiers);
    }

    @Override
    public InputStream getFile(String name) throws OXException {
        return this.getDelegateQuotaFileStorage().getFile(name);
    }

    @Override
    public SortedSet<String> getFileList() throws OXException {
        return this.getDelegateQuotaFileStorage().getFileList();
    }

    @Override
    public long getFileSize(String name) throws OXException {
        return this.getDelegateQuotaFileStorage().getFileSize(name);
    }

    @Override
    public String getMimeType(String name) throws OXException {
        return this.getDelegateQuotaFileStorage().getMimeType(name);
    }

    @Override
    public void recreateStateFile() throws OXException {
        this.getDelegateQuotaFileStorage().recreateStateFile();
    }

    @Override
    public void remove() throws OXException {
        this.getDelegateQuotaFileStorage().remove();
    }

    @Override
    public String saveNewFile(InputStream file) throws OXException {
        return this.getDelegateQuotaFileStorage().saveNewFile(file);
    }

    public String saveNewFile(InputStream file, long sizeHint) throws OXException {
        return this.getDelegateQuotaFileStorage().saveNewFile(file, sizeHint);
    }

    public long appendToFile(InputStream file, String name, long offset, long sizeHint) throws OXException {
        return this.getDelegateQuotaFileStorage().appendToFile(file, name, offset, sizeHint);
    }

    @Override
    public void close() {
        this.delegateQuotaFileStorage = null;
    }

    @Override
    public long appendToFile(InputStream file, String name, long offset) throws OXException {
        return this.getDelegateQuotaFileStorage().appendToFile(file, name, offset);
    }

    @Override
    public void setFileLength(long length, String name) throws OXException {
        this.getDelegateQuotaFileStorage().setFileLength(length, name);
    }

    @Override
    public InputStream getFile(String name, long offset, long length) throws OXException {
        return this.getDelegateQuotaFileStorage().getFile(name, offset, length);
    }
}

