/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.server.impl;

import com.openexchange.exception.OXException;
import com.openexchange.groupware.userconfiguration.UserConfiguration;
import com.openexchange.groupware.userconfiguration.UserPermissionBits;
import com.openexchange.server.impl.OCLPermission;
import com.openexchange.tools.oxfolder.OXFolderAccess;
import com.openexchange.tools.oxfolder.OXFolderProperties;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectivePermission
extends OCLPermission {
    private static final char CHAR_AT = '@';
    private static final char CHAR_BREAK = '\n';
    private static final char CHAR_PIPE = '|';
    private static final String STR_EFFECTIVE_PERMISSION = "EffectivePermission_";
    private static final String STR_EMPTY = "";
    private static final String STR_ADMIN = "Admin";
    private static final String STR_USER = "User";
    private static final String STR_GROUP = "Group";
    private static final int GAB = 6;
    private static final long serialVersionUID = -1303754404748836561L;
    private static final transient Logger LOG = LoggerFactory.getLogger(EffectivePermission.class);
    private final UserPermissionBits permissionBits;
    private int folderType = -1;
    private int folderModule = -1;
    private final int createdBy;
    private boolean userConfigIsValid;
    private boolean userConfigAlreadyValidated;
    private OCLPermission underlyingPerm;
    private static final int[] SYSTEM_PUBLIC_FOLDERS = new int[]{2, 5, 6};

    public EffectivePermission(int entity, int fuid, int folderType, int folderModule, int createdBy, UserConfiguration userConfig) {
        super(entity, fuid);
        this.folderType = folderType;
        this.folderModule = folderModule;
        this.createdBy = createdBy;
        this.permissionBits = userConfig.getUserPermissionBits();
        this.validateUserConfig();
    }

    public EffectivePermission(int entity, int fuid, int folderType, int folderModule, int createdBy, UserPermissionBits permissionBits) {
        super(entity, fuid);
        this.folderType = folderType;
        this.folderModule = folderModule;
        this.createdBy = createdBy;
        this.permissionBits = permissionBits;
        this.validateUserConfig();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof EffectivePermission)) {
            return false;
        }
        EffectivePermission ep = (EffectivePermission)other;
        if (!super.equals(ep) && this.folderType != ep.folderType && this.folderModule != ep.folderModule) {
            return false;
        }
        if (this.createdBy != ep.createdBy) {
            return false;
        }
        if (null != this.permissionBits) {
            return this.permissionBits.equals(ep.permissionBits);
        }
        return null == ep.permissionBits;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 31 * hash + super.hashCode();
        hash = 31 * hash + this.folderType;
        hash = 31 * hash + this.folderModule;
        hash = 31 * hash + this.createdBy;
        if (null != this.permissionBits) {
            hash = 31 * hash + this.permissionBits.hashCode();
        }
        return hash;
    }

    public boolean hasModuleAccess(int folderModule) {
        if (this.validateUserConfig()) {
            return this.permissionBits.hasModuleAccess(folderModule);
        }
        return true;
    }

    @Override
    public boolean isFolderAdmin() {
        if (this.validateUserConfig()) {
            if (!this.hasModuleAccess(this.folderModule)) {
                return false;
            }
            if (this.folderType == 2 && this.folderModule != 8 && !this.permissionBits.hasFullPublicFolderAccess()) {
                return false;
            }
        }
        return this.folderType == 2 && this.permissionBits.getUserId() == this.createdBy || super.isFolderAdmin();
    }

    @Override
    public void setFolderAdmin(boolean folderAdmin) {
        super.setFolderAdmin(folderAdmin);
        this.underlyingPerm = null;
    }

    @Override
    public void setGroupPermission(boolean groupPermission) {
        super.setGroupPermission(groupPermission);
        this.underlyingPerm = null;
    }

    @Override
    public int getFolderPermission() {
        if (this.validateUserConfig()) {
            if (!this.hasModuleAccess(this.folderModule)) {
                return 0;
            }
            if (this.isPublicFolder()) {
                if (this.folderModule != 8 && !this.permissionBits.hasFullPublicFolderAccess()) {
                    int superFolderPermission = super.getFolderPermission();
                    return superFolderPermission > 2 ? 2 : superFolderPermission;
                }
            } else if (!this.permissionBits.hasFullSharedFolderAccess() && this.folderType == 3) {
                return 0;
            }
        }
        return super.getFolderPermission();
    }

    @Override
    public boolean setFolderPermission(int fp) {
        this.underlyingPerm = null;
        return super.setFolderPermission(fp);
    }

    @Override
    public int getReadPermission() {
        if (this.validateUserConfig()) {
            if (!this.hasModuleAccess(this.folderModule)) {
                return 0;
            }
            if (this.isPublicFolder()) {
                if (this.folderModule != 8 && !this.permissionBits.hasFullPublicFolderAccess()) {
                    int superReadPermission = super.getReadPermission();
                    return superReadPermission > 4 ? 4 : superReadPermission;
                }
            } else if (!this.permissionBits.hasFullSharedFolderAccess() && this.folderType == 3) {
                return 0;
            }
        }
        return super.getReadPermission();
    }

    @Override
    public boolean setReadObjectPermission(int p) {
        this.underlyingPerm = null;
        return super.setReadObjectPermission(p);
    }

    @Override
    public int getWritePermission() {
        if (6 == this.getFuid()) {
            int writePermission = super.getWritePermission();
            return OXFolderProperties.isEnableInternalUsersEdit() ? (writePermission <= 0 ? 2 : writePermission) : 0;
        }
        if (this.validateUserConfig()) {
            if (!this.hasModuleAccess(this.folderModule)) {
                return 0;
            }
            if (this.isPublicFolder() ? this.folderModule != 8 && !this.permissionBits.hasFullPublicFolderAccess() : !this.permissionBits.hasFullSharedFolderAccess() && this.folderType == 3) {
                return 0;
            }
        }
        return super.getWritePermission();
    }

    @Override
    public boolean setWriteObjectPermission(int p) {
        this.underlyingPerm = null;
        return super.setWriteObjectPermission(p);
    }

    @Override
    public int getDeletePermission() {
        if (this.validateUserConfig()) {
            if (!this.hasModuleAccess(this.folderModule)) {
                return 0;
            }
            if (this.isPublicFolder() ? this.folderModule != 8 && !this.permissionBits.hasFullPublicFolderAccess() : !this.permissionBits.hasFullSharedFolderAccess() && this.folderType == 3) {
                return 0;
            }
        }
        return super.getDeletePermission();
    }

    @Override
    public boolean setDeleteObjectPermission(int p) {
        this.underlyingPerm = null;
        return super.setDeleteObjectPermission(p);
    }

    @Override
    public void setEntity(int entity) {
        this.underlyingPerm = null;
        super.setEntity(entity);
    }

    @Override
    public void setFuid(int fuid) {
        this.underlyingPerm = null;
        super.setFuid(fuid);
    }

    private boolean isPublicFolder() {
        return this.folderType == 2 || Arrays.binarySearch(SYSTEM_PUBLIC_FOLDERS, this.getFuid()) >= 0;
    }

    private final boolean validateUserConfig() {
        if (this.userConfigAlreadyValidated) {
            return this.userConfigIsValid;
        }
        this.userConfigAlreadyValidated = true;
        this.userConfigIsValid = false;
        if (this.permissionBits == null) {
            return this.userConfigIsValid;
        }
        try {
            int fuid = this.getFuid();
            if (fuid <= 0) {
                return this.userConfigIsValid;
            }
            OXFolderAccess folderAccess = null;
            if (this.folderType <= 0) {
                folderAccess = new OXFolderAccess(this.permissionBits.getContext());
                this.folderType = folderAccess.getFolderType(fuid, this.permissionBits.getUserId());
            }
            if (this.folderModule <= 0) {
                if (folderAccess == null) {
                    folderAccess = new OXFolderAccess(this.permissionBits.getContext());
                }
                this.folderModule = folderAccess.getFolderModule(fuid);
            }
        }
        catch (OXException e) {
            LOG.error(STR_EMPTY, (Throwable)e);
            return this.userConfigIsValid;
        }
        if (this.permissionBits.getUserId() == this.getEntity()) {
            this.userConfigIsValid = true;
        } else {
            int[] groups = this.permissionBits.getGroups();
            for (int i = 0; i < groups.length && !this.userConfigIsValid; ++i) {
                this.userConfigIsValid = groups[i] == this.getEntity();
            }
        }
        return this.userConfigIsValid;
    }

    @Override
    public boolean isFolderVisible() {
        return this.isFolderAdmin() || this.getFolderPermission() >= 2;
    }

    @Override
    public boolean canCreateObjects() {
        return this.getFolderPermission() >= 4;
    }

    @Override
    public boolean canCreateSubfolders() {
        return this.getFolderPermission() >= 8;
    }

    @Override
    public boolean canReadOwnObjects() {
        return this.getReadPermission() >= 2;
    }

    @Override
    public boolean canReadAllObjects() {
        return this.getReadPermission() >= 4;
    }

    @Override
    public boolean canWriteOwnObjects() {
        return this.getWritePermission() >= 2;
    }

    @Override
    public boolean canWriteAllObjects() {
        return this.getWritePermission() >= 4;
    }

    @Override
    public boolean canDeleteOwnObjects() {
        return this.getDeletePermission() >= 2;
    }

    @Override
    public boolean canDeleteAllObjects() {
        return this.getDeletePermission() >= 4;
    }

    public OCLPermission getUnderlyingPermission() {
        if (this.underlyingPerm == null) {
            this.underlyingPerm = new OCLPermission();
            this.underlyingPerm.setEntity(super.getEntity());
            this.underlyingPerm.setFuid(super.getFuid());
            this.underlyingPerm.setFolderPermission(super.getFolderPermission());
            this.underlyingPerm.setReadObjectPermission(super.getReadPermission());
            this.underlyingPerm.setWriteObjectPermission(super.getWritePermission());
            this.underlyingPerm.setDeleteObjectPermission(super.getDeletePermission());
            this.underlyingPerm.setFolderAdmin(super.isFolderAdmin());
            this.underlyingPerm.setGroupPermission(super.isGroupPermission());
        }
        return this.underlyingPerm;
    }

    @Override
    public String toString() {
        return new StringBuilder(150).append(STR_EFFECTIVE_PERMISSION).append(this.isFolderAdmin() ? STR_ADMIN : STR_EMPTY).append(this.isGroupPermission() ? STR_GROUP : STR_USER).append('@').append(this.getFolderPermission()).append('|').append(this.getReadPermission()).append('|').append(this.getWritePermission()).append('|').append(this.getDeletePermission()).append('\n').append(super.toString()).toString();
    }
}

