/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.transport.config;

import com.openexchange.mail.transport.config.ITransportProperties;
import com.openexchange.mail.transport.config.TransportProperties;
import com.openexchange.mailaccount.MailAccount;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailAccountTransportProperties
implements ITransportProperties {
    private static final Logger LOG = LoggerFactory.getLogger(MailAccountTransportProperties.class);
    protected final Map<String, String> properties;

    public MailAccountTransportProperties(MailAccount mailAccount) {
        if (null == mailAccount) {
            throw new IllegalArgumentException("mail account is null.");
        }
        this.properties = mailAccount.getProperties();
    }

    @Override
    public int getReferencedPartLimit() {
        String referencedPartLimitStr = this.properties.get("com.openexchange.mail.transport.referencedPartLimit");
        if (null == referencedPartLimitStr) {
            return TransportProperties.getInstance().getReferencedPartLimit();
        }
        try {
            return Integer.parseInt(referencedPartLimitStr);
        }
        catch (NumberFormatException e) {
            LOG.error("Referenced Part Limit: Invalid value.", (Throwable)e);
            return TransportProperties.getInstance().getReferencedPartLimit();
        }
    }
}

