/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.mail.parser.handlers;

import com.openexchange.exception.OXException;
import com.openexchange.mail.dataobjects.MailMessage;
import com.openexchange.mail.dataobjects.MailPart;
import com.openexchange.mail.dataobjects.UUEncodedAttachmentMailPart;
import com.openexchange.mail.mime.ContentType;
import com.openexchange.mail.mime.MessageHeaders;
import com.openexchange.mail.mime.MimeType2ExtMap;
import com.openexchange.mail.parser.MailMessageHandler;
import com.openexchange.mail.uuencode.UUEncodedPart;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.InternetAddress;

public final class NonInlineForwardPartHandler
implements MailMessageHandler {
    private final List<MailPart> nonInlineParts;
    private final Set<String> imageContentIds;
    private boolean iCalendarContent = false;
    private static final String APPLICATION = "application/";

    public NonInlineForwardPartHandler() {
        this.nonInlineParts = new ArrayList<MailPart>();
        this.imageContentIds = new HashSet<String>(1);
    }

    public NonInlineForwardPartHandler(List<MailPart> nonInlineParts) {
        this.nonInlineParts = nonInlineParts;
        this.imageContentIds = new HashSet<String>(1);
    }

    public boolean hasCalendarContent() {
        return this.iCalendarContent;
    }

    public List<MailPart> getNonInlineParts() {
        return this.nonInlineParts;
    }

    public void setImageContentIds(Collection<String> imageContentIds) {
        this.imageContentIds.clear();
        this.imageContentIds.addAll(imageContentIds);
    }

    @Override
    public boolean handleMultipartEnd(MailPart mp, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleAttachment(MailPart part, boolean isInline, String baseContentType, String fileName, String id) throws OXException {
        if (!isInline || part.getContentDisposition().containsFilenameParameter() || part.getHeader(MessageHeaders.HDR_CONTENT_ID) != null || part.getContentType().startsWith(APPLICATION)) {
            this.nonInlineParts.add(part);
        }
        return true;
    }

    @Override
    public boolean handleBccRecipient(InternetAddress[] recipientAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleCcRecipient(InternetAddress[] recipientAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleColorLabel(int colorLabel) throws OXException {
        return true;
    }

    @Override
    public boolean handleContentId(String contentId) throws OXException {
        return true;
    }

    @Override
    public boolean handleDispositionNotification(InternetAddress dispositionNotificationTo, boolean seen) throws OXException {
        return true;
    }

    @Override
    public boolean handleFrom(InternetAddress[] fromAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleHeaders(int size, Iterator<Map.Entry<String, String>> iter) throws OXException {
        return true;
    }

    @Override
    public boolean handleImagePart(MailPart part, String imageCID, String baseContentType, boolean isInline, String fileName, String id) throws OXException {
        if (imageCID == null && (!isInline || part.getContentDisposition().containsFilenameParameter())) {
            this.nonInlineParts.add(part);
        } else if (imageCID != null && !this.imageContentIds.contains(NonInlineForwardPartHandler.prepareContentId(imageCID))) {
            this.nonInlineParts.add(part);
        }
        return true;
    }

    private static String prepareContentId(String contentId) {
        int lastIndex;
        if (null == contentId) {
            return null;
        }
        String cid = contentId;
        if (cid.charAt(0) == '<') {
            cid = cid.substring(1);
        }
        if (cid.charAt(lastIndex = cid.length() - 1) == '>') {
            cid = cid.substring(0, lastIndex);
        }
        return cid;
    }

    @Override
    public boolean handleInlineHtml(String htmlContent, ContentType contentType, long size, String fileName, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleInlinePlainText(String plainTextContent, ContentType contentType, long size, String fileName, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedAttachment(UUEncodedPart part, String id) throws OXException {
        UUEncodedAttachmentMailPart mailPart = new UUEncodedAttachmentMailPart(part);
        String ct = MimeType2ExtMap.getContentType(part.getFileName());
        if (ct == null || ct.length() == 0) {
            ct = "application/octet-stream";
        }
        mailPart.setContentType(ct);
        mailPart.setSize(part.getFileSize());
        mailPart.setFileName(part.getFileName());
        mailPart.setSequenceId(id);
        this.nonInlineParts.add(mailPart);
        return true;
    }

    @Override
    public boolean handleInlineUUEncodedPlainText(String decodedTextContent, ContentType contentType, int size, String fileName, String id) throws OXException {
        return true;
    }

    @Override
    public void handleMessageEnd(MailMessage mail) throws OXException {
    }

    @Override
    public boolean handleMsgRef(String msgRef) throws OXException {
        return true;
    }

    @Override
    public boolean handleMultipart(MailPart mp, int bodyPartCount, String id) throws OXException {
        return true;
    }

    @Override
    public boolean handleNestedMessage(MailPart mailPart, String id) throws OXException {
        mailPart.getContentDisposition().setDisposition("attachment");
        this.nonInlineParts.add(mailPart);
        return true;
    }

    @Override
    public boolean handlePriority(int priority) throws OXException {
        return true;
    }

    @Override
    public boolean handleReceivedDate(Date receivedDate) throws OXException {
        return true;
    }

    @Override
    public boolean handleSentDate(Date sentDate) throws OXException {
        return true;
    }

    @Override
    public boolean handleSpecialPart(MailPart part, String baseContentType, String fileName, String id) throws OXException {
        if (baseContentType.startsWith("text/")) {
            this.nonInlineParts.add(part);
        } else {
            String disposition;
            String string = part.getContentDisposition() == null ? (part.getFileName() == null ? "inline" : "attachment") : (disposition = part.getContentDisposition().getDisposition());
            if (!"inline".equalsIgnoreCase(disposition)) {
                this.nonInlineParts.add(part);
            }
        }
        if (baseContentType.indexOf("calendar") >= 0 || baseContentType.indexOf("ics") >= 0) {
            this.iCalendarContent = true;
        }
        return true;
    }

    @Override
    public boolean handleSubject(String subject) throws OXException {
        return true;
    }

    @Override
    public boolean handleSystemFlags(int flags) throws OXException {
        return true;
    }

    @Override
    public boolean handleToRecipient(InternetAddress[] recipientAddrs) throws OXException {
        return true;
    }

    @Override
    public boolean handleUserFlags(String[] userFlags) throws OXException {
        return true;
    }
}

